/*
 * Copyright 2007-2016 United States Government as represented by the
 * Administrator of The National Aeronautics and Space Administration.
 * No copyright is claimed in the United States under Title 17, U.S. Code.
 * All Rights Reserved.
 */


/**  @file gmsec4_cpp.h
 *
 * @brief This file contains includes for all required header files for the C++ 4.x API
*/

#ifndef GMSEC4_CPP_H
#define GMSEC4_CPP_H

#include <gmsec4_defs.h>

#include <gmsec4/Callback.h>
#include <gmsec4/ConfigFile.h>
#include <gmsec4/ConfigFileIterator.h>
#include <gmsec4/Config.h>
#include <gmsec4/Connection.h>
#include <gmsec4/Errors.h>
#include <gmsec4/EventCallback.h>
#include <gmsec4/Exception.h>
#include <gmsec4/Fields.h>
#include <gmsec4/Message.h>
#include <gmsec4/MessageFieldIterator.h>
#include <gmsec4/ReplyCallback.h>
#include <gmsec4/Status.h>
#include <gmsec4/SubscriptionInfo.h>

#include <gmsec4/mist/ConnectionManagerCallback.h>
#include <gmsec4/mist/ConnectionManagerEventCallback.h>
#include <gmsec4/mist/ConnectionManager.h>
#include <gmsec4/mist/ConnectionManagerReplyCallback.h>
#include <gmsec4/mist/Device.h>
#include <gmsec4/mist/DeviceMessage.h>                          // DEPRECATED
#include <gmsec4/mist/DeviceParam.h>
#include <gmsec4/mist/mist_defs.h>
#include <gmsec4/mist/Mnemonic.h>
#include <gmsec4/mist/MnemonicMessage.h>                        // DEPRECATED
#include <gmsec4/mist/MnemonicSample.h>
#include <gmsec4/mist/ProductFile.h>
#include <gmsec4/mist/ProductFileMessage.h>                     // DEPRECATED
#include <gmsec4/mist/SchemaIDIterator.h>
#include <gmsec4/mist/ServiceParam.h>
#include <gmsec4/mist/Specification.h>

#include <gmsec4/mist/message/DeviceMessage.h>
#include <gmsec4/mist/message/MistMessage.h>
#include <gmsec4/mist/message/MnemonicMessage.h>
#include <gmsec4/mist/message/ProductFileMessage.h>

#include <gmsec4/util/Atomics.h>
#include <gmsec4/util/BoundedQueue.h>
#include <gmsec4/util/Buffer.h>
#include <gmsec4/util/Condition.h>
#include <gmsec4/util/CountDownLatch.h>
#include <gmsec4/util/DataList.h>
#include <gmsec4/util/Log.h>
#include <gmsec4/util/LoggerStream.h>
#include <gmsec4/util/LogHandler.h>
#include <gmsec4/util/LogStream.h>
#include <gmsec4/util/Mutex.h>
#include <gmsec4/util/StdSharedPtr.h>
#include <gmsec4/util/StdThread.h>
#include <gmsec4/util/TimeUtil.h>

#endif
