#ifndef GMSEC_MIST_DEFAULT_MSG_SCHEMAS
#define GMSEC_MIST_DEFAULT_MSG_SCHEMAS


static std::string defaultMessageTemplates[] =
{
    "<SCHEMA NAME=\"2014.00.MSG.AMVAL\"                                        "
    "ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE\">                          "
    "<!-- p. 221 GMSEC Interface Spec 2014-02.docx -->                         "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"AMVAL\"                                                   "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the Mnemonic Value Request message.\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true, indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"NUM-OF-MNEMONICS\"                                         "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Total number of mnemonics in this message\"/>       "
    "<FIELD  NAME=\"MNEMONIC.1.NAME\"                                          "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the first mnemonic.\"/>                     "
    "<FIELD  NAME=\"MNEMONIC.1.STATUS\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Status of the first mnemonic: valid mnemonic, or valid mnemonic with no data, or invalid mnemonic (1:  Valid, 2:  Valid, No data, 3:  Invalid)\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.UNITS\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Units associated with the value converted to engineering units for the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.NUM-OF-SAMPLES\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of data samples for the first mnemonic\"/>   "
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.TIME-STAMP\"                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time stamp for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.RAW-VALUE\"                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Raw value for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.EU-VALUE\"                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Raw value converted to Engineering Units if engineering units conversion is present for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.TEXT-VALUE\"                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Raw value converted to a text string if text conversion is present for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.FLAGS\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Flags native to the T&C component for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.LIMIT-ENABLE-DISABLE\"                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the limit checking state for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.RED-HIGH\"                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the Red High limit status for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.RED-LOW\"                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the Red Low limit status for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.YELLOW-HIGH\"                          "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the Yellow High limit status for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.YELLOW-LOW\"                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the Yellow Low limit status for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.STATIC\"                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the static (stale) condition for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.QUALITY\"                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the Quality for the first data sample of the first mnemonic\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.C2CX.CFG\"                                     "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.C2CX-SUBTYPE\">     "
    "<!-- pp 144, 145 of GMSEC Interface Spec 2014-02.docx -->                 "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"C2CX\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2006\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the Requestor and the Publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"C2CX-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"CFG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the type of information being transferred between the Components\"/>"
    "<FIELD  NAME=\"MY-ROLE\"                                                  "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Role the reporting component has in the configuration.  E.g. PRIMARY, BACKUP, AGENT, SERVER, MEMBER, MGR, ...\"/>"
    "<FIELD  NAME=\"NUM-OF-ASSOCS\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"The number of associations to be reported.\"/>      "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.C2CX.CNTL\"                                    "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.C2CX-SUBTYPE\">     "
    "<!-- pp 144, 148 of GMSEC Interface Spec 2014-02.docx -->                 "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"C2CX\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2008\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the Requestor and the Publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"C2CX-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"CNTL\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the type of information being transferred between the Components\"/>"
    "<FIELD  NAME=\"CNTL-KEYWORD\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Keyword extracted from the CNTL-STRING.  Useful for routing/processing.\"/>"
    "<FIELD  NAME=\"CNTL-STRING\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Parameters to guide the component on further processing.  E.g., INIT, Stop, Shutdown, Restart, Do X, Y, and Z.\"/>"
    "<FIELD  NAME=\"SPECIAL-INFO\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BINARY\"                                                   "
    "        DESCRIPTION=\"For application use.  Any additional information can be provided here.\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.C2CX.DEV\"                                     "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.C2CX-SUBTYPE\">     "
    "<!-- pp 144, 150 of GMSEC Interface Spec 2014-02.docx -->                 "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"C2CX\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the Requestor and the Publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"C2CX-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"DEV\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the type of information being transferred between the Components\"/>"
    "<FIELD  NAME=\"NUM-OF-DEVICES\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of devices being reported in this message\"/>"
    "<FIELD  NAME=\"DEVICE.1.NAME\"                                            "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the device\"/>                              "
    "<FIELD  NAME=\"DEVICE.1.NUMBER\"                                          "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"A number assigned to the device to distinguish it from identical devices.\"/>"
    "<FIELD  NAME=\"DEVICE.1.MODEL\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Model number of the device.\"/>                     "
    "<FIELD  NAME=\"DEVICE.1.SERIAL\"                                          "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Serial number of the device.\"/>                    "
    "<FIELD  NAME=\"DEVICE.1.VERSION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Version of the firmware operating within the device.\"/>"
    "<FIELD  NAME=\"DEVICE.1.GROUP\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of group associated with\"/>                   "
    "<FIELD  NAME=\"DEVICE.1.ROLE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Role the device has, if known\"/>                   "
    "<FIELD  NAME=\"DEVICE.1.STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the condition of the device being reported.  The reporting component may choose the condition level based on its own criteria.\"/>"
    "<FIELD  NAME=\"DEVICE.1.INFO\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"An additional status code that can be supplied that is specific to that device.\"/>"
    "<FIELD  NAME=\"DEVICE.1.NUM-OF-PARAMS\"                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of additional parameters being reported that are associated with the device.\"/>"
    "<FIELD  NAME=\"DEVICE.1.PARAM.1.NAME\"                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the additional parameter.\"/>               "
    "<FIELD  NAME=\"DEVICE.1.PARAM.1.TIME\"                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time of parameter sampling\"/>                      "
    "<FIELD  NAME=\"DEVICE.1.PARAM.1.VALUE\"                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"UNSET\"                                                    "
    "        DESCRIPTION=\"Value of the named parameter being reported. Component must ascertain the data type before accessing the value (e.g. with a function call).  Of type 'Variable' in the GMSEC ISD.\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.C2CX.HB\"                                      "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.C2CX-SUBTYPE\">     "
    "<!-- pp 144, 152 of GMSEC Interface Spec 2014-02.docx -->                 "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                              "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"C2CX\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the Requestor and the Publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"C2CX-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"HB\"                                                      "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the type of information being transferred between the Components\"/>"
    "<FIELD  NAME=\"COUNTER\"                                                  "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"In the range of 1 or greater ... Indicates the number of times that the C2CX message heartbeat message has been published, including this message\"/>"
    "<FIELD  NAME=\"PUB-RATE\"                                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"30\"                                                      "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the rate, in number of seconds, which the C2CX heartbeat message is being published by the component. A rate of zero or less indicates that this C2CX message is not repeatedly published by the component. The default publishing rate of the C2CX heartbeat message is 30 seconds.\"/>"
    "<FIELD  NAME=\"COMPONENT-STATUS\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the condition of the component being monitored, typically itself, although it may be a proxy for a remote component.  The component may choose the condition level based on its own criteria\"/>"
    "<FIELD  NAME=\"COMPONENT-INFO\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"An additional status code the component can supply that is specific to that component.\"/>"
    "<FIELD  NAME=\"SW-VERSION\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"UNSET\"                                                    "
    "        DESCRIPTION=\"Version number identifier of the reporting component. Component must ascertain the data type before accessing the value (e.g. with a function call).  Of type 'Variable' in the GMSEC ISD.\"/>"
    "<FIELD  NAME=\"CPU-MEM\"                                                  "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0.0\"                                                     "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Amount of memory being used at this time by this component.\"/>"
    "<FIELD  NAME=\"CPU-UTIL\"                                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0.0\"                                                     "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Percentage of CPU being utilized.\"/>               "
    "</SCHEMA>                                                                 "
    "                                                                          "
,

    "<SCHEMA NAME=\"2014.00.MSG.C2CX.RSRC\"                                    "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.C2CX-SUBTYPE\">     "
    "<!-- pp 144, 154 of GMSEC Interface Spec 2014-02.docx -->                 "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"C2CX\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the Requestor and the Publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"C2CX-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RSRC\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the type of information being transferred between the Components\"/>"
    "<FIELD  NAME=\"COUNTER\"                                                  "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of times that the C2CX Resource message has been published, including this message.\"/>"
    "<FIELD  NAME=\"PUB-RATE\"                                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"30\"                                                      "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Rate the data is being collected and published. The default publishing rate is 30 seconds.  A rate of zero or less indicates this message is not being repeatedly published.\"/>"
    "<FIELD  NAME=\"OPER-SYS\"                                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Operating system component is using\"/>             "
    "<FIELD  NAME=\"NUM-OF-CPUS\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of CPUs being monitored\"/>                  "
    "<FIELD  NAME=\"CPU.1.MEM\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Amount of memory for this CPU\"/>                   "
    "<FIELD  NAME=\"CPU.1.MEM-UTIL\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Memory utilization. Percentage of memory utilized.\"/>"
    "<FIELD  NAME=\"CPU.1.UTIL\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"CPU utilization. Percentage of CPU utilized\"/>     "
    "<FIELD  NAME=\"CPU.1.PAGE-FAULTS\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Number of page faults\"/>                           "
    "<FIELD  NAME=\"NUM-OF-DISKS\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of disks being monitored\"/>                 "
    "<FIELD  NAME=\"DISK.1.NAME\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the disk\"/>                                "
    "<FIELD  NAME=\"DISK.1.SIZE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Absolute size of the disk\"/>                       "
    "<FIELD  NAME=\"DISK.1.UTIL\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Disk space utilization. Percentage of Disk space utilized.\"/>"
    "<FIELD  NAME=\"NUM-OF-NET-PORTS\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of network ports\"/>                         "
    "<FIELD  NAME=\"NET-PORT.1.NAME\"                                          "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the network port\"/>                        "
    "<FIELD  NAME=\"NET-PORT.1.EUI-ADR\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Media Access Control (MAC) or Extended Unique Identifier (EUI) physical address.  MAC-48, EUI-48, or EUI-64 format.\"/>"
    "<FIELD  NAME=\"NET-PORT.1.IP-ADR\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Internet Protocol (IP) logical address.  IPv4 (32-bit) or IPv6 (128-bit) format.\"/>"
    "<FIELD  NAME=\"NET-PORT.1.TOTAL-BANDWIDTH\"                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Bandwidth of the port in Kbps\"/>                   "
    "<FIELD  NAME=\"NET-PORT.1.UTIL\"                                          "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Percentage of Network port utilization\"/>          "
    "<FIELD  NAME=\"NET-PORT.1.BYTES-SENT\"                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Number of bytes sent over the port\"/>              "
    "<FIELD  NAME=\"NET-PORT.1.BYTES-RECEIVED\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Number of bytes received over the port\"/>          "
    "<FIELD  NAME=\"NET-PORT.1.MSGS-SENT\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Number of messages sent over the port\"/>           "
    "<FIELD  NAME=\"NET-PORT.1.MSGS-RECEIVED\"                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Number of messages received over the port\"/>       "
    "<FIELD  NAME=\"NET-PORT.1.ERRORS\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Number of errors encountered on the port\"/>        "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.LOG\"                                          "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE\">                  "
    "<!-- pp. 109, 110 GMSEC Interface Spec 2014-02.docx -->                   "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"LOG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"1.0\"                                                     "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message\"/>                 "
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"SUBCLASS\"                                                 "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "       	TYPE=\"STRING\"                                                   "
    "       	DESCRIPTION=\"Subclass generating the log message (or applicable subsystem of which the log message belongs).  See Table 4-28 in GMSEC Interface Space 2014-02.docx.  Software Class and Subclass Categories.\"/>"
    "<FIELD  NAME=\"OCCURRENCE-TYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"An occurrence types that categorizes the kind of activity or event that happened, triggering the log message.  See Tables that follow Table 5-7 in GMSEC Interface Spec 2014-02.docx\"/>"
    "<FIELD  NAME=\"SEVERITY\"                                                 "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the severity of the Log Message.  Scale traditionally applied to message based on requirements and characteristics of the component or ground system. The severity may be used to alert the operator in some way such as visual or audible notification. Debug is typically used by software developers\"/>"
    "<FIELD  NAME=\"USER\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Which user/workposition/proc the message has to do with\"/>"
    "<FIELD  NAME=\"SPACECRAFT-TIME\"                                          "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time event happened (may be earlier than actual posted time)\"/>"
    "<FIELD  NAME=\"EVENT-TIME\"                                               "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time event happened (may be earlier than published time)\"/>"
    "<FIELD  NAME=\"REFERENCE-ID\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"A local index or map to a table (or database) of additional information\"/>"
    "<FIELD  NAME=\"MSG-TEXT\"                                                 "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Text for display (typically about 60 characters)\"/>"
    "<FIELD  NAME=\"MSG-TEXT-DETAILS\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"One or more paragraphs that includes more detail.  Suggested corrective action.  Suggest specifying url in this field\"/>"
    "<FIELD  NAME=\"SPECIAL-INFO\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"TBD, application use\"/>                            "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.MVAL\"                                         "
    "ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE\">                          "
    "<!-- p. 197 GMSEC Interface Spec 2014-02.docx -->                         "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MVAL\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the Mnemonic Value Request message.\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true, indicates last message in the series.\"/>"
    "<FIELD  NAME=\"NUM-OF-MNEMONICS\"                                         "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Total number of mnemonics in this message\"/>       "
    "<FIELD  NAME=\"MNEMONIC.1.NAME\"                                          "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the first mnemonic.\"/>                     "
    "<FIELD  NAME=\"MNEMONIC.1.STATUS\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Status of the first mnemonic: valid mnemonic, or valid mnemonic with no data, or invalid mnemonic (1:  Valid, 2:  Valid, No data, 3:  Invalid)\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.UNITS\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Units associated with the value converted to engineering units for the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.NUM-OF-SAMPLES\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of data samples for the first mnemonic\"/>   "
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.TIME-STAMP\"                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time stamp for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.RAW-VALUE\"                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Raw value for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.EU-VALUE\"                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Raw value converted to Engineering Units if engineering units conversion is present for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.TEXT-VALUE\"                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Raw value converted to a text string if text conversion is present for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.FLAGS\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Flags native to the T&C component for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.LIMIT-ENABLE-DISABLE\"                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the limit checking state for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.RED-HIGH\"                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the Red High limit status for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.RED-LOW\"                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the Red Low limit status for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.YELLOW-HIGH\"                          "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the Yellow High limit status for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.YELLOW-LOW\"                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the Yellow Low limit status for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.STATIC\"                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the static (stale) condition for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.QUALITY\"                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the Quality for the first data sample of the first mnemonic\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.NDM.AEM\"                                      "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.NDM-TYPE\">         "
    "<!-- pp. 284 GMSEC Interface Spec 2014-02.docx -->                        "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"NDM\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"NDM-TYPE\"                                                 "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"AEM\"                                                     "
    "       	TYPE=\"STRING\"                                                   "
    "       	DESCRIPTION=\"Message contains an Attitude Ephemeris Message in CCSDS or other format\"/>"
    "<FIELD  NAME=\"NDM-SUBTYPE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Descriptor of the type / kind of the contents of the AEM. E.g. Quaternion values, spin data, and Euler elements\"/>"
    "<FIELD  NAME=\"STREAM-MODE\"                                              "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the mode of the stream of messages as either Real-time, Replay, Simulator, or Test\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true (and known, especially for replay data), indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"LENGTH\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Length of encapsulated Navigation Data Message in the DATA field\"/>"
    "<FIELD  NAME=\"CREATION-TIME\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time the Navigation Data Message was created.\"/>   "
    "<FIELD  NAME=\"ACTIVITY-ID\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Specifies the activity occurring within the mission\"/>"
    "<FIELD  NAME=\"ORIGINATOR\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Creating agency.  E.g. GSFC-FDF, GSOC, JPL, JAXA etc.\"/>"
    "<FIELD  NAME=\"OBJECT-NAME\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Spacecraft name\"/>                                 "
    "<FIELD  NAME=\"OBJECT-ID\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Spacecraft identifier\"/>                           "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Format of the DATA field (KVN: Keyword = Value Notation, XML: eXtensible Markup Language, RAW, or BIN (binary))\"/>"
    "<FIELD  NAME=\"DATA\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BIN\"                                                      "
    "        DESCRIPTION=\"Structured Navigation Data Message\"/>              "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.NDM.APM\"                                      "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.NDM-TYPE\">         "
    "<!-- pp. 283 GMSEC Interface Spec 2014-02.docx -->                        "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"NDM\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"NDM-TYPE\"                                                 "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"APM\"                                                     "
    "       	TYPE=\"STRING\"                                                   "
    "       	DESCRIPTION=\"Message contains an Attitude Parameter Message in CCSDS or other format\"/>"
    "<FIELD  NAME=\"NDM-SUBTYPE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Descriptor of the type / kind of the contents of the APM. E.g. Attitude state info, Euler angle rates, or spacecraft parameters\"/>"
    "<FIELD  NAME=\"STREAM-MODE\"                                              "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the mode of the stream of messages as either Real-time, Replay, Simulator, or Test.  (RT:  Real-time, RPY:  Replay, SIM:  Simulator, TEST:  Test/Data Generator)\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true (and known, especially for replay data), indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"LENGTH\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Length of encapsulated Navigation Data Message in the DATA field\"/>"
    "<FIELD  NAME=\"CREATION-TIME\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time the Navigation Data Message was created.\"/>   "
    "<FIELD  NAME=\"ACTIVITY-ID\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Specifies the activity occurring within the mission\"/>"
    "<FIELD  NAME=\"ORIGINATOR\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Creating agency.  E.g. GSFC-FDF, GSOC, JPL, JAXA etc.\"/>"
    "<FIELD  NAME=\"OBJECT-NAME\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Spacecraft name\"/>                                 "
    "<FIELD  NAME=\"OBJECT-ID\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Spacecraft identifier\"/>                           "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Format of the DATA field (KVN: Keyword = Value Notation, XML: eXtensible Markup Language, RAW, or BIN (binary))\"/>"
    "<FIELD  NAME=\"DATA\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BIN\"                                                      "
    "        DESCRIPTION=\"Structured Navigation Data Message\"/>              "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.NDM.CCSDS-AEM\"                                "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.NDM-TYPE\">         "
    "<!-- pp. 284 GMSEC Interface Spec 2014-02.docx -->                        "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"NDM\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"NDM-TYPE\"                                                 "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"CCSDS-AEM\"                                               "
    "       	TYPE=\"STRING\"                                                   "
    "       	DESCRIPTION=\"Message contains an Attitude Ephemeris Message in CCSDS or other format\"/>"
    "<FIELD  NAME=\"NDM-SUBTYPE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Descriptor of the type / kind of the contents of the AEM. E.g. Quaternion values, spin data, and Euler elements\"/>"
    "<FIELD  NAME=\"STREAM-MODE\"                                              "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the mode of the stream of messages as either Real-time, Replay, Simulator, or Test\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true (and known, especially for replay data), indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"LENGTH\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Length of encapsulated Navigation Data Message in the DATA field\"/>"
    "<FIELD  NAME=\"CREATION-TIME\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time the Navigation Data Message was created.\"/>   "
    "<FIELD  NAME=\"ACTIVITY-ID\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Specifies the activity occurring within the mission\"/>"
    "<FIELD  NAME=\"ORIGINATOR\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Creating agency.  E.g. GSFC-FDF, GSOC, JPL, JAXA etc.\"/>"
    "<FIELD  NAME=\"OBJECT-NAME\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Spacecraft name\"/>                                 "
    "<FIELD  NAME=\"OBJECT-ID\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Spacecraft identifier\"/>                           "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Format of the DATA field (KVN: Keyword = Value Notation, XML: eXtensible Markup Language, RAW, or BIN (binary))\"/>"
    "<FIELD  NAME=\"DATA\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BIN\"                                                      "
    "        DESCRIPTION=\"Structured Navigation Data Message\"/>              "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.NDM.CCSDS-APM\"                                "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.NDM-TYPE\">         "
    "<!-- pp. 283 GMSEC Interface Spec 2014-02.docx -->                        "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"NDM\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"NDM-TYPE\"                                                 "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"CCSDS-APM\"                                               "
    "       	TYPE=\"STRING\"                                                   "
    "       	DESCRIPTION=\"Message contains an Attitude Parameter Message in CCSDS or other format\"/>"
    "<FIELD  NAME=\"NDM-SUBTYPE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Descriptor of the type / kind of the contents of the APM. E.g. Attitude state info, Euler angle rates, or spacecraft parameters\"/>"
    "<FIELD  NAME=\"STREAM-MODE\"                                              "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the mode of the stream of messages as either Real-time, Replay, Simulator, or Test.  (RT:  Real-time, RPY:  Replay, SIM:  Simulator, TEST:  Test/Data Generator)\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true (and known, especially for replay data), indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"LENGTH\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Length of encapsulated Navigation Data Message in the DATA field\"/>"
    "<FIELD  NAME=\"CREATION-TIME\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time the Navigation Data Message was created.\"/>   "
    "<FIELD  NAME=\"ACTIVITY-ID\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Specifies the activity occurring within the mission\"/>"
    "<FIELD  NAME=\"ORIGINATOR\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Creating agency.  E.g. GSFC-FDF, GSOC, JPL, JAXA etc.\"/>"
    "<FIELD  NAME=\"OBJECT-NAME\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Spacecraft name\"/>                                 "
    "<FIELD  NAME=\"OBJECT-ID\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Spacecraft identifier\"/>                           "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Format of the DATA field (KVN: Keyword = Value Notation, XML: eXtensible Markup Language, RAW, or BIN (binary))\"/>"
    "<FIELD  NAME=\"DATA\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BIN\"                                                      "
    "        DESCRIPTION=\"Structured Navigation Data Message\"/>              "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.NDM.CCSDS-OEM\"                                "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.NDM-TYPE\">         "
    "<!-- pp. 290 GMSEC Interface Spec 2014-02.docx -->                        "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"NDM\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"NDM-TYPE\"                                                 "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"CCSDS-OEM\"                                               "
    "       	TYPE=\"STRING\"                                                   "
    "       	DESCRIPTION=\"Message contains an Orbit Ephemeris Message in CCSDS or other format\"/>"
    "<FIELD  NAME=\"NDM-SUBTYPE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Descriptor of the type / kind of the contents of the OEM. E.g. state vector, Keplerian elements, maneuvers, matrix\"/>"
    "<FIELD  NAME=\"STREAM-MODE\"                                              "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the mode of the stream of messages as either Real-time, Replay, Simulator, or Test (RT:  Real-time, RPY:  Replay, SIM:  Simulator, TEST:  Test/Data Generator)\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true (and known, especially for replay data), indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"LENGTH\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Length of encapsulated Navigation Data Message in the DATA field\"/>"
    "<FIELD  NAME=\"CREATION-TIME\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time the Navigation Data Message was created.\"/>   "
    "<FIELD  NAME=\"ACTIVITY-ID\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Specifies the activity occurring within the mission\"/>"
    "<FIELD  NAME=\"ORIGINATOR\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Creating agency.  E.g. GSFC-FDF, GSOC, JPL, JAXA etc.\"/>"
    "<FIELD  NAME=\"OBJECT-NAME\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Spacecraft name\"/>                                 "
    "<FIELD  NAME=\"OBJECT-ID\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Spacecraft identifier\"/>                           "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Format of the DATA field (KVN: Keyword = Value Notation, XML: eXtensible Markup Language)\"/>"
    "<FIELD  NAME=\"DATA\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BIN\"                                                      "
    "        DESCRIPTION=\"Structured Navigation Data Message\"/>              "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.NDM.CCSDS-OMM\"                                "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.NDM-TYPE\">         "
    "<!-- pp. 289 GMSEC Interface Spec 2014-02.docx -->                        "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"NDM\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"NDM-TYPE\"                                                 "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"CCSDS-OMM\"                                               "
    "       	TYPE=\"STRING\"                                                   "
    "       	DESCRIPTION=\"Message contains an Orbit Mean-Elements Message in CCSDS or other format\"/>"
    "<FIELD  NAME=\"NDM-SUBTYPE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Descriptor of the type / kind of the contents of the OMM. E.g. two line element set, Keplerian elements, covariance matrix, or user defined\"/>"
    "<FIELD  NAME=\"STREAM-MODE\"                                              "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the mode of the stream of messages as either Real-time, Replay, Simulator, or Test (RT:  Real-time, RPY:  Replay, SIM:  Simulator, TEST:  Test/Data Generator)\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true (and known, especially for replay data), indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"LENGTH\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Length of encapsulated Navigation Data Message in the DATA field\"/>"
    "<FIELD  NAME=\"CREATION-TIME\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time the Navigation Data Message was created.\"/>   "
    "<FIELD  NAME=\"ACTIVITY-ID\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Specifies the activity occurring within the mission\"/>"
    "<FIELD  NAME=\"ORIGINATOR\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Creating agency.  E.g. GSFC-FDF, GSOC, JPL, JAXA etc.\"/>"
    "<FIELD  NAME=\"OBJECT-NAME\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Spacecraft name\"/>                                 "
    "<FIELD  NAME=\"OBJECT-ID\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Spacecraft identifier\"/>                           "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Format of the DATA field (KVN: Keyword = Value Notation, XML: eXtensible Markup Language, RAW, or BIN (binary))\"/>"
    "<FIELD  NAME=\"DATA\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BIN\"                                                      "
    "        DESCRIPTION=\"Structured Navigation Data Message\"/>              "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.NDM.CCSDS-OPM\"                                "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.NDM-TYPE\">         "
    "<!-- pp. 287 GMSEC Interface Spec 2014-02.docx -->                        "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"NDM\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"NDM-TYPE\"                                                 "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"CCSDS-OPM\"                                               "
    "       	TYPE=\"STRING\"                                                   "
    "       	DESCRIPTION=\"Message contains an Orbit Parameter Message in CCSDS or other format\"/>"
    "<FIELD  NAME=\"NDM-SUBTYPE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Descriptor of the type / kind of the contents of the OPM. E.g. state vector, Keplerian elements, maneuvers, matrix\"/>"
    "<FIELD  NAME=\"STREAM-MODE\"                                              "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the mode of the stream of messages as either Real-time, Replay, Simulator, or Test (RT:  Real-time, RPY:  Replay, SIM:  Simulator, TEST:  Test/Data Generator)\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true (and known, especially for replay data), indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"LENGTH\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Length of encapsulated Navigation Data Message in the DATA field\"/>"
    "<FIELD  NAME=\"CREATION-TIME\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time the Navigation Data Message was created.\"/>   "
    "<FIELD  NAME=\"ACTIVITY-ID\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Specifies the activity occurring within the mission\"/>"
    "<FIELD  NAME=\"ORIGINATOR\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Creating agency.  E.g. GSFC-FDF, GSOC, JPL, JAXA etc.\"/>"
    "<FIELD  NAME=\"OBJECT-NAME\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Spacecraft name\"/>                                 "
    "<FIELD  NAME=\"OBJECT-ID\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Spacecraft identifier\"/>                           "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Format of the DATA field (KVN: Keyword = Value Notation, XML: eXtensible Markup Language, RAW, or BIN (binary))\"/>"
    "<FIELD  NAME=\"DATA\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BIN\"                                                      "
    "        DESCRIPTION=\"Structured Navigation Data Message\"/>              "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.NDM.CCSDS-TDM\"                                "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.NDM-TYPE\">         "
    "<!-- pp. 293 GMSEC Interface Spec 2014-02.docx -->                        "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"NDM\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"NDM-TYPE\"                                                 "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"CCSDS-TDM\"                                               "
    "       	TYPE=\"STRING\"                                                   "
    "       	DESCRIPTION=\"Message contains a Tracking Data Message in CCSDS or other format\"/>"
    "<FIELD  NAME=\"NDM-SUBTYPE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Descriptor of the type / kind of the contents of the TDM. E.g. Doppler, angle, range, one-way.\"/>"
    "<FIELD  NAME=\"STREAM-MODE\"                                              "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the mode of the stream of messages as either Real-time, Replay, Simulator, or Test (RT:  Real-time, RPY:  Replay, SIM:  Simulator, TEST:  Test/Data Generator)\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true (and known, especially for replay data), indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"LENGTH\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Length of encapsulated Navigation Data Message in the DATA field\"/>"
    "<FIELD  NAME=\"CREATION-TIME\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time the Navigation Data Message was created.\"/>   "
    "<FIELD  NAME=\"ACTIVITY-ID\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Specifies the activity occurring within the mission\"/>"
    "<FIELD  NAME=\"ORIGINATOR\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Creating agency.  E.g. GSFC-FDF, GSOC, JPL, JAXA etc.\"/>"
    "<FIELD  NAME=\"START-TIME\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Start time of the tracking data\"/>                 "
    "<FIELD  NAME=\"STOP-TIME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Stop time of the tracking data\"/>                  "
    "<FIELD  NAME=\"FREQUENCY-BAND\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Frequency band for transmitted signals (C, S, X, Ka, L, UHF)\"/>"
    "<FIELD  NAME=\"DATA-QUALITY\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BIN\"                                                      "
    "        DESCRIPTION=\"Raw = no quality check, Validated = checked and passed, Degraded = checked with quality issues.\"/>"
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Format of the DATA field...  KVN: Keyword = Value Notation, XML: eXtensible Markup Language, RAW, or BIN (binary)\"/>"
    "<FIELD  NAME=\"DATA\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BIN\"                                                      "
    "        DESCRIPTION=\"Structured Navigation Data Message\"/>              "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.NDM.OEM\"                                      "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.NDM-TYPE\">         "
    "<!-- pp. 290 GMSEC Interface Spec 2014-02.docx -->                        "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"NDM\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"NDM-TYPE\"                                                 "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"OEM\"                                                     "
    "       	TYPE=\"STRING\"                                                   "
    "       	DESCRIPTION=\"Message contains an Orbit Ephemeris Message in CCSDS or other format\"/>"
    "<FIELD  NAME=\"NDM-SUBTYPE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Descriptor of the type / kind of the contents of the OEM. E.g. state vector, Keplerian elements, maneuvers, matrix\"/>"
    "<FIELD  NAME=\"STREAM-MODE\"                                              "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the mode of the stream of messages as either Real-time, Replay, Simulator, or Test (RT:  Real-time, RPY:  Replay, SIM:  Simulator, TEST:  Test/Data Generator)\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true (and known, especially for replay data), indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"LENGTH\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Length of encapsulated Navigation Data Message in the DATA field\"/>"
    "<FIELD  NAME=\"CREATION-TIME\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time the Navigation Data Message was created.\"/>   "
    "<FIELD  NAME=\"ACTIVITY-ID\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Specifies the activity occurring within the mission\"/>"
    "<FIELD  NAME=\"ORIGINATOR\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Creating agency.  E.g. GSFC-FDF, GSOC, JPL, JAXA etc.\"/>"
    "<FIELD  NAME=\"OBJECT-NAME\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Spacecraft name\"/>                                 "
    "<FIELD  NAME=\"OBJECT-ID\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Spacecraft identifier\"/>                           "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Format of the DATA field (KVN: Keyword = Value Notation, XML: eXtensible Markup Language)\"/>"
    "<FIELD  NAME=\"DATA\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BIN\"                                                      "
    "        DESCRIPTION=\"Structured Navigation Data Message\"/>              "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.NDM.OMM\"                                      "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.NDM-TYPE\">         "
    "<!-- pp. 289 GMSEC Interface Spec 2014-02.docx -->                        "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"NDM\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"NDM-TYPE\"                                                 "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"OMM\"                                                     "
    "       	TYPE=\"STRING\"                                                   "
    "       	DESCRIPTION=\"Message contains an Orbit Mean-Elements Message in CCSDS or other format\"/>"
    "<FIELD  NAME=\"NDM-SUBTYPE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Descriptor of the type / kind of the contents of the OMM. E.g. two line element set, Keplerian elements, covariance matrix, or user defined\"/>"
    "<FIELD  NAME=\"STREAM-MODE\"                                              "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the mode of the stream of messages as either Real-time, Replay, Simulator, or Test (RT:  Real-time, RPY:  Replay, SIM:  Simulator, TEST:  Test/Data Generator)\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true (and known, especially for replay data), indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"LENGTH\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Length of encapsulated Navigation Data Message in the DATA field\"/>"
    "<FIELD  NAME=\"CREATION-TIME\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time the Navigation Data Message was created.\"/>   "
    "<FIELD  NAME=\"ACTIVITY-ID\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Specifies the activity occurring within the mission\"/>"
    "<FIELD  NAME=\"ORIGINATOR\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Creating agency.  E.g. GSFC-FDF, GSOC, JPL, JAXA etc.\"/>"
    "<FIELD  NAME=\"OBJECT-NAME\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Spacecraft name\"/>                                 "
    "<FIELD  NAME=\"OBJECT-ID\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Spacecraft identifier\"/>                           "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Format of the DATA field (KVN: Keyword = Value Notation, XML: eXtensible Markup Language, RAW, or BIN (binary))\"/>"
    "<FIELD  NAME=\"DATA\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BIN\"                                                      "
    "        DESCRIPTION=\"Structured Navigation Data Message\"/>              "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.NDM.OPM\"                                      "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.NDM-TYPE\">         "
    "<!-- pp. 287 GMSEC Interface Spec 2014-02.docx -->                        "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"NDM\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"NDM-TYPE\"                                                 "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"OPM\"                                                     "
    "       	TYPE=\"STRING\"                                                   "
    "       	DESCRIPTION=\"Message contains an Orbit Parameter Message in CCSDS or other format\"/>"
    "<FIELD  NAME=\"NDM-SUBTYPE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Descriptor of the type / kind of the contents of the OPM. E.g. state vector, Keplerian elements, maneuvers, matrix\"/>"
    "<FIELD  NAME=\"STREAM-MODE\"                                              "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the mode of the stream of messages as either Real-time, Replay, Simulator, or Test (RT:  Real-time, RPY:  Replay, SIM:  Simulator, TEST:  Test/Data Generator)\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true (and known, especially for replay data), indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"LENGTH\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Length of encapsulated Navigation Data Message in the DATA field\"/>"
    "<FIELD  NAME=\"CREATION-TIME\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time the Navigation Data Message was created.\"/>   "
    "<FIELD  NAME=\"ACTIVITY-ID\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Specifies the activity occurring within the mission\"/>"
    "<FIELD  NAME=\"ORIGINATOR\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Creating agency.  E.g. GSFC-FDF, GSOC, JPL, JAXA etc.\"/>"
    "<FIELD  NAME=\"OBJECT-NAME\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Spacecraft name\"/>                                 "
    "<FIELD  NAME=\"OBJECT-ID\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Spacecraft identifier\"/>                           "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Format of the DATA field (KVN: Keyword = Value Notation, XML: eXtensible Markup Language, RAW, or BIN (binary))\"/>"
    "<FIELD  NAME=\"DATA\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BIN\"                                                      "
    "        DESCRIPTION=\"Structured Navigation Data Message\"/>              "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.NDM.TDM\"                                      "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.NDM-TYPE\">         "
    "<!-- pp. 293 GMSEC Interface Spec 2014-02.docx -->                        "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"NDM\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"NDM-TYPE\"                                                 "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"TDM\"                                                     "
    "       	TYPE=\"STRING\"                                                   "
    "       	DESCRIPTION=\"Message contains a Tracking Data Message in CCSDS or other format\"/>"
    "<FIELD  NAME=\"NDM-SUBTYPE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Descriptor of the type / kind of the contents of the TDM. E.g. Doppler, angle, range, one-way.\"/>"
    "<FIELD  NAME=\"STREAM-MODE\"                                              "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the mode of the stream of messages as either Real-time, Replay, Simulator, or Test (RT:  Real-time, RPY:  Replay, SIM:  Simulator, TEST:  Test/Data Generator)\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true (and known, especially for replay data), indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"LENGTH\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Length of encapsulated Navigation Data Message in the DATA field\"/>"
    "<FIELD  NAME=\"CREATION-TIME\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time the Navigation Data Message was created.\"/>   "
    "<FIELD  NAME=\"ACTIVITY-ID\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Specifies the activity occurring within the mission\"/>"
    "<FIELD  NAME=\"ORIGINATOR\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Creating agency.  E.g. GSFC-FDF, GSOC, JPL, JAXA etc.\"/>"
    "<FIELD  NAME=\"START-TIME\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Start time of the tracking data\"/>                 "
    "<FIELD  NAME=\"STOP-TIME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Stop time of the tracking data\"/>                  "
    "<FIELD  NAME=\"FREQUENCY-BAND\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Frequency band for transmitted signals (C, S, X, Ka, L, UHF)\"/>"
    "<FIELD  NAME=\"DATA-QUALITY\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BIN\"                                                      "
    "        DESCRIPTION=\"Raw = no quality check, Validated = checked and passed, Degraded = checked with quality issues.\"/>"
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Format of the DATA field...  KVN: Keyword = Value Notation, XML: eXtensible Markup Language, RAW, or BIN (binary)\"/>"
    "<FIELD  NAME=\"DATA\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BIN\"                                                      "
    "        DESCRIPTION=\"Structured Navigation Data Message\"/>              "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.PROD.AAA\"                                     "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.PROD-TYPE\">        "
    "<!-- pp 259, 261-262 of GMSEC Interface Spec 2014-02.docx -->             "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"PROD\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the Product Request message.\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true, indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Product Message that was processed.  Note: Even though a Request is valid, a product may not be able to be successfully generated.  In this case the following Product Message would indicate a Failed Completion.\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application created the product\"/>            "
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Used to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-REFERENCE\"                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the product is referenced by a URI.  A product can be included in a message, referenced by a URI, or both.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-INCLUDE\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the product is included in this message.  A product can be included in a message, referenced by a URI, or both.\"/>"
    "<FIELD  NAME=\"PROD-MSGS-TO-SEND\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of PROD Msgs that will be published to satisfy the PROD REQ.\"/>"
    "<FIELD  NAME=\"PROD-SEQ-NUM\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates which message this is in the sequence of PROD Msgs that constitutes a product.\"/>"
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"AAA\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Category of product.  Could be echo of the PROD-TYPE field from the Product Request message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"DATA\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Subcategory of the product.  Could be echo of the PROD-SUBTYPE field of the Product Request Message.\"/>"
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc.)\"/>"
    "<FIELD  NAME=\"NUM-OF-FILES\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of files included in this response message.\"/>"
    "<FIELD  NAME=\"FILE.1.URI\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the file of the product is stored\"/>"
    "<FIELD  NAME=\"FILE.1.NAME-PATTERN\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"FILE.1.DESCRIPTION\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"FILE.1.FORMAT\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"FILE.1.VERSION\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"FILE.1.SIZE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"FILE.1.DATA\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.PROD.AUTO\"                                    "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.PROD-TYPE\">        "
    "<!-- pp 259, 261-262 of GMSEC Interface Spec 2014-02.docx -->             "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"PROD\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the Product Request message.\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true, indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Product Message that was processed.  Note: Even though a Request is valid, a product may not be able to be successfully generated.  In this case the following Product Message would indicate a Failed Completion.\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application created the product\"/>            "
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Used to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-REFERENCE\"                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the product is referenced by a URI.  A product can be included in a message, referenced by a URI, or both.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-INCLUDE\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the product is included in this message.  A product can be included in a message, referenced by a URI, or both.\"/>"
    "<FIELD  NAME=\"PROD-MSGS-TO-SEND\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of PROD Msgs that will be published to satisfy the PROD REQ.\"/>"
    "<FIELD  NAME=\"PROD-SEQ-NUM\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates which message this is in the sequence of PROD Msgs that constitutes a product.\"/>"
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"AUTO\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Category of product.  Could be echo of the PROD-TYPE field from the Product Request message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"DM\"                                                      "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Subcategory of the product.  Could be echo of the PROD-SUBTYPE field of the Product Request Message.\"/>"
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc.)\"/>"
    "<FIELD  NAME=\"NUM-OF-FILES\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of files included in this response message.\"/>"
    "<FIELD  NAME=\"FILE.1.URI\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the file of the product is stored\"/>"
    "<FIELD  NAME=\"FILE.1.NAME-PATTERN\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"FILE.1.DESCRIPTION\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"FILE.1.FORMAT\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"FILE.1.VERSION\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"FILE.1.SIZE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"FILE.1.DATA\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.PROD.FD\"                                      "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.PROD-TYPE\">        "
    "<!-- pp 259, 261-262 of GMSEC Interface Spec 2014-02.docx -->             "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"PROD\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the Product Request message.\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true, indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Product Message that was processed.  Note: Even though a Request is valid, a product may not be able to be successfully generated.  In this case the following Product Message would indicate a Failed Completion.\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application created the product\"/>            "
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Used to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-REFERENCE\"                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the product is referenced by a URI.  A product can be included in a message, referenced by a URI, or both.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-INCLUDE\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the product is included in this message.  A product can be included in a message, referenced by a URI, or both.\"/>"
    "<FIELD  NAME=\"PROD-MSGS-TO-SEND\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of PROD Msgs that will be published to satisfy the PROD REQ.\"/>"
    "<FIELD  NAME=\"PROD-SEQ-NUM\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates which message this is in the sequence of PROD Msgs that constitutes a product.\"/>"
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FD\"                                                      "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Category of product.  Could be echo of the PROD-TYPE field from the Product Request message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"ATT\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Subcategory of the product.  Could be echo of the PROD-SUBTYPE field of the Product Request Message.\"/>"
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc.)\"/>"
    "<FIELD  NAME=\"NUM-OF-FILES\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of files included in this response message.\"/>"
    "<FIELD  NAME=\"FILE.1.URI\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the file of the product is stored\"/>"
    "<FIELD  NAME=\"FILE.1.NAME-PATTERN\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"FILE.1.DESCRIPTION\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"FILE.1.FORMAT\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"FILE.1.VERSION\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"FILE.1.SIZE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"FILE.1.DATA\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.PROD.MAS\"                                     "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.PROD-TYPE\">        "
    "<!-- pp 259, 261-262 of GMSEC Interface Spec 2014-02.docx -->             "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"PROD\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the Product Request message.\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true, indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Product Message that was processed.  Note: Even though a Request is valid, a product may not be able to be successfully generated.  In this case the following Product Message would indicate a Failed Completion.\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application created the product\"/>            "
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Used to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-REFERENCE\"                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the product is referenced by a URI.  A product can be included in a message, referenced by a URI, or both.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-INCLUDE\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the product is included in this message.  A product can be included in a message, referenced by a URI, or both.\"/>"
    "<FIELD  NAME=\"PROD-MSGS-TO-SEND\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of PROD Msgs that will be published to satisfy the PROD REQ.\"/>"
    "<FIELD  NAME=\"PROD-SEQ-NUM\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates which message this is in the sequence of PROD Msgs that constitutes a product.\"/>"
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"MAS\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Category of product.  Could be echo of the PROD-TYPE field from the Product Request message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"DATA\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Subcategory of the product.  Could be echo of the PROD-SUBTYPE field of the Product Request Message.\"/>"
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc.)\"/>"
    "<FIELD  NAME=\"NUM-OF-FILES\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of files included in this response message.\"/>"
    "<FIELD  NAME=\"FILE.1.URI\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the file of the product is stored\"/>"
    "<FIELD  NAME=\"FILE.1.NAME-PATTERN\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"FILE.1.DESCRIPTION\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"FILE.1.FORMAT\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"FILE.1.VERSION\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"FILE.1.SIZE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"FILE.1.DATA\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.PROD.PAS\"                                     "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.PROD-TYPE\">        "
    "<!-- pp 259, 261-262 of GMSEC Interface Spec 2014-02.docx -->             "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"PROD\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the Product Request message.\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true, indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Product Message that was processed.  Note: Even though a Request is valid, a product may not be able to be successfully generated.  In this case the following Product Message would indicate a Failed Completion.\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application created the product\"/>            "
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Used to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-REFERENCE\"                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the product is referenced by a URI.  A product can be included in a message, referenced by a URI, or both.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-INCLUDE\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the product is included in this message.  A product can be included in a message, referenced by a URI, or both.\"/>"
    "<FIELD  NAME=\"PROD-MSGS-TO-SEND\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of PROD Msgs that will be published to satisfy the PROD REQ.\"/>"
    "<FIELD  NAME=\"PROD-SEQ-NUM\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates which message this is in the sequence of PROD Msgs that constitutes a product.\"/>"
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"PAS\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Category of product.  Could be echo of the PROD-TYPE field from the Product Request message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"SCH\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Subcategory of the product.  Could be echo of the PROD-SUBTYPE field of the Product Request Message.\"/>"
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc.)\"/>"
    "<FIELD  NAME=\"NUM-OF-FILES\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of files included in this response message.\"/>"
    "<FIELD  NAME=\"FILE.1.URI\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the file of the product is stored\"/>"
    "<FIELD  NAME=\"FILE.1.NAME-PATTERN\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"FILE.1.DESCRIPTION\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"FILE.1.FORMAT\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"FILE.1.VERSION\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"FILE.1.SIZE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"FILE.1.DATA\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.PROD.SC\"                                      "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.PROD-TYPE\">        "
    "<!-- pp 259, 261-262 of GMSEC Interface Spec 2014-02.docx -->             "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"PROD\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the Product Request message.\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true, indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Product Message that was processed.  Note: Even though a Request is valid, a product may not be able to be successfully generated.  In this case the following Product Message would indicate a Failed Completion.\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application created the product\"/>            "
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Used to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-REFERENCE\"                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the product is referenced by a URI.  A product can be included in a message, referenced by a URI, or both.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-INCLUDE\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the product is included in this message.  A product can be included in a message, referenced by a URI, or both.\"/>"
    "<FIELD  NAME=\"PROD-MSGS-TO-SEND\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of PROD Msgs that will be published to satisfy the PROD REQ.\"/>"
    "<FIELD  NAME=\"PROD-SEQ-NUM\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates which message this is in the sequence of PROD Msgs that constitutes a product.\"/>"
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"SC\"                                                      "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Category of product.  Could be echo of the PROD-TYPE field from the Product Request message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Subcategory of the product.  Could be echo of the PROD-SUBTYPE field of the Product Request Message.\"/>"
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc.)\"/>"
    "<FIELD  NAME=\"NUM-OF-FILES\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of files included in this response message.\"/>"
    "<FIELD  NAME=\"FILE.1.URI\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the file of the product is stored\"/>"
    "<FIELD  NAME=\"FILE.1.NAME-PATTERN\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"FILE.1.DESCRIPTION\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"FILE.1.FORMAT\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"FILE.1.VERSION\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"FILE.1.SIZE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"FILE.1.DATA\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.PROD.TAC\"                                     "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.PROD-TYPE\">        "
    "<!-- pp 259, 261-262 of GMSEC Interface Spec 2014-02.docx -->             "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"PROD\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the Product Request message.\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true, indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Product Message that was processed.  Note: Even though a Request is valid, a product may not be able to be successfully generated.  In this case the following Product Message would indicate a Failed Completion.\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application created the product\"/>            "
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Used to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-REFERENCE\"                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the product is referenced by a URI.  A product can be included in a message, referenced by a URI, or both.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-INCLUDE\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the product is included in this message.  A product can be included in a message, referenced by a URI, or both.\"/>"
    "<FIELD  NAME=\"PROD-MSGS-TO-SEND\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of PROD Msgs that will be published to satisfy the PROD REQ.\"/>"
    "<FIELD  NAME=\"PROD-SEQ-NUM\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates which message this is in the sequence of PROD Msgs that constitutes a product.\"/>"
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"TAC\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Category of product.  Could be echo of the PROD-TYPE field from the Product Request message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"DATA\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Subcategory of the product.  Could be echo of the PROD-SUBTYPE field of the Product Request Message.\"/>"
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc.)\"/>"
    "<FIELD  NAME=\"NUM-OF-FILES\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of files included in this response message.\"/>"
    "<FIELD  NAME=\"FILE.1.URI\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the file of the product is stored\"/>"
    "<FIELD  NAME=\"FILE.1.NAME-PATTERN\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"FILE.1.DESCRIPTION\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"FILE.1.FORMAT\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"FILE.1.VERSION\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"FILE.1.SIZE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"FILE.1.DATA\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.TLM.CCSDSFRAME\"                               "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.FORMAT\">           "
    "<!-- pp. 164 GMSEC Interface Spec 2014-02.docx -->                        "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"TLM\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"CCSDSFRAME\"                                              "
    "       	TYPE=\"STRING\"                                                   "
    "       	DESCRIPTION=\"Message contains CCSDS Frame\"/>                    "
    "<FIELD  NAME=\"COLLECTION-POINT\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Receiver, device, point, path, etc. where data was received.  Used to distinguish data simultaneously received at multiple collection points.\"/>"
    "<FIELD  NAME=\"STREAM-MODE\"                                              "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the mode of the stream of telemetry as either Real-time (RT), Replay (RPY), Simulator (SIM), or Test (TEST).\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true (and known, especially for replay data), indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"LENGTH\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Length of frame\"/>                                 "
    "<FIELD  NAME=\"TIME\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time of frame, usually ground receipt time\"/>      "
    "<FIELD  NAME=\"PHY-CHAN\"                                                 "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Physical channel on which data is received\"/>      "
    "<FIELD  NAME=\"VCID\"                                                     "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Virtual channel ID\"/>                              "
    "<FIELD  NAME=\"FRAMESYNC-STATUS\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"State of frame synchronization from equipment when frame is ingested (1:  Search, 2:  Verify, 3:  Lock, 4:  Check)\"/>"
    "<FIELD  NAME=\"RS-PRESENT\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates if the Reed-Solomon codes are present in the data.\"/>"
    "<FIELD  NAME=\"QUALITY-CHECK\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates quality checking performed, if applicable. If the bit is set the particular quality check was performed.  (Bit 0:  CRC Quality Check, Bit 1:  Reed-Solomon Quality Check, Bit 2:  Turbo Code Quality Check)\"/>"
    "<FIELD  NAME=\"QUALITY\"                                                  "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates quality state if checking is performed. If the bit is set the particular quality check failed.  (Bit 0:  CRC Quality State, Bit 1:  Reed-Solomon Quality State, Bit 2:  Turbo Code Quality State)\"/>"
    "<FIELD  NAME=\"DATA\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BIN\"                                                      "
    "        DESCRIPTION=\"Raw telemetry data\"/>                              "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.TLM.CCSDSPKT\"                                 "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.FORMAT\">           "
    "<!-- pp. 162 GMSEC Interface Spec 2014-02.docx -->                        "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"TLM\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2012\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"CCSDSPKT\"                                                "
    "       	TYPE=\"STRING\"                                                   "
    "       	DESCRIPTION=\"Message contains CCSDS packet\"/>                   "
    "<FIELD  NAME=\"COLLECTION-POINT\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Receiver, device, point, path, etc. where data was received.  Used to distinguish data simultaneously received at multiple collection points.\"/>"
    "<FIELD  NAME=\"STREAM-MODE\"                                              "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the mode of the stream of telemetry as either Real-time (RT), Replay (RPY), Simulator (SIM), or Test (TEST).\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true (and known, especially for replay data), indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"LENGTH\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Length of packet\"/>                                "
    "<FIELD  NAME=\"TIME\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time of packet, usually ground receipt time\"/>     "
    "<FIELD  NAME=\"PHY-CHAN\"                                                 "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Physical channel on which data is received\"/>      "
    "<FIELD  NAME=\"VCID\"                                                     "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Virtual channel ID\"/>                              "
    "<FIELD  NAME=\"QUALITY-CHECK\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates quality checking was performed for reason indicated.  (Bit 0:  Partial Packet)\"/>"
    "<FIELD  NAME=\"QUALITY\"                                                  "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates quality state if checking was performed  (Bit 0:  Partial Packet)\"/>"
    "<FIELD  NAME=\"DATA\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BIN\"                                                      "
    "        DESCRIPTION=\"Raw telemetry data\"/>                              "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.TLM.PROCESSED\"                                "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.FORMAT\">           "
    "<!-- pp. 167 GMSEC Interface Spec 2014-02.docx -->                        "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"TLM\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"PROCESSED\"                                               "
    "       	TYPE=\"STRING\"                                                   "
    "       	DESCRIPTION=\"Message contains a processed frame\"/>              "
    "<FIELD  NAME=\"COLLECTION-POINT\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Receiver, device, point, path, etc. where data was received.  Used to distinguish data simultaneously received at multiple collection points.\"/>"
    "<FIELD  NAME=\"STREAM-MODE\"                                              "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the mode of the stream of telemetry as either Real-time (RT), Replay (RPY), Simulator (SIM), or Test (TEST).\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true (and known, especially for replay data), indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"LENGTH\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Length of frame\"/>                                 "
    "<FIELD  NAME=\"TIME\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time of frame, usually ground receipt time\"/>      "
    "<FIELD  NAME=\"FRAMESYNC-STATUS\"                                         "
    "	MODE=\"OPTIONAL\"                                                        "
    "	FIELD_CLASS=\"STANDARD\"                                                 "
    "	VALUE=\"\"                                                               "
    "	TYPE=\"I16\"                                                             "
    "	DESCRIPTION=\"State of frame synchronization from equipment when frame is ingested (1:  Search, 2:  Verify, 3:  Lock, 4:  Check)\"/>"
    "<FIELD  NAME=\"NUM-OF-FORMAT-IDENTIFIERS\"                                "
    "	MODE=\"REQUIRED\"                                                        "
    "	FIELD_CLASS=\"STANDARD\"                                                 "
    "	VALUE=\"\"                                                               "
    "	TYPE=\"I16\"                                                             "
    "	DESCRIPTION=\"Number of fields used to identify the frames (e.g. TDM major/minor frames would have a value of 2). Zero is only permissible for vehicles with one telemetry format with a single type of frame.  Value in the range of 0+.\"/>"
    "<FIELD  NAME=\"FORMAT-IDENTIFIER.1.VALUE\"                                "
    "	MODE=\"OPTIONAL\"                                                        "
    "	FIELD_CLASS=\"STANDARD\"                                                 "
    "	VALUE=\"\"                                                               "
    "	TYPE=\"STRING\"                                                          "
    "	DESCRIPTION=\"Value of the first field used to identify the telemetry format (e.g. value of major frame ID for TDM telemetry). If the message is used with XTCE, this is the first restriction criteria in an XTCE container.\"/>"
    "<FIELD  NAME=\"NUM-OF-MNEMONICS\"                                         "
    "	MODE=\"REQUIRED\"                                                        "
    "	FIELD_CLASS=\"STANDARD\"                                                 "
    "	VALUE=\"\"                                                               "
    "	TYPE=\"I16\"                                                             "
    "	DESCRIPTION=\"Total number of mnemonics in this message.  Value in the range of 1+.\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.NAME\"                                          "
    "	MODE=\"REQUIRED\"                                                        "
    "	FIELD_CLASS=\"STANDARD\"                                                 "
    "	VALUE=\"\"                                                               "
    "	TYPE=\"STRING\"                                                          "
    "	DESCRIPTION=\"Name of the first mnemonic\"/>                             "
    "<FIELD  NAME=\"MNEMONIC.1.STATUS\"                                        "
    "	MODE=\"REQUIRED\"                                                        "
    "	FIELD_CLASS=\"STANDARD\"                                                 "
    "	VALUE=\"\"                                                               "
    "	TYPE=\"I16\"                                                             "
    "	DESCRIPTION=\"Status of the first mnemonic: valid mnemonic, or valid mnemonic with no data, or invalid mnemonic (1:  Valid, 2:  Valid, No data, 3:  Invalid)\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.UNITS\"                                         "
    "	MODE=\"OPTIONAL\"                                                        "
    "	FIELD_CLASS=\"STANDARD\"                                                 "
    "	VALUE=\"\"                                                               "
    "	TYPE=\"STRING\"                                                          "
    "	DESCRIPTION=\"Units associated with the value converted to engineering units for the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.NUM-OF-SAMPLES\"                                "
    "	MODE=\"REQUIRED\"                                                        "
    "	FIELD_CLASS=\"STANDARD\"                                                 "
    "	VALUE=\"\"                                                               "
    "	TYPE=\"I16\"                                                             "
    "	DESCRIPTION=\"Number of data samples for the first mnemonic.  This value should equal the number of times the mnemonic appears in the telemetry frame (e.g. will be greater than 1 for super-commutated telemetry points.\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.TIME-STAMP\"                           "
    "	MODE=\"OPTIONAL\"                                                        "
    "	FIELD_CLASS=\"STANDARD\"                                                 "
    "	VALUE=\"\"                                                               "
    "	TYPE=\"STRING\"                                                          "
    "	DESCRIPTION=\"Time stamp for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.RAW-VALUE\"                            "
    "	MODE=\"OPTIONAL\"                                                        "
    "	FIELD_CLASS=\"STANDARD\"                                                 "
    "	VALUE=\"\"                                                               "
    "	TYPE=\"I32\"                                                             "
    "	DESCRIPTION=\"Raw value for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.EU-VALUE\"                             "
    "	MODE=\"OPTIONAL\"                                                        "
    "	FIELD_CLASS=\"STANDARD\"                                                 "
    "	VALUE=\"\"                                                               "
    "	TYPE=\"F32\"                                                             "
    "	DESCRIPTION=\"Raw value converted to Engineering Units if engineering units conversion is present for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.TEXT-VALUE\"                           "
    "	MODE=\"OPTIONAL\"                                                        "
    "	FIELD_CLASS=\"STANDARD\"                                                 "
    "	VALUE=\"\"                                                               "
    "	TYPE=\"STRING\"                                                          "
    "	DESCRIPTION=\"Raw value converted to a text string if text conversion is present for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.LIMIT-ENABLE-DISABLE\"                 "
    "	MODE=\"REQUIRED\"                                                        "
    "	FIELD_CLASS=\"STANDARD\"                                                 "
    "	VALUE=\"\"                                                               "
    "	TYPE=\"BOOLEAN\"                                                         "
    "	DESCRIPTION=\"Indicates the limit checking state for the first data sample of the first mnemonic\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.MSG.TLM.TDM\"                                      "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.FORMAT\">           "
    "<!-- pp. 166 GMSEC Interface Spec 2014-02.docx -->                        "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"TLM\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"TDM\"                                                     "
    "       	TYPE=\"STRING\"                                                   "
    "       	DESCRIPTION=\"Message contains a TDM Frame\"/>                    "
    "<FIELD  NAME=\"COLLECTION-POINT\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Receiver, device, point, path, etc. where data was received.  Used to distinguish data simultaneously received at multiple collection points.\"/>"
    "<FIELD  NAME=\"STREAM-MODE\"                                              "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the mode of the stream of telemetry as either Real-time (RT), Replay (RPY), Simulator (SIM), or Test (TEST).\"/>"
    "<FIELD  NAME=\"FINAL-MESSAGE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"When true (and known, especially for replay data), indicates the last message in the stream.\"/>"
    "<FIELD  NAME=\"LENGTH\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Length of frame\"/>                                 "
    "<FIELD  NAME=\"TIME\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time of frame, usually ground receipt time\"/>      "
    "<FIELD  NAME=\"FRAMESYNC-STATUS\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"State of frame synchronization from equipment when frame is ingested (1:  Search, 2:  Verify, 3:  Lock, 4:  Check)\"/>"
    "<FIELD  NAME=\"DATA\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BIN\"                                                      "
    "        DESCRIPTION=\"Raw telemetry data\"/>                              "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.REQ.AMSG\"                                         "
    "ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE\">                          "
    "<!-- p. 125 GMSEC Interface Spec 2014-02.docx -->                         "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"REQ\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"AMSG\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message\"/>                 "
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"START-TIME\"                                               "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Requested start time of the messages to be retrieved from the Message Archive\"/>"
    "<FIELD  NAME=\"STOP-TIME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Requested stop time of the messages to be retrieved from the Message Archive. Defaults to the end of the Message Archive.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-REFERENCE\"                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates if the data will be referenced by a URI in the single response message.  Defaults to No.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-INCLUDE\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"YES\"                                                     "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates if the data is to be included in the single response message.  Defaults to Yes.\"/>"
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product being requested\"/>             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"AAA\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product type and subtype being requested. (See Table 4-29. Product Categories)\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"\"/>                                                "
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in the Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc. of the Product Message)\"/>"
    "<FIELD  NAME=\"URI\"                                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Location where the requesting component is asking for the product file(s) to be stored.  Could be a web address, directory or folder specification\"/>"
    "<FIELD  NAME=\"NAME-PATTERN\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the name of the output file\"/>           "
    "<FIELD  NAME=\"DESCRIPTION\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format\"/>                       "
    "<FIELD  NAME=\"VERSION\"                                                  "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version of the file\"/>              "
    "<FIELD  NAME=\"SIZE\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Maximum size of the file acceptable to the requester. Size specified in KB.\"/>"
    "<FIELD  NAME=\"REQ-STRING\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Specific to the responder / provider of the requested information.  The string will define a database query, a script expression, Unix statement, or some other statement for extracting the information from the provider’s repository.\"/>"
    "<FIELD  NAME=\"NUM-OF-MSGS\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of different message type / subtype pairs requested from the Message Archive.\"/>"
    "<FIELD  NAME=\"MSG.1.TYPE\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message Type/Subtype pairing to identify the message to be retrieved from the archive.\"/>"
    "<FIELD  NAME=\"MSG.1.SUBTYPE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"\"/>                                                "
    "<FIELD  NAME=\"MSG.1.TIME-FIELD-NAME\"                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of field in the message that contains the time to examine.  Will default to PUBLISH-TIME in Info. Bus Header.\"/>"
    "<FIELD  NAME=\"MSG.1.TIME-TYPE\"                                          "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"U16\"                                                      "
    "        DESCRIPTION=\"Indicates the format of the time to examine in the retrieved messages.  Defaults to GMSEC standard time format.\"/>"
    "<FIELD  NAME=\"MSG.1.NUM-OF-FIELDS\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of message fields to examine and match for retrieval from the archive\"/>"
    "<FIELD  NAME=\"MSG.1.FIELD.1.NAME\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the message field to match for retrieval from the archive\"/>"
    "<FIELD  NAME=\"MSG.1.FIELD.1.CONTENT\"                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Contents of the message field used in matching the messages for retrieval from the archive\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.REQ.AMVAL\"                                        "
    "ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE\">                          "
    "<!-- p. 208 GMSEC Interface Spec 2014-02.docx -->                         "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"REQ\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"AMVAL\"                                                   "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"START-TIME\"                                               "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Requested start time of the mnemonic values to be retrieved from the telemetry archive.\"/>"
    "<FIELD  NAME=\"STOP-TIME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Requested stop time of the mnemonic values to be retrieved from the telemetry archive. Defaults to the end of the telemetry archive\"/>"
    "<FIELD  NAME=\"PDB-VERSION\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Project Data Base version to be used by the responder when processing the archived data. Defaults to the PDB version used when the data was archived.\"/>"
    "<FIELD  NAME=\"COLLECTION-POINT\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Receiver, device, point, path, etc. where data was received.  Used to distinguish data simultaneously received at multiple collection points.\"/>"
    "<FIELD  NAME=\"RESPOND-VIA-MSG\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Indicates the message to use to deliver the mnemonic data.  MSG will be a stream of messages; RESP will be a single response message.  (MSG.AMVAL:  AMVAL Message, RESP.AMVAL:  AMVAL Response Message)\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-REFERENCE\"                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"This parameter is used only if “RESP.AMVAL” is selected above.  Indicates if the data will be referenced by a URI in the single response message.  Defaults to No.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-INCLUDE\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"TRUE\"                                                    "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"This parameter is used only if “RESP.AMVAL” is selected above.  Indicates if the data is to be included in the single response message.  Defaults to Yes.\"/>"
    "<FIELD  NAME=\"PLAYBACK-RATIO\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"If “MSG.AMVAL” is selected above, specifies the speed of data delivery as a ratio of playback rate to real-time rate.  > 0 and < 1 is slower than real-time rate = 1 is equal to the real-time rate > 1 is faster than real-time rate\"/>"
    "<FIELD  NAME=\"DATA-RATE\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"If “MSG.AMVAL” is selected above, specifies the speed of data delivery in Kilobits per second.  Value is in the range of > 0.\"/>"
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"The “PROD-” fields are optionally used when the “RESP.AMVAL” has been specified above.  Name of the product being requested.\"/>"
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"AAA\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product type and subtype being requested. (See Table 4-29. Product Categories... Value is AAA:  Archive and Assessment)\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"DATA\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"\"/>                                                "
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc. of the Product Message)\"/>"
    "<FIELD  NAME=\"URI\"                                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Location where the requesting component is asking for the product file(s) to be stored.  Could be a web address, directory or folder specification\"/>"
    "<FIELD  NAME=\"NAME-PATTERN\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the name of the output file\"/>           "
    "<FIELD  NAME=\"DESCRIPTION\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format\"/>                       "
    "<FIELD  NAME=\"VERSION\"                                                  "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version of the file\"/>              "
    "<FIELD  NAME=\"SIZE\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Maximum size of the file acceptable to the requester.\"/>"
    "<FIELD  NAME=\"NUM-OF-MNEMONICS\"                                         "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Total Number of mnemonics being requested\"/>       "
    "<FIELD  NAME=\"MNEMONIC.1.NAME\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the mnemonic\"/>                            "
    "<FIELD  NAME=\"MNEMONIC.1.DATA-TYPE\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"3\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the data type to be returned, either the raw value, or the converted value (Engineering Units or Text converted), or both.  Defaults to both.  (1:  Raw, 2:  Converted, 3:  Both)\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.STATE-ATTRIBUTES\"                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates if the State Attributes (flags, limits, static flag, and data quality) of the mnemonic are to be returned. Defaults to No.  (1:  Node, 2:  Yes)\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.CRITERIA\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identification of how data should be sampled for the mnemonic. Includes either upon change of data (value, flags or status), or every sample, or at a specified sampling rate.  Defaults to “Change” only data.  (1:  Change value, flags, status, 2:  Every Sample, 3:  Sample Rate\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE-RATE\"                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"If CRITERIA is specified as “Sample Rate”, this field will specify the data sampling rate for the mnemonic.  Value is in the range of 1+.\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.REQ.CMD\"                                          "
    "ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE\">                          "
    "<!-- p. 246 GMSEC Interface Spec 2014-02.docx -->                         "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"REQ\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"CMD\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2012\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID set by the originator for this Command. Can be a sequence number.  Aids in synchronizing responses and other messaging related to the specific Command\"/>"
    "<FIELD  NAME=\"CMD-SOURCE\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Which user/workposition/proc/schedule the message originated from\"/>"
    "<FIELD  NAME=\"CMD-FORMAT\"                                               "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Type of command (CCSDSPACKET, CCSDSFRAME, CLTU, MNEMONIC, RAW, TDM)\"/>"
    "<FIELD  NAME=\"CMD-DATA\"                                                 "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BIN\"                                                      "
    "        DESCRIPTION=\"Command data\"/>                                    "
    "<FIELD  NAME=\"LENGTH\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Length of CMD-DATA\"/>                              "
    "<FIELD  NAME=\"VCID\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"CCSDS Virtual Channel ID\"/>                        "
    "<FIELD  NAME=\"BYPASS\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"CCSDS COP-1 flag for “Bypass of Acceptance Check”, i.e. without verification\"/>"
    "<FIELD  NAME=\"FRAME-COUNTER\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Reset to next expected command counter\"/>          "
    "<FIELD  NAME=\"APID\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Application Process Identifier\"/>                  "
    "<FIELD  NAME=\"PACKET-COUNTER\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"\"/>                                                "
    "<FIELD  NAME=\"CMD-TYPE\"                                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"If REALTIME, execute upon receipt.  If FUTURE, execute at SPACECRAFT-EXECTION-TIME.  (REALTIME and FUTURE are the two values allowed.)\"/>"
    "<FIELD  NAME=\"RELEASE-TIME\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time the command should begin being released from the front end processor to the remote tracking station.\"/>"
    "<FIELD  NAME=\"EARLIEST-UPLINK-TIME\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Absolute or relative time can apply.\"/>            "
    "<FIELD  NAME=\"LATEST-UPLINK-TIME\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Absolute or relative time can apply.\"/>            "
    "<FIELD  NAME=\"SPACECRAFT-EXECUTION-TIME\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Required if CMD-TYPE = ‘FUTURE”.  Absolute or relative time can apply.\"/>"
    "<FIELD  NAME=\"RESPONSE\"                                                 "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates if a response is required.  Defaults to No.\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.REQ.DB\"                                           "
    "ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE\">                          "
    "<!-- p. 230 GMSEC Interface Spec 2014-02.docx -->                         "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"REQ\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"DB\"                                                      "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"ATTRIBUTE-TYPE\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the type of Database Attributes to be returned.  (1:  Limit sets, 2:  Text conversion, 3:  Calibration Curve, 4:  Short Description,  5:  Long Description, 6:  List of All Mnemonics\"/>"
    "<FIELD  NAME=\"PDB-VERSION\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Project Data Base version to be used by the responder if multiple project databases are supported. Defaults to the most recent PDB version.\"/>"
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"TAC\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product type and subtype being requested. (See Table 4-29. Product Categories... Value is TAC:  Telemetry and Command)\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"DB\"                                                      "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"\"/>                                                "
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.  Value in the range of 1+.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc. of the Product Message)\"/>"
    "<FIELD  NAME=\"URI\"                                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Location where the requesting component is asking for the product file(s) to be stored.  Could be a web address, directory or folder specification\"/>"
    "<FIELD  NAME=\"NAME-PATTERN\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the name of the output file\"/>           "
    "<FIELD  NAME=\"DESCRIPTION\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format\"/>                       "
    "<FIELD  NAME=\"VERSION\"                                                  "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version of the file\"/>              "
    "<FIELD  NAME=\"SIZE\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Maximum size of the file acceptable to the requester. Size specified in KB.\"/>"
    "<FIELD  NAME=\"NUM-OF-MNEMONICS\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Total Number of mnemonics being requested\"/>       "
    "<FIELD  NAME=\"MNEMONIC.1.NAME\"                                          "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the first mnemonic\"/>                      "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.REQ.DIR\"                                          "
    "ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE\">                          "
    "<!-- pp. 137, 138 GMSEC Interface Spec 2014-02.docx -->                   "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"REQ\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"DIR\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"1.0\"                                                     "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID set by the originator for this directive. Can be a sequence number.  Aids in synchronizing responses and other messaging related to the specific directive\"/>"
    "<FIELD  NAME=\"USER\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Which user/workposition/proc/schedule the message is coming from\"/>"
    "<FIELD  NAME=\"DIRECTIVE-KEYWORD\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Keyword extracted from the directive string.  Useful for routing/processing\"/>"
    "<FIELD  NAME=\"DIRECTIVE-STRING\"                                         "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Full directive string that includes the keyword\"/> "
    "<FIELD  NAME=\"SPECIAL-INFO\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BIN\"                                                      "
    "        DESCRIPTION=\"For application use\"/>                             "
    "<FIELD  NAME=\"PRIORITY\"                                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates processing priority, if applicable\"/>    "
    "<FIELD  NAME=\"RESPONSE\"                                                 "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"BOOL\"                                                     "
    "        DESCRIPTION=\"Indicates if a response is required.  Defaults to No.\"/>"
    "<FIELD  NAME=\"REQUESTED-EXECUTION-TIME\"                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Absolute or relative time can apply.\"/>            "
    "<FIELD  NAME=\"REQUESTED-EXPIRATION-TIME\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Absolute or relative time can apply.\"/>            "
    "</SCHEMA>                                                                  "
,

    "<SCHEMA NAME=\"2014.00.REQ.MVAL\"                                         "
    "ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE\">                          "
    "<!-- p. 186 GMSEC Interface Spec 2014-02.docx -->                         "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"REQ\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MVAL\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2012\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"REQUEST-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the type of mnemonic value request message.  (1:  Oneshot, 2:  Start, 3:  Stop)\"/>"
    "<FIELD  NAME=\"PUBLISH-RATE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"5\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the rate, in number of seconds, which the Mnemonic Value Data messages are published. Zero means the server should publish the data as fast as possible. Default rate = 5 seconds.  Value is in the range 0+.\"/>"
    "<FIELD  NAME=\"START-TIME\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Requested start time (absolute or relative) of the mnemonic values.\"/>"
    "<FIELD  NAME=\"STOP-TIME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Requested stop time (absolute or relative) of the mnemonic values.\"/>"
    "<FIELD  NAME=\"DURATION\"                                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Length of time from “now”, in seconds, for the request to be active, after which the data messages will automatically cease.  Value in the range of 1+.\"/>"
    "<FIELD  NAME=\"COLLECTION-POINT\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Receiver, device, point, path, etc. where data was received.  Used to distinguish data simultaneously received at multiple collection points.\"/>"
    "<FIELD  NAME=\"NUM-OF-MNEMONICS\"                                         "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Total Number of mnemonics being requested.  Required only for Oneshot and Start.  Value is in the range 1+.\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.NAME\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the mnemonic.  Required only for Oneshot and Start.\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.DATA-TYPE\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"3\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the data type to be returned, either the raw value, or the converted value (Engineering Units or Text converted), or both. Defaults to both.  (1:  Raw, 2:  Converted, 3:  Both)\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.STATE-ATTRIBUTES\"                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates if State Attributes (flags, limits, static flag, and data quality) are to be returned. Defaults to No.  (1:  No, 2:  Yes)\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.CRITERIA\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identification of when data should be provided for the mnemonic. Includes either upon change of data (value, flags or status), or every sample, or at a specified sampling rate. The default Criteria is “Change” only data.  (1:  Change value, flags, status, 2:  Every Sample, 3:  Sample Rate)\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE-RATE\"                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"If CRITERIA is specified as “Sample Rate”, this field will specify the data sampling rate for the mnemonic.  Value in the range of 1+; units is milliseconds.\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.REQ.PROD.AAA\"                                     "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.PROD-TYPE\">        "
    "<!-- pp 253, 254-255 of GMSEC Interface Spec 2014-02.docx -->             "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"REQ\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"PROD\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"START-TIME\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Requested start time for the scope of the product to cover.\"/>"
    "<FIELD  NAME=\"STOP-TIME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Requested stop time for the scope of the product to cover.\"/>"
    "<FIELD  NAME=\"REQ-STRING\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Specific to the product provider.  The string will define a database query, a script expression, Directive string, or some other keyword syntax made known by the provider.\"/>"
    "<FIELD  NAME=\"NUM-OF-INPUT-FILES\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of files included in this request message.\"/>"
    "<FIELD  NAME=\"INPUT-FILE.1.URI\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the input file is located\"/>"
    "<FIELD  NAME=\"INPUT-FILE.1.NAME-PATTERN\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"INPUT-FILE.1.DESCRIPTION\"                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"INPUT-FILE.1.FORMAT\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"INPUT-FILE.1.VERSION\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"INPUT-FILE.1.SIZE\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"INPUT-FILE.1.DATA\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "<FIELD  NAME=\"INPUT-FILE.1.URI\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the file of the product is stored\"/>"
    "<FIELD  NAME=\"INPUT-FILE.1.NAME-PATTERN\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"INPUT-FILE.1.DESCRIPTION\"                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"INPUT-FILE.1.FORMAT\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"INPUT-FILE.1.VERSION\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"INPUT-FILE.1.SIZE\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"INPUT-FILE.1.DATA\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"AAA\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product type being requested. See Table 4-29. Product Categories\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"DATA\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product subtype being requested. See Table 4-29. Product Categories\"/>"
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc. of the Product Message)\"/>"
    "<FIELD  NAME=\"RESPOND-VIA-MSG\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"MSG.PROD\"                                                "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Indicates the message to use to deliver the product.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-REFERENCE\"                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates if the product will be referenced by a URI in the message specified above.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-INCLUDE\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates if the product is to be included in the message specified above.\"/>"
    "<FIELD  NAME=\"URI\"                                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Location where the requesting component is asking for the product file(s) to be stored.  Could be a web address, directory or folder specification\"/>"
    "<FIELD  NAME=\"NAME-PATTERN\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format\"/>                       "
    "<FIELD  NAME=\"VERSION\"                                                  "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"SIZE\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Maximum size of the file acceptable to the requester. Size specified in KB.\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.REQ.PROD.AUTO\"                                    "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.PROD-TYPE\">        "
    "<!-- pp 253, 254-255 of GMSEC Interface Spec 2014-02.docx -->             "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"REQ\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"PROD\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"START-TIME\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Requested start time for the scope of the product to cover.\"/>"
    "<FIELD  NAME=\"STOP-TIME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Requested stop time for the scope of the product to cover.\"/>"
    "<FIELD  NAME=\"REQ-STRING\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Specific to the product provider.  The string will define a database query, a script expression, Directive string, or some other keyword syntax made known by the provider.\"/>"
    "<FIELD  NAME=\"NUM-OF-INPUT-FILES\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of files included in this request message.\"/>"
    "<FIELD  NAME=\"INPUT-FILE.1.URI\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the input file is located\"/>"
    "<FIELD  NAME=\"INPUT-FILE.1.NAME-PATTERN\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"INPUT-FILE.1.DESCRIPTION\"                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"INPUT-FILE.1.FORMAT\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"INPUT-FILE.1.VERSION\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"INPUT-FILE.1.SIZE\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"INPUT-FILE.1.DATA\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "<FIELD  NAME=\"INPUT-FILE.1.URI\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the file of the product is stored\"/>"
    "<FIELD  NAME=\"INPUT-FILE.1.NAME-PATTERN\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"INPUT-FILE.1.DESCRIPTION\"                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"INPUT-FILE.1.FORMAT\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"INPUT-FILE.1.VERSION\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"INPUT-FILE.1.SIZE\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"INPUT-FILE.1.DATA\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"AUTO\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product type being requested. See Table 4-29. Product Categories\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"DM\"                                                      "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product subtype being requested. See Table 4-29. Product Categories\"/>"
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc. of the Product Message)\"/>"
    "<FIELD  NAME=\"RESPOND-VIA-MSG\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"MSG.PROD\"                                                "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Indicates the message to use to deliver the product.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-REFERENCE\"                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates if the product will be referenced by a URI in the message specified above.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-INCLUDE\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates if the product is to be included in the message specified above.\"/>"
    "<FIELD  NAME=\"URI\"                                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Location where the requesting component is asking for the product file(s) to be stored.  Could be a web address, directory or folder specification\"/>"
    "<FIELD  NAME=\"NAME-PATTERN\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format\"/>                       "
    "<FIELD  NAME=\"VERSION\"                                                  "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"SIZE\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Maximum size of the file acceptable to the requester. Size specified in KB.\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.REQ.PROD.FD\"                                      "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.PROD-TYPE\">        "
    "<!-- pp 253, 254-255 of GMSEC Interface Spec 2014-02.docx -->             "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"REQ\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"PROD\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"START-TIME\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Requested start time for the scope of the product to cover.\"/>"
    "<FIELD  NAME=\"STOP-TIME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Requested stop time for the scope of the product to cover.\"/>"
    "<FIELD  NAME=\"REQ-STRING\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Specific to the product provider.  The string will define a database query, a script expression, Directive string, or some other keyword syntax made known by the provider.\"/>"
    "<FIELD  NAME=\"NUM-OF-INPUT-FILES\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of files included in this request message.\"/>"
    "<FIELD  NAME=\"INPUT-FILE.1.URI\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the input file is located\"/>"
    "<FIELD  NAME=\"INPUT-FILE.1.NAME-PATTERN\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"INPUT-FILE.1.DESCRIPTION\"                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"INPUT-FILE.1.FORMAT\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"INPUT-FILE.1.VERSION\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"INPUT-FILE.1.SIZE\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"INPUT-FILE.1.DATA\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "<FIELD  NAME=\"INPUT-FILE.1.URI\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the file of the product is stored\"/>"
    "<FIELD  NAME=\"INPUT-FILE.1.NAME-PATTERN\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"INPUT-FILE.1.DESCRIPTION\"                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"INPUT-FILE.1.FORMAT\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"INPUT-FILE.1.VERSION\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"INPUT-FILE.1.SIZE\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"INPUT-FILE.1.DATA\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FD\"                                                      "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product type being requested. See Table 4-29. Product Categories\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"ATT\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product subtype being requested. See Table 4-29. Product Categories\"/>"
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc. of the Product Message)\"/>"
    "<FIELD  NAME=\"RESPOND-VIA-MSG\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"MSG.PROD\"                                                "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Indicates the message to use to deliver the product.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-REFERENCE\"                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates if the product will be referenced by a URI in the message specified above.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-INCLUDE\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates if the product is to be included in the message specified above.\"/>"
    "<FIELD  NAME=\"URI\"                                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Location where the requesting component is asking for the product file(s) to be stored.  Could be a web address, directory or folder specification\"/>"
    "<FIELD  NAME=\"NAME-PATTERN\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format\"/>                       "
    "<FIELD  NAME=\"VERSION\"                                                  "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"SIZE\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Maximum size of the file acceptable to the requester. Size specified in KB.\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.REQ.PROD.MAS\"                                     "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.PROD-TYPE\">        "
    "<!-- pp 253, 254-255 of GMSEC Interface Spec 2014-02.docx -->             "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"REQ\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"PROD\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"START-TIME\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Requested start time for the scope of the product to cover.\"/>"
    "<FIELD  NAME=\"STOP-TIME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Requested stop time for the scope of the product to cover.\"/>"
    "<FIELD  NAME=\"REQ-STRING\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Specific to the product provider.  The string will define a database query, a script expression, Directive string, or some other keyword syntax made known by the provider.\"/>"
    "<FIELD  NAME=\"NUM-OF-INPUT-FILES\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of files included in this request message.\"/>"
    "<FIELD  NAME=\"INPUT-FILE.1.URI\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the input file is located\"/>"
    "<FIELD  NAME=\"INPUT-FILE.1.NAME-PATTERN\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"INPUT-FILE.1.DESCRIPTION\"                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"INPUT-FILE.1.FORMAT\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"INPUT-FILE.1.VERSION\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"INPUT-FILE.1.SIZE\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"INPUT-FILE.1.DATA\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "<FIELD  NAME=\"INPUT-FILE.1.URI\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the file of the product is stored\"/>"
    "<FIELD  NAME=\"INPUT-FILE.1.NAME-PATTERN\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"INPUT-FILE.1.DESCRIPTION\"                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"INPUT-FILE.1.FORMAT\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"INPUT-FILE.1.VERSION\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"INPUT-FILE.1.SIZE\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"INPUT-FILE.1.DATA\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"MAS\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product type being requested. See Table 4-29. Product Categories\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"DATA\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product subtype being requested. See Table 4-29. Product Categories\"/>"
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc. of the Product Message)\"/>"
    "<FIELD  NAME=\"RESPOND-VIA-MSG\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"MSG.PROD\"                                                "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Indicates the message to use to deliver the product.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-REFERENCE\"                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates if the product will be referenced by a URI in the message specified above.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-INCLUDE\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates if the product is to be included in the message specified above.\"/>"
    "<FIELD  NAME=\"URI\"                                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Location where the requesting component is asking for the product file(s) to be stored.  Could be a web address, directory or folder specification\"/>"
    "<FIELD  NAME=\"NAME-PATTERN\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format\"/>                       "
    "<FIELD  NAME=\"VERSION\"                                                  "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"SIZE\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Maximum size of the file acceptable to the requester. Size specified in KB.\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.REQ.PROD.PAS\"                                     "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.PROD-TYPE\">        "
    "<!-- pp 253, 254-255 of GMSEC Interface Spec 2014-02.docx -->             "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"REQ\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"PROD\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"START-TIME\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Requested start time for the scope of the product to cover.\"/>"
    "<FIELD  NAME=\"STOP-TIME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Requested stop time for the scope of the product to cover.\"/>"
    "<FIELD  NAME=\"REQ-STRING\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Specific to the product provider.  The string will define a database query, a script expression, Directive string, or some other keyword syntax made known by the provider.\"/>"
    "<FIELD  NAME=\"NUM-OF-INPUT-FILES\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of files included in this request message.\"/>"
    "<FIELD  NAME=\"INPUT-FILE.1.URI\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the input file is located\"/>"
    "<FIELD  NAME=\"INPUT-FILE.1.NAME-PATTERN\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"INPUT-FILE.1.DESCRIPTION\"                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"INPUT-FILE.1.FORMAT\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"INPUT-FILE.1.VERSION\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"INPUT-FILE.1.SIZE\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"INPUT-FILE.1.DATA\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "<FIELD  NAME=\"INPUT-FILE.1.URI\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the file of the product is stored\"/>"
    "<FIELD  NAME=\"INPUT-FILE.1.NAME-PATTERN\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"INPUT-FILE.1.DESCRIPTION\"                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"INPUT-FILE.1.FORMAT\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"INPUT-FILE.1.VERSION\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"INPUT-FILE.1.SIZE\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"INPUT-FILE.1.DATA\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"PAS\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product type being requested. See Table 4-29. Product Categories\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"SCH\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product subtype being requested. See Table 4-29. Product Categories\"/>"
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc. of the Product Message)\"/>"
    "<FIELD  NAME=\"RESPOND-VIA-MSG\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"MSG.PROD\"                                                "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Indicates the message to use to deliver the product.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-REFERENCE\"                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates if the product will be referenced by a URI in the message specified above.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-INCLUDE\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates if the product is to be included in the message specified above.\"/>"
    "<FIELD  NAME=\"URI\"                                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Location where the requesting component is asking for the product file(s) to be stored.  Could be a web address, directory or folder specification\"/>"
    "<FIELD  NAME=\"NAME-PATTERN\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format\"/>                       "
    "<FIELD  NAME=\"VERSION\"                                                  "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"SIZE\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Maximum size of the file acceptable to the requester. Size specified in KB.\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.REQ.PROD.SC\"                                      "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.PROD-TYPE\">        "
    "<!-- pp 253, 254-255 of GMSEC Interface Spec 2014-02.docx -->             "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"REQ\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"PROD\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"START-TIME\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Requested start time for the scope of the product to cover.\"/>"
    "<FIELD  NAME=\"STOP-TIME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Requested stop time for the scope of the product to cover.\"/>"
    "<FIELD  NAME=\"REQ-STRING\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Specific to the product provider.  The string will define a database query, a script expression, Directive string, or some other keyword syntax made known by the provider.\"/>"
    "<FIELD  NAME=\"NUM-OF-INPUT-FILES\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of files included in this request message.\"/>"
    "<FIELD  NAME=\"INPUT-FILE.1.URI\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the input file is located\"/>"
    "<FIELD  NAME=\"INPUT-FILE.1.NAME-PATTERN\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"INPUT-FILE.1.DESCRIPTION\"                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"INPUT-FILE.1.FORMAT\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"INPUT-FILE.1.VERSION\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"INPUT-FILE.1.SIZE\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"INPUT-FILE.1.DATA\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "<FIELD  NAME=\"INPUT-FILE.1.URI\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the file of the product is stored\"/>"
    "<FIELD  NAME=\"INPUT-FILE.1.NAME-PATTERN\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"INPUT-FILE.1.DESCRIPTION\"                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"INPUT-FILE.1.FORMAT\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"INPUT-FILE.1.VERSION\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"INPUT-FILE.1.SIZE\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"INPUT-FILE.1.DATA\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"SC\"                                                      "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product type being requested. See Table 4-29. Product Categories\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product subtype being requested. See Table 4-29. Product Categories\"/>"
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc. of the Product Message)\"/>"
    "<FIELD  NAME=\"RESPOND-VIA-MSG\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"MSG.PROD\"                                                "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Indicates the message to use to deliver the product.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-REFERENCE\"                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates if the product will be referenced by a URI in the message specified above.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-INCLUDE\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates if the product is to be included in the message specified above.\"/>"
    "<FIELD  NAME=\"URI\"                                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Location where the requesting component is asking for the product file(s) to be stored.  Could be a web address, directory or folder specification\"/>"
    "<FIELD  NAME=\"NAME-PATTERN\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format\"/>                       "
    "<FIELD  NAME=\"VERSION\"                                                  "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"SIZE\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Maximum size of the file acceptable to the requester. Size specified in KB.\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.REQ.PROD.TAC\"                                     "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.PROD-TYPE\">        "
    "<!-- pp 253, 254-255 of GMSEC Interface Spec 2014-02.docx -->             "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"REQ\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"PROD\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"START-TIME\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Requested start time for the scope of the product to cover.\"/>"
    "<FIELD  NAME=\"STOP-TIME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Requested stop time for the scope of the product to cover.\"/>"
    "<FIELD  NAME=\"REQ-STRING\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Specific to the product provider.  The string will define a database query, a script expression, Directive string, or some other keyword syntax made known by the provider.\"/>"
    "<FIELD  NAME=\"NUM-OF-INPUT-FILES\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of files included in this request message.\"/>"
    "<FIELD  NAME=\"INPUT-FILE.1.URI\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the input file is located\"/>"
    "<FIELD  NAME=\"INPUT-FILE.1.NAME-PATTERN\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"INPUT-FILE.1.DESCRIPTION\"                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"INPUT-FILE.1.FORMAT\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"INPUT-FILE.1.VERSION\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"INPUT-FILE.1.SIZE\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"INPUT-FILE.1.DATA\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "<FIELD  NAME=\"INPUT-FILE.1.URI\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the file of the product is stored\"/>"
    "<FIELD  NAME=\"INPUT-FILE.1.NAME-PATTERN\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"INPUT-FILE.1.DESCRIPTION\"                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"INPUT-FILE.1.FORMAT\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"INPUT-FILE.1.VERSION\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"INPUT-FILE.1.SIZE\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"INPUT-FILE.1.DATA\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"TAC\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product type being requested. See Table 4-29. Product Categories\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"DATA\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product subtype being requested. See Table 4-29. Product Categories\"/>"
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc. of the Product Message)\"/>"
    "<FIELD  NAME=\"RESPOND-VIA-MSG\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"MSG.PROD\"                                                "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Indicates the message to use to deliver the product.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-REFERENCE\"                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates if the product will be referenced by a URI in the message specified above.\"/>"
    "<FIELD  NAME=\"DELIVER-VIA-INCLUDE\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates if the product is to be included in the message specified above.\"/>"
    "<FIELD  NAME=\"URI\"                                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Location where the requesting component is asking for the product file(s) to be stored.  Could be a web address, directory or folder specification\"/>"
    "<FIELD  NAME=\"NAME-PATTERN\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format\"/>                       "
    "<FIELD  NAME=\"VERSION\"                                                  "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"SIZE\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Maximum size of the file acceptable to the requester. Size specified in KB.\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.REQ.RTLM\"                                         "
    "ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE\">                          "
    "<!-- p. 174 GMSEC Interface Spec 2014-02.docx -->                         "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"REQ\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RTLM\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2012\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"ACTION\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the desired action to perform on the telemetry data stream.  (1:  Start, 2:  Stop, 3:  Pause, 4:  Continue, 5:  Step)\"/>"
    "<FIELD  NAME=\"STREAM-MODE\"                                              "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the type of data to be published.  (RT:  Real Time, RPY:  Replay/Playback, SIM:  Simulator, TEST:  Test/Data Generator)\"/>"
    "<FIELD  NAME=\"PLAYBACK-RATIO\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1.0\"                                                     "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Speed of playback as a ratio of playback rate to real-time rate.  This is the default method; default = 1.  > 0 and < 1 is slower than real-time rate = 1 is equal to the real-time rate > 1 is faster than real-time rate\"/>"
    "<FIELD  NAME=\"DATA-RATE\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Data rate in Kilobits per second.  Value in the range of > 0.\"/>"
    "<FIELD  NAME=\"START-TIME\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time (absolute or relative) of first telemetry data. Defaults to the start of the archive\"/>"
    "<FIELD  NAME=\"STOP-TIME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time of last telemetry data. Defaults to the end of the archive\"/>"
    "<FIELD  NAME=\"ORBIT\"                                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Orbit or revolution number of the vehicle (past or future).  Value in the range of 0+.\"/>"
    "<FIELD  NAME=\"NUM-OF-FILES\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of Telemetry files to replay.  Value in the range of 1+.\"/>"
    "<FIELD  NAME=\"FILE.1.NAME-PATTERN\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the first file\"/>                          "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Telemetry Message types to playback.  Note: A provider may not capable of providing all types, e.g. only raw or only processed data (ALL:  All message types, CCSDSPKT:  CCSDS packets, CCSDSFRAME:  CCSDS frames, TDM:  TDM frames, PROCESSED:  Converted TLM)\"/>"
    "<FIELD  NAME=\"COLLECTION-POINT\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Receiver, device, point, path, etc. where data was received.  Used to distinguish data simultaneously received at multiple collection points.\"/>"
    "<FIELD  NAME=\"STREAM-MODE\"                                              "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the type of data to be published.  (RT:  Real Time, RPY:  Replay/Playback, SIM:  Simulator, TEST:  Test/Data Generator)\"/>"
    "<FIELD  NAME=\"VCID\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Virtual Channel IDs: comma delimited channel IDs with ‘-‘ for channel ID ranges. Example: 1,2,6-9,10\"/>"
    "<FIELD  NAME=\"APID\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"AP IDs: comma delimited AP IDs with ‘-‘ for channel ID ranges. Example: 1,2,6-9,10\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.REQ.SERV\"                                         "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE\">                  "
    "<!-- pp 270 of GMSEC Interface Spec 2014-02.docx -->                      "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"REQ\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"SERV\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2012\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID set by the originator of this message. Can be a sequence number.  Aids in synchronizing responses.\"/>"
    "<FIELD  NAME=\"USER\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Which user/workposition/proc/schedule the message is coming from\"/>"
    "<FIELD  NAME=\"SERVICE-NAME\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the service offered by a component.\"/>     "
    "<FIELD  NAME=\"SERVICE-NUMBER\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of the service.\"/>                          "
    "<FIELD  NAME=\"SERVICE-VERSION\"                                          "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Version of the service\"/>                          "
    "<FIELD  NAME=\"OPERATION-NAME\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the operation within the specified service.\"/>"
    "<FIELD  NAME=\"OPERATION-NUMBER\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of the operation within the specified service.\"/>"
    "<FIELD  NAME=\"OPERATION-VERSION\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Version of the operation within the specified service.\"/>"
    "<FIELD  NAME=\"NUM-OF-PARAMS\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of parameters included in the service request\"/>"
    "<FIELD  NAME=\"PARAM.1.NAME\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the parameter\"/>                           "
    "<FIELD  NAME=\"PARAM.1.VALUE\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"UNSET\"                                                    "
    "        DESCRIPTION=\"Value of the parameter Component must ascertain the data type before accessing the value (e.g. with a function call).  Of type 'Variable' in the GMSEC ISD.\"/>"
    "<FIELD  NAME=\"PRIORITY\"                                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates processing priority, if applicable (1:  Nominal, 2:  Medium, 3:  High)\"/>"
    "<FIELD  NAME=\"RESPONSE\"                                                 "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FALSE\"                                                   "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates if a response is required.  Defaults to No.\"/>"
    "<FIELD  NAME=\"REQUESTED-EXECUTION-TIME\"                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Absolute or relative time can apply.\"/>            "
    "<FIELD  NAME=\"REQUESTED-EXPIRATION-TIME\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Absolute or relative time can apply.\"/>            "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.RESP.AMSG\"                                        "
    "ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE\">                          "
    "<!-- p. 129 GMSEC Interface Spec 2014-02.docx -->                         "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RESP\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"AMSG\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the Request message\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Archive retrieval message Request being processed\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application completed processing the request\"/>"
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS. Used to indicate product URI as requestor or responder.  Also can be used to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product being returned\"/>              "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"AAA\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product type and subtype being requested. (See Table 4-29. Product Categories)\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"MSG\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"\"/>                                                "
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.  In the range 0+.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc. of the Product Message)\"/>"
    "<FIELD  NAME=\"URI\"                                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the file product is stored\"/>"
    "<FIELD  NAME=\"NAME-PATTERN\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the name of the file\"/>                  "
    "<FIELD  NAME=\"DESCRIPTION\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file contents in text or xml\"/> "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format of the file\"/>           "
    "<FIELD  NAME=\"VERSION\"                                                  "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Indicates the version of the file\"/>               "
    "<FIELD  NAME=\"SIZE\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Actual size of the file\"/>                         "
    "<FIELD  NAME=\"DATA\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BIN\"                                                      "
    "        DESCRIPTION=\"The file content\"/>                                "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.RESP.AMVAL\"                                       "
    "ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE\">                          "
    "<!-- p. 214 GMSEC Interface Spec 2014-02.docx -->                         "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RESP\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"AMVAL\"                                                   "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the Archive Mnemonic Value Request message.\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Archive Mnemonic Value Request Message that was processed.  (1:  Acknowledgement, 2:  Working/Keep Alive, 3:  Successful Completion, 4:  Failed Completion, 5:  Invalid Request, 6:  Final Message\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application completed processing the request\"/>"
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Useful to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product.\"/>                            "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"AAA\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product type and subtype being requested. (See Table 4-29. Product Categories... Value is AAA:  Archive and Assessment)\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"DATA\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"\"/>                                                "
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"DATA\"                                                    "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc. of the Product Message)\"/>"
    "<FIELD  NAME=\"URI\"                                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the (single) output file product is stored\"/>"
    "<FIELD  NAME=\"NAME-PATTERN\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the name of the output file\"/>           "
    "<FIELD  NAME=\"DESCRIPTION\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format\"/>                       "
    "<FIELD  NAME=\"VERSION\"                                                  "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version of the file\"/>              "
    "<FIELD  NAME=\"SIZE\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Actual size of the file\"/>                         "
    "<FIELD  NAME=\"DATA\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BIN\"                                                      "
    "        DESCRIPTION=\"The file content\"/>                                "
    "<FIELD  NAME=\"NUM-OF-MNEMONICS\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Total number of mnemonics returned\"/>              "
    "<FIELD  NAME=\"MNEMONIC.1.NAME\"                                          "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the 1st mnemonic\"/>                        "
    "<FIELD  NAME=\"MNEMONIC.1.STATUS\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Status of the 1st mnemonic: valid mnemonic or valid mnemonic with no data or invalid mnemonic (1:  Valid, 2:  Valid, Nodata, 3:  Invalid\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.RESP.CMD\"                                         "
    "ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE\">                          "
    "<!-- p. 249 GMSEC Interface Spec 2014-02.docx -->                         "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RESP\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"CMD\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2012\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the Command request message.\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Command being processed (1:  Acknowledgement, 2:  Working/Keep alive, 3:  Successful Completion, 4:  Failed Completion, 5:  Invalid Request, 6:  Final Message)\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application completed processing the Command\"/>"
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Useful to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"RELEASE-TIME\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time command finished being released from the front end processor to the remote tracking station.\"/>"
    "<FIELD  NAME=\"XTCE-STATUS\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Status codes from the OMG XML Telemetric and Command data Exchange data specification.  (1:  Acknowledgement, 2:  Invalid, 3:  TransferredToRange, 4:  SentFromRange, 5:  Received, 6:  Accepted, 7:  Queued,, 8:  Executing, 9:  Complete, 10:  Failed)\"/>"
    "<FIELD  NAME=\"RETURN-DATA\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"UNSET\"                                                    "
    "        DESCRIPTION=\"Additional data that may be desired along with the completion status\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.RESP.DB.1\"                                        "
    "ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.ATTRIBUTE-TYPE\">           "
    "<!-- p. 234 GMSEC Interface Spec 2014-02.docx -->                         "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RESP\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"DB\"                                                      "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2006\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Database Attributes Request Message that was processed.  (1:  Acknowledgement, 2:  Working/Keep Alive, 3:  Successful Completion, 4:  Failed Completion, 5:  Invalid Request)\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application completed processing the request\"/>"
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Useful to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"ATTRIBUTE-TYPE\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the type of Database Attributes for the first mnemonic to be returned.  Value is 1:  Limit sets\"/>"
    "<FIELD  NAME=\"NUM-OF-MNEMONICS\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Total number of mnemonics returned\"/>              "
    "<FIELD  NAME=\"MNEMONIC.1.NAME\"                                          "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the Mnemonic\"/>                            "
    "<FIELD  NAME=\"MNEMONIC.1.STATUS\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Status of the mnemonic: valid mnemonic or valid mnemonic with no data or invalid mnemonic (1:  Valid, 2:  Valid, No data, 3:  Invalid\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.LIMIT-TYPE\"                                    "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Specifies the type of limits defined for this mnemonic (1:  Range Limits, 2:  Delta Limits, 3:  Both\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.DELTA-LIMIT\"                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Delta limit set for Mnemonic 1\"/>                  "
    "<FIELD  NAME=\"MNEMONIC.1.MNEMONIC-SWITCH\"                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Dependent mnemonic used to determine which limit set to use in the case of multiple limit sets.\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.NUM-OF-RANGE-SETS\"                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of range limit sets defined for this mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.RANGE-SET.1.LIMIT-CONDITION\"                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates if the limit set m for mnemonic n contains Inclusive or Exclusive limit ranges.  (1:  Inclusive Limit Set, 2:  Exclusive Limit Set)\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.RANGE-SET.1.RH\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Limit set 1 Red high limit for Mnemonic 1\"/>       "
    "<FIELD  NAME=\"MNEMONIC.1.RANGE-SET.1.RL\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Limit set 1 Red low limit for Mnemonic 1\"/>        "
    "<FIELD  NAME=\"MNEMONIC.1.RANGE-SET.1.YH\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Limit set 1 Yellow high limit for Mnemonic 1\"/>    "
    "<FIELD  NAME=\"MNEMONIC.1.RANGE-SET.1.YL\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Limit set 1 Yellow low limit for Mnemonic 1\"/>     "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.RESP.DB.2\"                                        "
    "ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.ATTRIBUTE-TYPE\">           "
    "<!-- p. 236 GMSEC Interface Spec 2014-02.docx -->                         "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RESP\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"DB\"                                                      "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2006\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Database Attributes Request Message that was processed.  (1:  Acknowledgement, 2:  Working/Keep Alive, 3:  Successful Completion, 4:  Failed Completion, 5:  Invalid Request)\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application completed processing the request\"/>"
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Useful to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"ATTRIBUTE-TYPE\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"2\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the type of Database Attributes for the first mnemonic to be returned.  Value is 2:  Text conversion\"/>"
    "<FIELD  NAME=\"NUM-OF-MNEMONICS\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Total number of mnemonics returned\"/>              "
    "<FIELD  NAME=\"MNEMONIC.1.NAME\"                                          "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the Mnemonic\"/>                            "
    "<FIELD  NAME=\"MNEMONIC.1.STATUS\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Status of the mnemonic: valid mnemonic or valid mnemonic with no data or invalid mnemonic (1:  Valid, 2:  Valid, No data, 3:  Invalid\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.NUM-OF-TEXT-SETS\"                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of Text Conversion sets defined for this mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.TEXT-SET.1.TEXT\"                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Text Conversion Set 1 for Mnemonic 1\"/>            "
    "<FIELD  NAME=\"MNEMONIC.1.TEXT-SET.1.LOW-RANGE\"                          "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Low range for text conversion set 1 for mnemonic 1\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.TEXT-SET.1.HIGH-RANGE\"                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"High range for text conversion set 1 for mnemonic 1\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.RESP.DB.3\"                                        "
    "ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.ATTRIBUTE-TYPE\">           "
    "<!-- p. 237 GMSEC Interface Spec 2014-02.docx -->                         "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RESP\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"DB\"                                                      "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2006\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Database Attributes Request Message that was processed.  (1:  Acknowledgement, 2:  Working/Keep Alive, 3:  Successful Completion, 4:  Failed Completion, 5:  Invalid Request)\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application completed processing the request\"/>"
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Useful to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"ATTRIBUTE-TYPE\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"3\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the type of Database Attributes for the first mnemonic to be returned.  Value is 3:  Calibration Curve\"/>"
    "<FIELD  NAME=\"NUM-OF-MNEMONICS\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Total number of mnemonics returned\"/>              "
    "<FIELD  NAME=\"MNEMONIC.1.NAME\"                                          "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the Mnemonic\"/>                            "
    "<FIELD  NAME=\"MNEMONIC.1.STATUS\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Status of the mnemonic: valid mnemonic or valid mnemonic with no data or invalid mnemonic (1:  Valid, 2:  Valid, No data, 3:  Invalid\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.CAL-TYPE\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the type of Calibration Curve defined for this mnemonic (1:  Polynomial,  2:  Other)\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.CONSTANT\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Constant for Calibration Curve for mnemonic\"/>     "
    "<FIELD  NAME=\"MNEMONIC.1.NUM-OF-COEFFS\"                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Degree of Polynomial for mnemonic\"/>               "
    "<FIELD  NAME=\"MNEMONIC.1.COEFF.1.VALUE\"                                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"1st order Polynomial coefficient for MNEMONIC 1\"/> "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.RESP.DB.4\"                                        "
    "ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.ATTRIBUTE-TYPE\">           "
    "<!-- p. 238 GMSEC Interface Spec 2014-02.docx -->                         "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RESP\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"DB\"                                                      "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2006\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Database Attributes Request Message that was processed.  (1:  Acknowledgement, 2:  Working/Keep Alive, 3:  Successful Completion, 4:  Failed Completion, 5:  Invalid Request)\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application completed processing the request\"/>"
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Useful to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"ATTRIBUTE-TYPE\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"4\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the type of Database Attributes for the first mnemonic to be returned.  Value is 4:  Short Description\"/>"
    "<FIELD  NAME=\"NUM-OF-MNEMONICS\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Total number of mnemonics returned\"/>              "
    "<FIELD  NAME=\"MNEMONIC.1.NAME\"                                          "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the Mnemonic\"/>                            "
    "<FIELD  NAME=\"MNEMONIC.1.STATUS\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Status of the mnemonic: valid mnemonic or valid mnemonic with no data or invalid mnemonic (1:  Valid, 2:  Valid, No data, 3:  Invalid\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SHORT-DESCRIPTION\"                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Short Description for mnemonic 1\"/>                "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.RESP.DB.5\"                                        "
    "ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.ATTRIBUTE-TYPE\">           "
    "<!-- p. 239 GMSEC Interface Spec 2014-02.docx -->                         "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RESP\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"DB\"                                                      "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2006\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Database Attributes Request Message that was processed.  (1:  Acknowledgement, 2:  Working/Keep Alive, 3:  Successful Completion, 4:  Failed Completion, 5:  Invalid Request)\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application completed processing the request\"/>"
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Useful to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"ATTRIBUTE-TYPE\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"5\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the type of Database Attributes for the first mnemonic to be returned.  Value is 5:  Long Description\"/>"
    "<FIELD  NAME=\"NUM-OF-MNEMONICS\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Total number of mnemonics returned\"/>              "
    "<FIELD  NAME=\"MNEMONIC.1.NAME\"                                          "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the Mnemonic\"/>                            "
    "<FIELD  NAME=\"MNEMONIC.1.STATUS\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Status of the mnemonic: valid mnemonic or valid mnemonic with no data or invalid mnemonic (1:  Valid, 2:  Valid, No data, 3:  Invalid\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.LONG-DESCRIPTION\"                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Long Description for mnemonic 1\"/>                 "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.RESP.DB.6\"                                        "
    "ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.ATTRIBUTE-TYPE\">           "
    "<!-- p. 240 GMSEC Interface Spec 2014-02.docx -->                         "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RESP\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"DB\"                                                      "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2006\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique ID used by the requestor or publisher to distinguish the message\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Database Attributes Request Message that was processed.  (1:  Acknowledgement, 2:  Working/Keep Alive, 3:  Successful Completion, 4:  Failed Completion, 5:  Invalid Request)\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application completed processing the request\"/>"
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Used to indicate product URI as requestor or responder. Also can be used to provide function call status or error code in case of failed completion.  (1:  Product file placed in URI specified by requestor, 2:  Product file placed in URI specified by the responder, Other:  Error code of the failed completion\"/>"
    "<FIELD  NAME=\"ATTRIBUTE-TYPE\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"6\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the type of Database Attributes for the first mnemonic to be returned.  Value is 6:  List of All Mnemonics\"/>"
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"TAC\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product type and subtype being requested. (See Table 4-29. Product Categories... Value is TAC:  Telemetry and Command)\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"DB\"                                                      "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"\"/>                                                "
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.  Value is in the range 1+.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc. of the Product Message)\"/>"
    "<FIELD  NAME=\"URI\"                                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the (single) output file product is stored\"/>"
    "<FIELD  NAME=\"NAME-PATTERN\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the name of the output file\"/>           "
    "<FIELD  NAME=\"DESCRIPTION\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"FORMAT\"                                                   "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format\"/>                       "
    "<FIELD  NAME=\"VERSION\"                                                  "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version of the file\"/>              "
    "<FIELD  NAME=\"SIZE\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Actual size of the file\"/>                         "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.RESP.DIR\"                                         "
    "ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE\">                          "
    "<!-- p. 140 GMSEC Interface Spec 2014-02.docx -->                         "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RESP\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"DIR\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"1.0\"                                                     "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the directive request message.\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"6\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Directive being processed\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application completed processing the directive\"/>"
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Useful to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"DATA\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"UNSET\"                                                    "
    "        DESCRIPTION=\"Additional data that may be desired along with the completion status\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.RESP.MVAL\"                                        "
    "ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE\">                          "
    "<!-- p. 192 GMSEC Interface Spec 2014-02.docx -->                         "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RESP\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"MVAL\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2007\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the Mnemonic Value Request message.\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Mnemonic Value Request Message that was processed.  (“2” is not a valid value and has no meaning.  1:  Acknowledgement, 3:  Successful Completion, 4:  Failed Completion, 5:  Invalid Request)\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application completed processing the request\"/>"
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Useful to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"NUM-OF-MNEMONICS\"                                         "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Total number of mnemonics returned.  Should echo the “NUM-OF-MNEMONICS” field in the request message.  Value in the range of 1+.\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.NAME\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the first Mnemonic\"/>                      "
    "<FIELD  NAME=\"MNEMONIC.1.STATUS\"                                        "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Status of the first mnemonic: valid mnemonic or valid mnemonic with no data or invalid mnemonic.  (1:  Valid, 2:  Valid, No data, 3:  Invalid)\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.UNITS\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Units associated with the value converted to engineering units for the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.NUM-OF-SAMPLES\"                                "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of data samples for the first mnemonic.\"/>  "
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.TIME-STAMP\"                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time stamp for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.RAW-VALUE\"                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Raw value for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.EU-VALUE\"                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Raw value converted to Engineering Units if engineering units conversion is present for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.TEXT-VALUE\"                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Raw value converted to a text string if text conversion is present for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.FLAGS\"                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Flags native to the T&C component for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.LIMIT-ENABLE-DISABLE\"                 "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the limit checking state for the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.RED-HIGH\"                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the Red High limit status of the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.RED-LOW\"                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the Red Low limit status of the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.YELLOW-HIGH\"                          "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the Yellow High limit status of the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.YELLOW-LOW\"                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the Yellow Low limit status of the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.STATIC\"                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the static (stale) condition of the first data sample of the first mnemonic\"/>"
    "<FIELD  NAME=\"MNEMONIC.1.SAMPLE.1.QUALITY\"                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BOOLEAN\"                                                  "
    "        DESCRIPTION=\"Indicates the Quality of the first data sample of the first mnemonic\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.RESP.PROD.AAA\"                                    "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.PROD-TYPE\">        "
    "<!-- pp 256-258 of GMSEC Interface Spec 2014-02.docx -->                  "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RESP\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"PROD\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the Product Request message.\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Product Request Message that was processed.\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application completed processing the request\"/>"
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Used to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"AAA\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the PROD-TYPE field from the Product Request message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"DATA\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product type and subtype being requested. (See Table 4-29. Product Categories)\"/>"
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc. of the Product Message)\"/>"
    "<FIELD  NAME=\"PROD-MSGS-TO-SEND\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of Product Msgs that will be published to satisfy the PROD REQ.  A value of “-1” can be used to indicate “Unknown”.\"/>"
    "<FIELD  NAME=\"NUM-OF-FILES\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of files included in this response message.\"/>"
    "<FIELD  NAME=\"FILE.1.URI\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the file of the product is stored\"/>"
    "<FIELD  NAME=\"FILE.1.NAME-PATTERN\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"FILE.1.DESCRIPTION\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"FILE.1.FORMAT\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"FILE.1.VERSION\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"FILE.1.SIZE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"FILE.1.DATA\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.RESP.PROD.AUTO\"                                   "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.PROD-TYPE\">        "
    "<!-- pp 256-258 of GMSEC Interface Spec 2014-02.docx -->                  "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RESP\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"PROD\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the Product Request message.\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Product Request Message that was processed.\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application completed processing the request\"/>"
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Used to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"AUTO\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the PROD-TYPE field from the Product Request message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"DM\"                                                      "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product type and subtype being requested. (See Table 4-29. Product Categories)\"/>"
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc. of the Product Message)\"/>"
    "<FIELD  NAME=\"PROD-MSGS-TO-SEND\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of Product Msgs that will be published to satisfy the PROD REQ.  A value of “-1” can be used to indicate “Unknown”.\"/>"
    "<FIELD  NAME=\"NUM-OF-FILES\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of files included in this response message.\"/>"
    "<FIELD  NAME=\"FILE.1.URI\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the file of the product is stored\"/>"
    "<FIELD  NAME=\"FILE.1.NAME-PATTERN\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"FILE.1.DESCRIPTION\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"FILE.1.FORMAT\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"FILE.1.VERSION\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"FILE.1.SIZE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"FILE.1.DATA\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.RESP.PROD.FD\"                                     "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.PROD-TYPE\">        "
    "<!-- pp 256-258 of GMSEC Interface Spec 2014-02.docx -->                  "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RESP\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"PROD\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the Product Request message.\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Product Request Message that was processed.\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application completed processing the request\"/>"
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Used to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"FD\"                                                      "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the PROD-TYPE field from the Product Request message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"ATT\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product type and subtype being requested. (See Table 4-29. Product Categories)\"/>"
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc. of the Product Message)\"/>"
    "<FIELD  NAME=\"PROD-MSGS-TO-SEND\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of Product Msgs that will be published to satisfy the PROD REQ.  A value of “-1” can be used to indicate “Unknown”.\"/>"
    "<FIELD  NAME=\"NUM-OF-FILES\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of files included in this response message.\"/>"
    "<FIELD  NAME=\"FILE.1.URI\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the file of the product is stored\"/>"
    "<FIELD  NAME=\"FILE.1.NAME-PATTERN\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"FILE.1.DESCRIPTION\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"FILE.1.FORMAT\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"FILE.1.VERSION\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"FILE.1.SIZE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"FILE.1.DATA\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.RESP.PROD.MAS\"                                    "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.PROD-TYPE\">        "
    "<!-- pp 256-258 of GMSEC Interface Spec 2014-02.docx -->                  "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RESP\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"PROD\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the Product Request message.\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Product Request Message that was processed.\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application completed processing the request\"/>"
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Used to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"MAS\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the PROD-TYPE field from the Product Request message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"DATA\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product type and subtype being requested. (See Table 4-29. Product Categories)\"/>"
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc. of the Product Message)\"/>"
    "<FIELD  NAME=\"PROD-MSGS-TO-SEND\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of Product Msgs that will be published to satisfy the PROD REQ.  A value of “-1” can be used to indicate “Unknown”.\"/>"
    "<FIELD  NAME=\"NUM-OF-FILES\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of files included in this response message.\"/>"
    "<FIELD  NAME=\"FILE.1.URI\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the file of the product is stored\"/>"
    "<FIELD  NAME=\"FILE.1.NAME-PATTERN\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"FILE.1.DESCRIPTION\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"FILE.1.FORMAT\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"FILE.1.VERSION\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"FILE.1.SIZE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"FILE.1.DATA\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.RESP.PROD.PAS\"                                    "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.PROD-TYPE\">        "
    "<!-- pp 256-258 of GMSEC Interface Spec 2014-02.docx -->                  "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RESP\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"PROD\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the Product Request message.\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Product Request Message that was processed.\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application completed processing the request\"/>"
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Used to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"PAS\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the PROD-TYPE field from the Product Request message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"SCH\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product type and subtype being requested. (See Table 4-29. Product Categories)\"/>"
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc. of the Product Message)\"/>"
    "<FIELD  NAME=\"PROD-MSGS-TO-SEND\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of Product Msgs that will be published to satisfy the PROD REQ.  A value of “-1” can be used to indicate “Unknown”.\"/>"
    "<FIELD  NAME=\"NUM-OF-FILES\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of files included in this response message.\"/>"
    "<FIELD  NAME=\"FILE.1.URI\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the file of the product is stored\"/>"
    "<FIELD  NAME=\"FILE.1.NAME-PATTERN\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"FILE.1.DESCRIPTION\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"FILE.1.FORMAT\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"FILE.1.VERSION\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"FILE.1.SIZE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"FILE.1.DATA\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.RESP.PROD.SC\"                                     "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.PROD-TYPE\">        "
    "<!-- pp 256-258 of GMSEC Interface Spec 2014-02.docx -->                  "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RESP\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"PROD\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the Product Request message.\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Product Request Message that was processed.\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application completed processing the request\"/>"
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Used to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"SC\"                                                      "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the PROD-TYPE field from the Product Request message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product type and subtype being requested. (See Table 4-29. Product Categories)\"/>"
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc. of the Product Message)\"/>"
    "<FIELD  NAME=\"PROD-MSGS-TO-SEND\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of Product Msgs that will be published to satisfy the PROD REQ.  A value of “-1” can be used to indicate “Unknown”.\"/>"
    "<FIELD  NAME=\"NUM-OF-FILES\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of files included in this response message.\"/>"
    "<FIELD  NAME=\"FILE.1.URI\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the file of the product is stored\"/>"
    "<FIELD  NAME=\"FILE.1.NAME-PATTERN\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"FILE.1.DESCRIPTION\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"FILE.1.FORMAT\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"FILE.1.VERSION\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"FILE.1.SIZE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"FILE.1.DATA\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.RESP.PROD.TAC\"                                    "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE.PROD-TYPE\">        "
    "<!-- pp 256-258 of GMSEC Interface Spec 2014-02.docx -->                  "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RESP\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"PROD\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2013\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the Product Request message.\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"1\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Product Request Message that was processed.\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application completed processing the request\"/>"
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Used to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"PROD-NAME\"                                                "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Name of the product\"/>                             "
    "<FIELD  NAME=\"PROD-DESCRIPTION\"                                         "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the product in text or xml\"/>       "
    "<FIELD  NAME=\"PROD-TYPE\"                                                "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"TAC\"                                                     "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the PROD-TYPE field from the Product Request message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"DATA\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Product type and subtype being requested. (See Table 4-29. Product Categories)\"/>"
    "<FIELD  NAME=\"NUM-OF-PROD-SUBTYPES\"                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Number of further delineations / categories beyond the product subtype.  Also, used as msg subject elements ME5, ME6, etc. in Product Message.\"/>"
    "<FIELD  NAME=\"PROD-SUBTYPE.1.NAME\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"First subcategory of the product subtype.  (Subject elements ME5, ME6, etc. of the Product Message)\"/>"
    "<FIELD  NAME=\"PROD-MSGS-TO-SEND\"                                        "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of Product Msgs that will be published to satisfy the PROD REQ.  A value of “-1” can be used to indicate “Unknown”.\"/>"
    "<FIELD  NAME=\"NUM-OF-FILES\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"0\"                                                       "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Indicates the number of files included in this response message.\"/>"
    "<FIELD  NAME=\"FILE.1.URI\"                                               "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"URI specifying the location where the file of the product is stored\"/>"
    "<FIELD  NAME=\"FILE.1.NAME-PATTERN\"                                      "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file name\"/>                         "
    "<FIELD  NAME=\"FILE.1.DESCRIPTION\"                                       "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Description of the file in text or xml\"/>          "
    "<FIELD  NAME=\"FILE.1.FORMAT\"                                            "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Describes the file format.\"/>                      "
    "<FIELD  NAME=\"FILE.1.VERSION\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Identifies the version ID of the file\"/>           "
    "<FIELD  NAME=\"FILE.1.SIZE\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Size of the included file\"/>                       "
    "<FIELD  NAME=\"FILE.1.DATA\"                                              "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"BLOB\"                                                     "
    "        DESCRIPTION=\"The file content\"/>                                "
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.RESP.RTLM\"                                        "
    "ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE\">                          "
    "<!-- p. 179 GMSEC Interface Spec 2014-02.docx -->                         "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2010\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message description.\"/>    "
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RESP\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RTLM\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"1.0\"                                                     "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the Replay Telemetry Request message.\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the request being processed.  (1:  Acknowledgement, 2:  Working/Keep Alive, 3:  Successful completion, 4:  Failed completion, 5:  Invalid Request, 6:  Final Message)\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application completed processing the request\"/>"
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Useful to provide function call status or error code in the case of failed completion\"/>"
    "<FIELD  NAME=\"DATA\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"UNSET\"                                                    "
    "        DESCRIPTION=\"Additional data that may be desired along with the completion status.  Type is dependent upon response.\"/>"
    "</SCHEMA>                                                                 "
,

    "<SCHEMA NAME=\"2014.00.RESP.SERV\"                                        "
    "        ID_FIELD_NAMES=\"MESSAGE-TYPE.MESSAGE-SUBTYPE\">                  "
    "<!-- pp 274 of GMSEC Interface Spec 2014-02.docx -->                      "
    "<FIELD  NAME=\"HEADER-VERSION\"                                           "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "                VALUE=\"2010\"                                            "
    "                TYPE=\"F32\"                                              "
    "                DESCRIPTION=\"Version Number for this message description.\"/>"
    "<FIELD  NAME=\"MESSAGE-TYPE\"                                             "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"RESP\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Message type identifier: REQ, RESP, or MSG\"/>      "
    "<FIELD  NAME=\"MESSAGE-SUBTYPE\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"SERV\"                                                    "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Unique message identifier, fixed for GMSEC Standard Messages\"/>"
    "<FIELD  NAME=\"CONTENT-VERSION\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"2012\"                                                    "
    "        TYPE=\"F32\"                                                      "
    "        DESCRIPTION=\"Version Number for this message content description\"/>"
    "<FIELD  NAME=\"MSG-ID\"                                                   "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"HEADER\"                                            "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Echo of the MSG-ID field from the Simple Service Request message.\"/>"
    "<FIELD  NAME=\"RESPONSE-STATUS\"                                          "
    "        MODE=\"REQUIRED\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I16\"                                                      "
    "        DESCRIPTION=\"Identifies the status of the Simple Service being processed.  (1:  Acknowledgement, 2:  Working/keep alive, 3:  Successful completino, 4:  Failed completion, 5:  Invalid Request, 6:  Final Message)\"/>"
    "<FIELD  NAME=\"TIME-COMPLETED\"                                           "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"STRING\"                                                   "
    "        DESCRIPTION=\"Time application completed processing the Simple Service\"/>"
    "<FIELD  NAME=\"RETURN-VALUE\"                                             "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"I32\"                                                      "
    "        DESCRIPTION=\"Return value or status based on the RESPONSE-STATUS.  Provides additional status information  particular to the request.\"/>"
    "<FIELD  NAME=\"DATA\"                                                     "
    "        MODE=\"OPTIONAL\"                                                 "
    "        FIELD_CLASS=\"STANDARD\"                                          "
    "        VALUE=\"\"                                                        "
    "        TYPE=\"UNSET\"                                                    "
    "        DESCRIPTION=\"Additional data that may accompany the response\"/> "
    "</SCHEMA>                                                                 "
,

    ""

};

#endif
