/*
 * Copyright 2007-2016 United States Government as represented by the
 * Administrator of The National Aeronautics and Space Administration.
 * No copyright is claimed in the United States under Title 17, U.S. Code.
 * All Rights Reserved.
 */


/**
 * @file fields.h
 *
 * @brief This file contains include statements for the various field types.
 */

#ifndef GMSEC_API_C_FIELDS_H
#define GMSEC_API_C_FIELDS_H

#include <gmsec4_defs.h>

#include <gmsec4/c/field/field.h>

#include <gmsec4/c/field/binary_field.h>
#include <gmsec4/c/field/boolean_field.h>
#include <gmsec4/c/field/char_field.h>
#include <gmsec4/c/field/i16_field.h>
#include <gmsec4/c/field/i32_field.h>
#include <gmsec4/c/field/i64_field.h>
#include <gmsec4/c/field/i8_field.h>
#include <gmsec4/c/field/f32_field.h>
#include <gmsec4/c/field/f64_field.h>
#include <gmsec4/c/field/string_field.h>
#include <gmsec4/c/field/u16_field.h>
#include <gmsec4/c/field/u32_field.h>
#include <gmsec4/c/field/u64_field.h>
#include <gmsec4/c/field/u8_field.h>

#endif
