/*
 * Decompiled with CFR 0.152.
 */
package bolt;

import bolt.Client;
import bolt.IOManager;
import bolt.Log;
import bolt.Options;
import bolt.RealDistributor;
import bolt.RealProcessor;
import bolt.Statistics;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class Server {
    private Options options = new Options();
    private List<IOManager> ioManagers = new ArrayList<IOManager>(10);
    private RealDistributor distributor;
    private RealProcessor processor;
    private Statistics statistics = new Statistics();
    static final Logger source = Log.createSource("Server");
    final int BOLT_PRIORITY = 7;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        ServerSocketChannel serverSocketChannel = null;
        try {
            try {
                serverSocketChannel = ServerSocketChannel.open();
                this.distributor = new RealDistributor();
                this.processor = new RealProcessor();
                this.processor.setPriority(7);
                this.processor.setDistributor(this.distributor);
                this.processor.start();
                byte[] byArray = new byte[]{0, 0, 0, 0};
                InetSocketAddress inetSocketAddress = new InetSocketAddress(InetAddress.getByAddress(byArray), this.options.port);
                serverSocketChannel.socket().bind(inetSocketAddress, this.options.backlogSize);
                Log.info(source, "Bolt v4.2 [03/03/2017]");
                Log.info(source, "waiting for connections on " + inetSocketAddress);
                while (true) {
                    this.assign(serverSocketChannel.accept());
                }
            }
            catch (IOException iOException) {
                Log.exception(source, iOException);
                if (serverSocketChannel != null) {
                    try {
                        serverSocketChannel.close();
                    }
                    catch (IOException iOException2) {
                        Log.exception(source, iOException2);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (serverSocketChannel != null) {
                try {
                    serverSocketChannel.close();
                }
                catch (IOException iOException) {
                    Log.exception(source, iOException);
                }
            }
            throw throwable;
        }
    }

    private void assign(SocketChannel socketChannel) {
        try {
            socketChannel.configureBlocking(false);
        }
        catch (IOException iOException) {
            Log.exception(source, iOException, true);
        }
        IOManager iOManager = null;
        for (IOManager object2 : this.ioManagers) {
            if (!object2.isAvailable()) continue;
            iOManager = object2;
        }
        if (iOManager == null) {
            Log.info(source, "creating IOManager");
            iOManager = new IOManager();
            this.ioManagers.add(iOManager);
            iOManager.setOptions(this.options);
            iOManager.start();
        }
        Client.Shared shared = new Client.Shared();
        shared.manager = iOManager;
        shared.distributor = this.distributor;
        shared.processor = this.processor;
        shared.statistics = this.statistics;
        Client client = new Client(shared, socketChannel);
        this.options.initialize(client.getOptions());
        iOManager.assign(client);
    }

    public static void main(String[] stringArray) {
        Options options = new Options();
        if (options.parse(stringArray)) {
            Server server = new Server();
            server.options = options;
            server.execute();
        }
    }
}

