/*
 * Decompiled with CFR 0.152.
 */
package bolt;

import bolt.DoubleProperty;
import bolt.FlagProperty;
import bolt.IntegerProperty;
import bolt.Log;
import bolt.Property;
import bolt.PropertyType;
import bolt.StringProperty;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Meta {
    private static Map<PropertyType, Parser> parsers = new HashMap<PropertyType, Parser>();
    private String id;
    private String topic;
    private String corrID;
    private String replyTo;
    private String selector;
    private boolean compress;
    private Map<String, Property> properties = new HashMap<String, Property>();
    private int encodedSize = 0;
    private static Logger source;
    static final int MAX_ITEMS = 10000;

    boolean parse(ByteBuffer byteBuffer) {
        boolean bl = false;
        try {
            bl = this.parseAux(byteBuffer);
        }
        catch (Exception exception) {
            Log.error(source, "parseAux: " + exception);
        }
        return bl;
    }

    boolean parseAux(ByteBuffer byteBuffer) {
        assert (byteBuffer.array().length >= 6);
        int n = byteBuffer.getInt();
        if (n < 0) {
            Log.error(source, "invalid meta size " + n);
            return false;
        }
        int n2 = byteBuffer.getShort();
        if (n2 < 0 || n2 > 10000) {
            Log.error(source, "invalid meta item count " + n2);
            return false;
        }
        if (source.isLoggable(Level.FINER)) {
            Log.info(source, "parseAux: size=" + n + " count=" + n2);
        }
        for (int i = 0; i < n2; ++i) {
            byte by = byteBuffer.get();
            int n3 = by >> 6;
            int n4 = by & 0x3F;
            PropertyType propertyType = PropertyType.find(n4);
            int n5 = -1;
            if (n3 == Property.Mode.SMALL.value()) {
                n5 = byteBuffer.get();
                if (n5 < 0) {
                    n5 += 256;
                }
            } else if (n3 == Property.Mode.MEDIUM.value()) {
                n5 = byteBuffer.getShort();
                if (n5 < 0) {
                    n5 += 65536;
                }
            } else if (n3 == Property.Mode.LARGE.value()) {
                int n6;
                int n7 = byteBuffer.get();
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n6 = byteBuffer.getShort()) < 0) {
                    n6 += 65536;
                }
                n5 = n7 * 256 * 256 + n6;
            }
            byte[] byArray = new byte[n5];
            byteBuffer.get(byArray);
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
            Property property = null;
            Parser parser = this.getParser(propertyType);
            if (parser != null) {
                property = parser.parse(this, byteBuffer2);
            } else {
                Log.error(source, "invalid property type " + n4);
            }
            if (property == null) continue;
            property.setType(propertyType);
            this.properties.put(property.getName(), property);
        }
        return true;
    }

    private Parser getParser(PropertyType propertyType) {
        Parser parser = null;
        if (propertyType != null && (parser = parsers.get((Object)propertyType)) == null) {
            Log.error(source, "getParser: unregistered type " + (Object)((Object)propertyType));
        }
        return parser;
    }

    private static String getPropertyName(ByteBuffer byteBuffer) {
        int n = byteBuffer.get();
        if (n < 0) {
            n += 256;
        }
        String string = null;
        if (n > 0) {
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            string = new String(byArray);
        }
        return string;
    }

    private static String getPropertyString(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return new String(byArray);
    }

    public String getTopic() {
        return this.topic;
    }

    public String getID() {
        return this.id;
    }

    public boolean getCompress() {
        return this.compress;
    }

    public Collection<Property> getProperties() {
        return this.properties.values();
    }

    public Property getProperty(String string) {
        return this.properties.get(string);
    }

    public void dump(String string, PrintStream printStream) {
        printStream.println(string + " count=" + this.properties.size());
        for (Property property : this.getProperties()) {
            printStream.println(property.toString());
        }
    }

    public void addProperty(Property property) {
        this.properties.put(property.getName(), property);
    }

    void put(ByteBuffer byteBuffer) {
        assert (this.encodedSize > 0);
        assert (byteBuffer.remaining() >= this.encodedSize);
        assert (this.properties.size() <= 10000);
        byteBuffer.putInt(this.encodedSize);
        byteBuffer.putShort((short)this.properties.size());
        Property.Encoding encoding = new Property.Encoding();
        for (Property property : this.properties.values()) {
            PropertyType propertyType = property.getType();
            property.getEncoding(encoding);
            int n = encoding.mode.value() << 6 | propertyType.identifier();
            byteBuffer.put((byte)n);
            this.putEncLength(byteBuffer, encoding.mode, encoding.count);
            if (propertyType.isNamed()) {
                byteBuffer.put((byte)property.getName().length());
                byteBuffer.put(property.getName().getBytes());
            } else {
                byteBuffer.put((byte)0);
            }
            if (!propertyType.isNamed()) {
                byteBuffer.put(property.asString().getBytes());
                continue;
            }
            if (propertyType == PropertyType.STRING) {
                byteBuffer.put(property.asString().getBytes());
                continue;
            }
            if (propertyType == PropertyType.I32) {
                byteBuffer.putInt(property.asInteger());
                continue;
            }
            if (propertyType == PropertyType.F64) {
                byteBuffer.putDouble(property.asDouble());
                continue;
            }
            Log.error(source, "bug: put does not handle " + (Object)((Object)propertyType));
        }
    }

    private void putEncLength(ByteBuffer byteBuffer, Property.Mode mode, int n) {
        if (mode == Property.Mode.SMALL) {
            byteBuffer.put((byte)n);
        } else if (mode == Property.Mode.MEDIUM) {
            byteBuffer.putShort((short)n);
        } else if (mode == Property.Mode.LARGE) {
            int n2 = n >> 16;
            byteBuffer.put((byte)n2);
            byteBuffer.putShort((short)(n & 0xFFFF));
        }
    }

    int determineSize() {
        int n = 0;
        n += 4;
        n += 2;
        Property.Encoding encoding = new Property.Encoding();
        for (Property property : this.properties.values()) {
            property.getEncoding(encoding);
            n += encoding.prefix;
            n += encoding.count;
        }
        this.encodedSize = n;
        return n;
    }

    static {
        parsers.put(PropertyType.STRING, new Parser(){

            @Override
            public Property parse(Meta meta, ByteBuffer byteBuffer) {
                String string = Meta.getPropertyName(byteBuffer);
                String string2 = Meta.getPropertyString(byteBuffer);
                return new StringProperty(string, string2);
            }
        });
        parsers.put(PropertyType.I32, new Parser(){

            @Override
            public Property parse(Meta meta, ByteBuffer byteBuffer) {
                String string = Meta.getPropertyName(byteBuffer);
                int n = byteBuffer.getInt();
                return new IntegerProperty(string, n);
            }
        });
        parsers.put(PropertyType.F64, new Parser(){

            @Override
            public Property parse(Meta meta, ByteBuffer byteBuffer) {
                String string = Meta.getPropertyName(byteBuffer);
                double d = byteBuffer.getDouble();
                return new DoubleProperty(string, d);
            }
        });
        parsers.put(PropertyType.FLAG, new Parser(){

            @Override
            public Property parse(Meta meta, ByteBuffer byteBuffer) {
                String string = Meta.getPropertyName(byteBuffer);
                boolean bl = byteBuffer.get() != 0;
                return new FlagProperty(string, bl);
            }
        });
        parsers.put(PropertyType.ID, new Parser(){

            @Override
            public Property parse(Meta meta, ByteBuffer byteBuffer) {
                byteBuffer.get();
                String string = Meta.getPropertyString(byteBuffer);
                meta.id = string;
                return Property.createID(string);
            }
        });
        parsers.put(PropertyType.TOPIC, new Parser(){

            @Override
            public Property parse(Meta meta, ByteBuffer byteBuffer) {
                byteBuffer.get();
                String string = Meta.getPropertyString(byteBuffer);
                meta.topic = string;
                return Property.createTopic(string);
            }
        });
        parsers.put(PropertyType.CORR_ID, new Parser(){

            @Override
            public Property parse(Meta meta, ByteBuffer byteBuffer) {
                byteBuffer.get();
                String string = Meta.getPropertyString(byteBuffer);
                meta.corrID = string;
                return Property.createCorrID(string);
            }
        });
        parsers.put(PropertyType.REPLY_TO, new Parser(){

            @Override
            public Property parse(Meta meta, ByteBuffer byteBuffer) {
                byteBuffer.get();
                String string = Meta.getPropertyString(byteBuffer);
                meta.replyTo = string;
                return Property.createReplyTo(string);
            }
        });
        parsers.put(PropertyType.COMPRESS, new Parser(){

            @Override
            public Property parse(Meta meta, ByteBuffer byteBuffer) {
                byteBuffer.get();
                meta.compress = byteBuffer.get() != 0;
                return Property.createCompress(meta.compress);
            }
        });
        source = Log.createSource("Meta");
    }

    static interface Parser {
        public Property parse(Meta var1, ByteBuffer var2);
    }
}

