/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsecapi.jni;

import gov.nasa.gsfc.gmsecapi.Field;
import gov.nasa.gsfc.gmsecapi.GMSEC_Bin;
import gov.nasa.gsfc.gmsecapi.GMSEC_Bool;
import gov.nasa.gsfc.gmsecapi.GMSEC_Char;
import gov.nasa.gsfc.gmsecapi.GMSEC_Double;
import gov.nasa.gsfc.gmsecapi.GMSEC_F32;
import gov.nasa.gsfc.gmsecapi.GMSEC_F64;
import gov.nasa.gsfc.gmsecapi.GMSEC_Float;
import gov.nasa.gsfc.gmsecapi.GMSEC_I16;
import gov.nasa.gsfc.gmsecapi.GMSEC_I32;
import gov.nasa.gsfc.gmsecapi.GMSEC_I64;
import gov.nasa.gsfc.gmsecapi.GMSEC_I8;
import gov.nasa.gsfc.gmsecapi.GMSEC_Long;
import gov.nasa.gsfc.gmsecapi.GMSEC_Short;
import gov.nasa.gsfc.gmsecapi.GMSEC_String;
import gov.nasa.gsfc.gmsecapi.GMSEC_U16;
import gov.nasa.gsfc.gmsecapi.GMSEC_U32;
import gov.nasa.gsfc.gmsecapi.GMSEC_U8;
import gov.nasa.gsfc.gmsecapi.GMSEC_ULong;
import gov.nasa.gsfc.gmsecapi.GMSEC_UShort;
import gov.nasa.gsfc.gmsecapi.Status;
import gov.nasa.gsfc.gmsecapi.jni.JNIStatus;
import gov.nasa.gsfc.gmsecapi.jni.gmsecJNI;
import java.lang.reflect.Array;

public class JNIField
extends Field {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected JNIField(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            gmsecJNI.delete_Field(this.swigCPtr, this);
            this.swigCMemOwn = false;
        }
        this.swigCPtr = 0L;
    }

    protected static long getCPtr(JNIField jNIField) {
        return jNIField == null ? 0L : jNIField.swigCPtr;
    }

    public JNIField() {
        this(gmsecJNI.new_Field(), true);
    }

    public JNIField(Field field) {
        this(gmsecJNI.new_Field(), true);
        super.Set(field);
    }

    @Override
    public Status SetFieldValueCHAR(String string, byte by) {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        long l = gmsecJNI.Field_SetFieldValueCHAR(this.swigCPtr, this, string, by);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetFieldValueBOOL(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        long l = gmsecJNI.Field_SetFieldValueBOOL(this.swigCPtr, this, string, bl);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetFieldValueBYTE(String string, byte by) {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        long l = gmsecJNI.Field_SetFieldValueI8(this.swigCPtr, this, string, by);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetFieldValueUBYTE(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        long l = gmsecJNI.Field_SetFieldValueU8(this.swigCPtr, this, string, n);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetFieldValueSHORT(String string, short s) {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        long l = gmsecJNI.Field_SetFieldValueI16(this.swigCPtr, this, string, s);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetFieldValueUSHORT(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        long l = gmsecJNI.Field_SetFieldValueU16(this.swigCPtr, this, string, n);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetFieldValueLONG(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        long l = gmsecJNI.Field_SetFieldValueI32(this.swigCPtr, this, string, n);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetFieldValueULONG(String string, long l) {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        long l2 = gmsecJNI.Field_SetFieldValueU32(this.swigCPtr, this, string, l);
        return new JNIStatus(l2, true);
    }

    @Override
    public Status SetFieldValueFLOAT(String string, float f) {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        long l = gmsecJNI.Field_SetFieldValueF32(this.swigCPtr, this, string, f);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetFieldValueDOUBLE(String string, double d) {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        long l = gmsecJNI.Field_SetFieldValueF64(this.swigCPtr, this, string, d);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetFieldValueI8(String string, byte by) {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        long l = gmsecJNI.Field_SetFieldValueI8(this.swigCPtr, this, string, by);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetFieldValueU8(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        long l = gmsecJNI.Field_SetFieldValueU8(this.swigCPtr, this, string, n);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetFieldValueI16(String string, short s) {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        long l = gmsecJNI.Field_SetFieldValueI16(this.swigCPtr, this, string, s);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetFieldValueU16(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        long l = gmsecJNI.Field_SetFieldValueU16(this.swigCPtr, this, string, n);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetFieldValueI32(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        long l = gmsecJNI.Field_SetFieldValueI32(this.swigCPtr, this, string, n);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetFieldValueU32(String string, long l) {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        long l2 = gmsecJNI.Field_SetFieldValueU32(this.swigCPtr, this, string, l);
        return new JNIStatus(l2, true);
    }

    @Override
    public Status SetFieldValueI64(String string, long l) {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        long l2 = gmsecJNI.Field_SetFieldValueI64(this.swigCPtr, this, string, l);
        return new JNIStatus(l2, true);
    }

    @Override
    public Status SetFieldValueF32(String string, float f) {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        long l = gmsecJNI.Field_SetFieldValueF32(this.swigCPtr, this, string, f);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetFieldValueF64(String string, double d) {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        long l = gmsecJNI.Field_SetFieldValueF64(this.swigCPtr, this, string, d);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetFieldValueSTRING(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Null value");
        }
        long l = gmsecJNI.Field_SetFieldValueSTRING(this.swigCPtr, this, string, string2);
        return new JNIStatus(l, true);
    }

    public Status SetFieldValueBIN(String string, byte[] byArray, long l) {
        if (string == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Null value");
        }
        long l2 = gmsecJNI.Field_SetFieldValueBIN(this.swigCPtr, this, string, byArray, l);
        return new JNIStatus(l2, true);
    }

    public JNIField(JNIField jNIField) {
        this(gmsecJNI.new_Field_Copy(JNIField.getCPtr(jNIField), jNIField), true);
    }

    @Override
    public Status GetName(GMSEC_String gMSEC_String) {
        long l = gmsecJNI.Field_GetName(this.swigCPtr, this, gMSEC_String);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetName(String string) {
        long l = gmsecJNI.Field_SetName(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetType(int n) {
        long l = gmsecJNI.Field_SetType(this.swigCPtr, this, n);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetType(GMSEC_UShort gMSEC_UShort) {
        long l = gmsecJNI.Field_GetType(this.swigCPtr, this, gMSEC_UShort);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetValueCHAR(GMSEC_Char gMSEC_Char) {
        long l = gmsecJNI.Field_GetValueCHAR(this.swigCPtr, this, gMSEC_Char);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetValueBOOL(GMSEC_Bool gMSEC_Bool) {
        long l = gmsecJNI.Field_GetValueBOOL(this.swigCPtr, this, gMSEC_Bool);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetValueBYTE(GMSEC_I8 gMSEC_I8) {
        long l = gmsecJNI.Field_GetValueI8(this.swigCPtr, this, gMSEC_I8);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetValueUBYTE(GMSEC_U8 gMSEC_U8) {
        long l = gmsecJNI.Field_GetValueU8(this.swigCPtr, this, gMSEC_U8);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetValueSHORT(GMSEC_Short gMSEC_Short) {
        long l = gmsecJNI.Field_GetValueI16(this.swigCPtr, this, gMSEC_Short);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetValueUSHORT(GMSEC_UShort gMSEC_UShort) {
        long l = gmsecJNI.Field_GetValueU16(this.swigCPtr, this, gMSEC_UShort);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetValueLONG(GMSEC_Long gMSEC_Long) {
        long l = gmsecJNI.Field_GetValueI32(this.swigCPtr, this, gMSEC_Long);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetValueULONG(GMSEC_ULong gMSEC_ULong) {
        long l = gmsecJNI.Field_GetValueU32(this.swigCPtr, this, gMSEC_ULong);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetValueFLOAT(GMSEC_Float gMSEC_Float) {
        long l = gmsecJNI.Field_GetValueF32(this.swigCPtr, this, gMSEC_Float);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetValueDOUBLE(GMSEC_Double gMSEC_Double) {
        long l = gmsecJNI.Field_GetValueF64(this.swigCPtr, this, gMSEC_Double);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetValueI8(GMSEC_I8 gMSEC_I8) {
        long l = gmsecJNI.Field_GetValueI8(this.swigCPtr, this, gMSEC_I8);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetValueU8(GMSEC_U8 gMSEC_U8) {
        long l = gmsecJNI.Field_GetValueU8(this.swigCPtr, this, gMSEC_U8);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetValueI16(GMSEC_I16 gMSEC_I16) {
        long l = gmsecJNI.Field_GetValueI16(this.swigCPtr, this, gMSEC_I16);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetValueU16(GMSEC_U16 gMSEC_U16) {
        long l = gmsecJNI.Field_GetValueU16(this.swigCPtr, this, gMSEC_U16);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetValueI32(GMSEC_I32 gMSEC_I32) {
        long l = gmsecJNI.Field_GetValueI32(this.swigCPtr, this, gMSEC_I32);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetValueU32(GMSEC_U32 gMSEC_U32) {
        long l = gmsecJNI.Field_GetValueU32(this.swigCPtr, this, gMSEC_U32);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetValueI64(GMSEC_I64 gMSEC_I64) {
        long l = gmsecJNI.Field_GetValueI64(this.swigCPtr, this, gMSEC_I64);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetValueF32(GMSEC_F32 gMSEC_F32) {
        long l = gmsecJNI.Field_GetValueF32(this.swigCPtr, this, gMSEC_F32);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetValueF64(GMSEC_F64 gMSEC_F64) {
        long l = gmsecJNI.Field_GetValueF64(this.swigCPtr, this, gMSEC_F64);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetValueSTRING(GMSEC_String gMSEC_String) {
        long l = gmsecJNI.Field_GetValueSTRING(this.swigCPtr, this, gMSEC_String);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetValueBIN(GMSEC_Bin gMSEC_Bin) {
        GMSEC_ULong gMSEC_ULong = new GMSEC_ULong();
        long l = gmsecJNI.Field_GetValueBIN(this.swigCPtr, this, gMSEC_Bin, gMSEC_ULong);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetValueCHAR(byte by) {
        long l = gmsecJNI.Field_SetValueCHAR(this.swigCPtr, this, by);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetValueBOOL(boolean bl) {
        long l = gmsecJNI.Field_SetValueBOOL(this.swigCPtr, this, bl);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetValueBYTE(byte by) {
        long l = gmsecJNI.Field_SetValueI8(this.swigCPtr, this, by);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetValueUBYTE(int n) {
        long l = gmsecJNI.Field_SetValueU8(this.swigCPtr, this, n);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetValueSHORT(short s) {
        long l = gmsecJNI.Field_SetValueI16(this.swigCPtr, this, s);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetValueUSHORT(int n) {
        long l = gmsecJNI.Field_SetValueU16(this.swigCPtr, this, n);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetValueLONG(int n) {
        long l = gmsecJNI.Field_SetValueI32(this.swigCPtr, this, n);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetValueULONG(long l) {
        long l2 = gmsecJNI.Field_SetValueU32(this.swigCPtr, this, l);
        return new JNIStatus(l2, true);
    }

    @Override
    public Status SetValueFLOAT(float f) {
        long l = gmsecJNI.Field_SetValueF32(this.swigCPtr, this, f);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetValueDOUBLE(double d) {
        long l = gmsecJNI.Field_SetValueF64(this.swigCPtr, this, d);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetValueSTRING(String string) {
        long l = gmsecJNI.Field_SetValueSTRING(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetValueBIN(byte[] byArray) {
        long l = gmsecJNI.Field_SetValueBIN(this.swigCPtr, this, byArray, Array.getLength(byArray));
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetValueI8(byte by) {
        long l = gmsecJNI.Field_SetValueI8(this.swigCPtr, this, by);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetValueU8(int n) {
        long l = gmsecJNI.Field_SetValueU8(this.swigCPtr, this, n);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetValueI16(short s) {
        long l = gmsecJNI.Field_SetValueI16(this.swigCPtr, this, s);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetValueU16(int n) {
        long l = gmsecJNI.Field_SetValueU16(this.swigCPtr, this, n);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetValueI32(int n) {
        long l = gmsecJNI.Field_SetValueI32(this.swigCPtr, this, n);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetValueU32(long l) {
        long l2 = gmsecJNI.Field_SetValueU32(this.swigCPtr, this, l);
        return new JNIStatus(l2, true);
    }

    @Override
    public Status SetValueI64(long l) {
        long l2 = gmsecJNI.Field_SetValueI64(this.swigCPtr, this, l);
        return new JNIStatus(l2, true);
    }

    @Override
    public Status SetValueF32(float f) {
        long l = gmsecJNI.Field_SetValueF32(this.swigCPtr, this, f);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetValueF64(double d) {
        long l = gmsecJNI.Field_SetValueF64(this.swigCPtr, this, d);
        return new JNIStatus(l, true);
    }

    @Override
    public Status UnSet() {
        long l = gmsecJNI.Field_UnSet(this.swigCPtr, this);
        return new JNIStatus(l, true);
    }
}

