/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsecapi;

import gov.nasa.gsfc.gmsecapi.Config;
import gov.nasa.gsfc.gmsecapi.Field;
import gov.nasa.gsfc.gmsecapi.GMSEC_Long;
import gov.nasa.gsfc.gmsecapi.GMSEC_String;
import gov.nasa.gsfc.gmsecapi.GMSEC_ULong;
import gov.nasa.gsfc.gmsecapi.GMSEC_UShort;
import gov.nasa.gsfc.gmsecapi.Status;
import gov.nasa.gsfc.gmsecapi.internal.MessageImpl;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Message
implements MessageImpl {
    private MessageImpl fMsg = null;

    public Message() {
    }

    public Message(MessageImpl messageImpl) {
        this.fMsg = messageImpl;
    }

    public void SetImpl(MessageImpl messageImpl) {
        this.fMsg = messageImpl;
    }

    public MessageImpl GetImpl() {
        return this.fMsg;
    }

    @Override
    public boolean isValid() {
        return this.IsValid();
    }

    public boolean IsValid() {
        return this.fMsg != null && this.fMsg.isValid();
    }

    @Override
    public Status SetKind(int n) {
        if (this.fMsg == null) {
            return this.uninitialized();
        }
        return this.fMsg.SetKind(n);
    }

    @Override
    public Status GetKind(GMSEC_UShort gMSEC_UShort) {
        if (this.fMsg == null) {
            return this.uninitialized();
        }
        if (gMSEC_UShort == null) {
            return new Status(5, 35L, "Kind is NULL");
        }
        return this.fMsg.GetKind(gMSEC_UShort);
    }

    @Override
    public Status SetSubject(String string) {
        if (this.fMsg == null) {
            return this.uninitialized();
        }
        return this.fMsg.SetSubject(string);
    }

    @Override
    public Status GetSubject(GMSEC_String gMSEC_String) {
        if (this.fMsg == null) {
            return this.uninitialized();
        }
        if (gMSEC_String == null) {
            return new Status(5, 35L, "Subject is NULL");
        }
        return this.fMsg.GetSubject(gMSEC_String);
    }

    @Override
    public Status AddField(Field field) {
        if (this.fMsg == null) {
            return this.uninitialized();
        }
        if (field == null) {
            return new Status(5, 35L, "Field is NULL");
        }
        return this.fMsg.AddField(field);
    }

    @Override
    public Status GetField(String string, Field field) {
        if (this.fMsg == null) {
            return this.uninitialized();
        }
        if (field == null) {
            return new Status(5, 35L, "Field is NULL");
        }
        return this.fMsg.GetField(string, field);
    }

    @Override
    public Status GetFieldCount(GMSEC_Long gMSEC_Long) {
        if (this.fMsg == null) {
            return this.uninitialized();
        }
        if (gMSEC_Long == null) {
            return new Status(5, 35L, "Count is NULL");
        }
        return this.fMsg.GetFieldCount(gMSEC_Long);
    }

    @Override
    public Status GetFirstField(Field field) {
        if (this.fMsg == null) {
            return this.uninitialized();
        }
        if (field == null) {
            return new Status(5, 35L, "Field is NULL");
        }
        return this.fMsg.GetFirstField(field);
    }

    @Override
    public Status GetNextField(Field field) {
        if (this.fMsg == null) {
            return this.uninitialized();
        }
        if (field == null) {
            return new Status(5, 35L, "Field is NULL");
        }
        return this.fMsg.GetNextField(field);
    }

    @Override
    public Status SetConfig(Config config) {
        if (this.fMsg == null) {
            return this.uninitialized();
        }
        if (config == null) {
            return new Status(5, 35L, "Config is NULL");
        }
        return this.fMsg.SetConfig(config);
    }

    @Override
    public Status ToXML(GMSEC_String gMSEC_String) {
        if (this.fMsg == null) {
            return this.uninitialized();
        }
        if (gMSEC_String == null) {
            return new Status(5, 35L, "XML output string is NULL");
        }
        return this.fMsg.ToXML(gMSEC_String);
    }

    @Override
    public Status FromXML(String string) {
        if (this.fMsg == null) {
            return this.uninitialized();
        }
        return this.fMsg.FromXML(string);
    }

    @Override
    public String ToJSON() {
        if (this.fMsg == null) {
            return null;
        }
        return this.fMsg.ToJSON();
    }

    @Override
    public Status FromJSON(String string) {
        if (this.fMsg == null) {
            return this.uninitialized();
        }
        return this.fMsg.FromJSON(string);
    }

    @Override
    public Status FromXML(Node node) {
        Status status = new Status();
        String string = node.getNodeName();
        if (string.equals("MESSAGE")) {
            Object object;
            Object object2;
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap != null) {
                object2 = namedNodeMap.getNamedItem("KIND");
                Node node2 = namedNodeMap.getNamedItem("SUBJECT");
                if (object2 != null) {
                    object = object2.getNodeValue();
                    if (((String)object).equalsIgnoreCase("REQUEST")) {
                        this.SetKind(2);
                    } else if (((String)object).equalsIgnoreCase("REPLY")) {
                        this.SetKind(3);
                    } else {
                        this.SetKind(1);
                    }
                }
                if (node2 != null) {
                    object = node2.getNodeValue();
                    this.SetSubject((String)object);
                }
            }
            if ((object2 = node.getChildNodes()) != null) {
                for (int i = 0; i < object2.getLength(); ++i) {
                    NamedNodeMap namedNodeMap2;
                    object = object2.item(i);
                    if (object == null || !object.getNodeName().equals("FIELD") || (namedNodeMap2 = object.getAttributes()) == null) continue;
                    Node node3 = namedNodeMap2.getNamedItem("NAME");
                    Node node4 = namedNodeMap2.getNamedItem("TYPE");
                    String string2 = object.getNodeValue();
                    if (node3 == null || node4 == null || string2 == null) continue;
                    String string3 = node3.getNodeValue();
                    String string4 = node4.getNodeValue();
                    Field field = new Field();
                    field.SetName(string3);
                    field.SetValue(Field.LookupType(string4), string2);
                    this.AddField(field);
                }
            }
        } else {
            return new Status(5, 50L, "Parsing XML failed, invalid node: " + string);
        }
        return status;
    }

    @Override
    public Status GetMSGSize(GMSEC_ULong gMSEC_ULong) {
        if (this.fMsg == null) {
            return this.uninitialized();
        }
        if (gMSEC_ULong == null) {
            return new Status(5, 35L, "Size is NULL");
        }
        return this.fMsg.GetMSGSize(gMSEC_ULong);
    }

    @Override
    public String GetLibraryRootName() {
        if (this.fMsg == null) {
            return null;
        }
        return this.fMsg.GetLibraryRootName();
    }

    public static String GetTime() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-DDD-kk:mm:ss.SSS");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(date);
    }

    @Override
    public Status ClearFields() {
        if (this.fMsg == null) {
            return this.uninitialized();
        }
        return this.fMsg.ClearFields();
    }

    @Override
    public Status ClearField(String string) {
        if (this.fMsg == null) {
            return this.uninitialized();
        }
        return this.fMsg.ClearField(string);
    }

    public String toString() {
        if (this.fMsg == null) {
            return new String("[null Message]");
        }
        GMSEC_String gMSEC_String = new GMSEC_String();
        this.ToXML(gMSEC_String);
        return gMSEC_String.Get();
    }

    public Status CopyFields(Message message) {
        if (this.fMsg == null) {
            return this.uninitialized();
        }
        Status status = new Status();
        Field field = new Field();
        status = message.GetFirstField(field);
        while (!status.IsError()) {
            status = this.AddField(field);
            if (status.IsError()) {
                status.Set(5, 50L, "Error adding field while cloning message");
                return status;
            }
            status = message.GetNextField(field);
        }
        Status status2 = new Status();
        return status2;
    }

    @Override
    public void SetTracking(short s) {
        if (this.fMsg != null) {
            this.fMsg.SetTracking(s);
        }
    }

    @Override
    public void SetTrackingNode(short s) {
        if (this.fMsg != null) {
            this.fMsg.SetTrackingNode(s);
        }
    }

    @Override
    public void SetTrackingProcessId(short s) {
        if (this.fMsg != null) {
            this.fMsg.SetTrackingProcessId(s);
        }
    }

    @Override
    public void SetTrackingConnectionId(short s) {
        if (this.fMsg != null) {
            this.fMsg.SetTrackingConnectionId(s);
        }
    }

    @Override
    public void SetTrackingUserName(short s) {
        if (this.fMsg != null) {
            this.fMsg.SetTrackingUserName(s);
        }
    }

    @Override
    public void SetTrackingPublishTime(short s) {
        if (this.fMsg != null) {
            this.fMsg.SetTrackingPublishTime(s);
        }
    }

    @Override
    public void SetTrackingUniqueId(short s) {
        if (this.fMsg != null) {
            this.fMsg.SetTrackingUniqueId(s);
        }
    }

    @Override
    public void SetTrackingMwInfo(short s) {
        if (this.fMsg != null) {
            this.fMsg.SetTrackingMwInfo(s);
        }
    }

    @Override
    public short GetTracking() {
        short s = -1;
        if (this.fMsg != null) {
            s = this.fMsg.GetTracking();
        }
        return s;
    }

    @Override
    public short GetTrackingNode() {
        short s = -1;
        if (this.fMsg != null) {
            s = this.fMsg.GetTrackingNode();
        }
        return s;
    }

    @Override
    public short GetTrackingProcessId() {
        short s = -1;
        if (this.fMsg != null) {
            s = this.fMsg.GetTrackingProcessId();
        }
        return s;
    }

    @Override
    public short GetTrackingConnectionId() {
        short s = -1;
        if (this.fMsg != null) {
            s = this.fMsg.GetTrackingConnectionId();
        }
        return s;
    }

    @Override
    public short GetTrackingUserName() {
        short s = -1;
        if (this.fMsg != null) {
            s = this.fMsg.GetTrackingUserName();
        }
        return s;
    }

    @Override
    public short GetTrackingPublishTime() {
        short s = -1;
        if (this.fMsg != null) {
            s = this.fMsg.GetTrackingPublishTime();
        }
        return s;
    }

    @Override
    public short GetTrackingUniqueId() {
        short s = -1;
        if (this.fMsg != null) {
            s = this.fMsg.GetTrackingUniqueId();
        }
        return s;
    }

    @Override
    public short GetTrackingMwInfo() {
        short s = -1;
        if (this.fMsg != null) {
            s = this.fMsg.GetTrackingMwInfo();
        }
        return s;
    }

    private Status uninitialized() {
        return new Status(5, 35L, "Uninitialized Message");
    }
}

