/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.mist;

import gov.nasa.gsfc.gmsec.api.Config;
import gov.nasa.gsfc.gmsec.api.Connection;
import gov.nasa.gsfc.gmsec.api.GMSEC_Exception;
import gov.nasa.gsfc.gmsec.api.Message;
import gov.nasa.gsfc.gmsec.api.Status;
import gov.nasa.gsfc.gmsec.api.field.Field;
import gov.nasa.gsfc.gmsec.api.jni.mist.JNIConnectionManager;
import gov.nasa.gsfc.gmsec.api.mist.ConnectionManagerCallback;
import gov.nasa.gsfc.gmsec.api.mist.ConnectionManagerEventCallback;
import gov.nasa.gsfc.gmsec.api.mist.ConnectionManagerReplyCallback;
import gov.nasa.gsfc.gmsec.api.mist.ServiceParam;
import gov.nasa.gsfc.gmsec.api.mist.Specification;
import gov.nasa.gsfc.gmsec.api.mist.SubscriptionInfo;
import gov.nasa.gsfc.gmsec.api.mist.gmsecMIST;
import java.util.List;

public class ConnectionManager {
    private JNIConnectionManager m_jniConnMgr = null;

    public static JNIConnectionManager getInternal(ConnectionManager connectionManager) {
        return connectionManager == null ? null : connectionManager.m_jniConnMgr;
    }

    protected ConnectionManager(JNIConnectionManager jNIConnectionManager) {
        this.m_jniConnMgr = jNIConnectionManager;
    }

    protected ConnectionManager() {
    }

    public ConnectionManager(Config config) throws IllegalArgumentException, GMSEC_Exception {
        if (config == null) {
            throw new IllegalArgumentException("Config is null");
        }
        this.m_jniConnMgr = new JNIConnectionManager(this, config);
    }

    public ConnectionManager(Config config, boolean bl) throws IllegalArgumentException, GMSEC_Exception {
        if (config == null) {
            throw new IllegalArgumentException("Config is null");
        }
        this.m_jniConnMgr = new JNIConnectionManager(this, config, bl);
    }

    public ConnectionManager(Config config, boolean bl, int n) throws IllegalArgumentException, GMSEC_Exception {
        if (config == null) {
            throw new IllegalArgumentException("Config is null");
        }
        this.m_jniConnMgr = new JNIConnectionManager(this, config, bl, n);
    }

    public void initialize() throws GMSEC_Exception {
        this.m_jniConnMgr.initialize();
    }

    public void cleanup() {
        this.m_jniConnMgr.cleanup();
    }

    public String getLibraryVersion() throws GMSEC_Exception {
        return this.m_jniConnMgr.getLibraryVersion();
    }

    public Specification getSpecification() throws GMSEC_Exception {
        return this.m_jniConnMgr.getSpecification();
    }

    public void setStandardFields(List<Field> list) throws GMSEC_Exception {
        if (list != null && list.size() > 0) {
            this.m_jniConnMgr.setStandardFields(list);
        }
    }

    public void addStandardFields(Message message) throws IllegalArgumentException {
        if (message == null) {
            throw new IllegalArgumentException("Message is null");
        }
        this.m_jniConnMgr.addStandardFields(message);
    }

    public void registerEventCallback(Connection.ConnectionEvent connectionEvent, ConnectionManagerEventCallback connectionManagerEventCallback) throws IllegalArgumentException, GMSEC_Exception {
        if (connectionManagerEventCallback == null) {
            throw new IllegalArgumentException("ConnectionManagerEventCallback is null");
        }
        this.m_jniConnMgr.registerEventCallback(connectionEvent, connectionManagerEventCallback);
    }

    public SubscriptionInfo subscribe(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contain an empty string");
        }
        return this.m_jniConnMgr.subscribe(string);
    }

    public SubscriptionInfo subscribe(String string, ConnectionManagerCallback connectionManagerCallback) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contain an empty string");
        }
        if (connectionManagerCallback == null) {
            throw new IllegalArgumentException("ConnectionManagerCallback is null");
        }
        return this.m_jniConnMgr.subscribe(string, connectionManagerCallback);
    }

    public SubscriptionInfo subscribe(String string, Config config) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contain an empty string");
        }
        if (config == null) {
            throw new IllegalArgumentException("Config object is null");
        }
        return this.m_jniConnMgr.subscribe(string, config);
    }

    public SubscriptionInfo subscribe(String string, Config config, ConnectionManagerCallback connectionManagerCallback) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contain an empty string");
        }
        if (config == null) {
            throw new IllegalArgumentException("Config object is null");
        }
        if (connectionManagerCallback == null) {
            throw new IllegalArgumentException("ConnectionManagerCallback is null");
        }
        return this.m_jniConnMgr.subscribe(string, config, connectionManagerCallback);
    }

    public void unsubscribe(SubscriptionInfo subscriptionInfo) throws IllegalArgumentException, GMSEC_Exception {
        if (subscriptionInfo == null) {
            throw new IllegalArgumentException("SubscriptionInfo is null");
        }
        this.m_jniConnMgr.unsubscribe(subscriptionInfo);
    }

    public void publish(Message message) throws IllegalArgumentException, GMSEC_Exception {
        if (message == null) {
            throw new IllegalArgumentException("Message is null");
        }
        this.m_jniConnMgr.publish(message);
    }

    public void publish(Message message, Config config) throws IllegalArgumentException, GMSEC_Exception {
        if (message == null) {
            throw new IllegalArgumentException("Message is null");
        }
        if (config == null) {
            throw new IllegalArgumentException("Config is null");
        }
        this.m_jniConnMgr.publish(message, config);
    }

    public void request(Message message, int n, ConnectionManagerReplyCallback connectionManagerReplyCallback, int n2) throws IllegalArgumentException, GMSEC_Exception {
        if (message == null) {
            throw new IllegalArgumentException("Request Message is null");
        }
        if (connectionManagerReplyCallback == null) {
            throw new IllegalArgumentException("ConnectionManagerReplyCallback is null");
        }
        this.m_jniConnMgr.request(message, n, connectionManagerReplyCallback, n2);
    }

    public Message request(Message message, int n, int n2) throws IllegalArgumentException, GMSEC_Exception {
        if (message == null) {
            throw new IllegalArgumentException("Request Message is null");
        }
        return this.m_jniConnMgr.request(message, n, n2);
    }

    public void cancelRequest(ConnectionManagerReplyCallback connectionManagerReplyCallback) throws IllegalArgumentException, GMSEC_Exception {
        if (connectionManagerReplyCallback == null) {
            throw new IllegalArgumentException("ConnectionManagerReplyCallback is null");
        }
        this.m_jniConnMgr.cancelRequest(connectionManagerReplyCallback);
    }

    public void reply(Message message, Message message2) throws IllegalArgumentException, GMSEC_Exception {
        if (message == null) {
            throw new IllegalArgumentException("Request Message is null");
        }
        if (message2 == null) {
            throw new IllegalArgumentException("Reply Message is null");
        }
        this.m_jniConnMgr.reply(message, message2);
    }

    public void dispatch(Message message) throws IllegalArgumentException, GMSEC_Exception {
        if (message == null) {
            throw new IllegalArgumentException("Message is null");
        }
        this.m_jniConnMgr.dispatch(message);
    }

    public Message receive() throws GMSEC_Exception {
        return this.receive(-1);
    }

    public Message receive(int n) throws GMSEC_Exception {
        return this.m_jniConnMgr.receive(n);
    }

    public boolean startAutoDispatch() throws GMSEC_Exception {
        return this.m_jniConnMgr.startAutoDispatch();
    }

    public boolean stopAutoDispatch() throws GMSEC_Exception {
        return this.m_jniConnMgr.stopAutoDispatch(true);
    }

    public boolean stopAutoDispatch(boolean bl) throws GMSEC_Exception {
        return this.m_jniConnMgr.stopAutoDispatch(bl);
    }

    public void excludeSubject(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contain an empty string");
        }
        this.m_jniConnMgr.excludeSubject(string);
    }

    public void removeExcludedSubject(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contain an empty string");
        }
        this.m_jniConnMgr.removeExcludedSubject(string);
    }

    public Message createHeartbeatMessage(String string, List<Field> list) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contain an empty string");
        }
        return this.m_jniConnMgr.createHeartbeatMessage(string, list);
    }

    public void startHeartbeatService(String string, List<Field> list) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contain an empty string");
        }
        this.m_jniConnMgr.startHeartbeatService(string, list);
    }

    public void stopHeartbeatService() throws GMSEC_Exception {
        this.m_jniConnMgr.stopHeartbeatService();
    }

    public Status changeComponentStatus(Field field) throws IllegalArgumentException, GMSEC_Exception {
        if (field == null) {
            throw new IllegalArgumentException("Field is null");
        }
        return this.m_jniConnMgr.changeComponentStatus(field);
    }

    public Status changeComponentInfo(Field field) throws IllegalArgumentException, GMSEC_Exception {
        if (field == null) {
            throw new IllegalArgumentException("Field is null");
        }
        return this.m_jniConnMgr.changeComponentInfo(field);
    }

    public Status changeCPUMemory(Field field) throws IllegalArgumentException, GMSEC_Exception {
        if (field == null) {
            throw new IllegalArgumentException("Field is null");
        }
        return this.m_jniConnMgr.changeCPUMemory(field);
    }

    public Status changeCPUUtil(Field field) throws IllegalArgumentException, GMSEC_Exception {
        if (field == null) {
            throw new IllegalArgumentException("Field is null");
        }
        return this.m_jniConnMgr.changeCPUUtil(field);
    }

    public Message createLogMessage(String string, List<Field> list) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contain an empty string");
        }
        return this.m_jniConnMgr.createLogMessage(string, list);
    }

    public void setLoggingDefaults(String string, List<Field> list) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contain an empty string");
        }
        this.m_jniConnMgr.setLoggingDefaults(string, list);
    }

    public void publishLog(String string, Field field) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Log message is null or contain an empty string");
        }
        if (field == null) {
            throw new IllegalArgumentException("Severity Field is null");
        }
        this.m_jniConnMgr.publishLog(string, field);
    }

    public void requestDirective(String string, Field field, List<Field> list) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contain an empty string");
        }
        if (field == null) {
            throw new IllegalArgumentException("Directive String Field is null");
        }
        this.m_jniConnMgr.requestDirective(string, field, list);
    }

    public void requestDirective(String string, Field field, List<Field> list, int n, ConnectionManagerReplyCallback connectionManagerReplyCallback, int n2) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contain an empty string");
        }
        if (field == null) {
            throw new IllegalArgumentException("Directive String Field is null");
        }
        if (connectionManagerReplyCallback == null) {
            throw new IllegalArgumentException("ConnectionManagerReplyCallback is null");
        }
        this.m_jniConnMgr.requestDirective(string, field, list, n, connectionManagerReplyCallback, n2);
    }

    public Message requestDirective(String string, Field field, List<Field> list, int n, int n2) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contain an empty string");
        }
        if (field == null) {
            throw new IllegalArgumentException("Directive String Field is null");
        }
        return this.m_jniConnMgr.requestDirective(string, field, list, n, n2);
    }

    public void acknowledgeDirectiveRequest(String string, Message message, gmsecMIST.ResponseStatus responseStatus, List<Field> list) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contain an empty string");
        }
        if (message == null) {
            throw new IllegalArgumentException("Request Message is null");
        }
        this.m_jniConnMgr.acknowledgeDirectiveRequest(string, message, responseStatus, list);
    }

    public void publishResourceMessage(String string, long l, long l2) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contain an empty string");
        }
        this.m_jniConnMgr.publishResourceMessage(string, l, l2);
    }

    public Message createResourceMessage(String string, long l, long l2) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contain an empty string");
        }
        return this.m_jniConnMgr.createResourceMessage(string, l, l2);
    }

    public void startResourceMessageService(String string, long l, long l2, long l3) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contain an empty string");
        }
        this.m_jniConnMgr.startResourceMessageService(string, l, l2, l3);
    }

    public boolean stopResourceMessageService() {
        return this.m_jniConnMgr.stopResourceMessageService();
    }

    public void acknowledgeSimpleService(String string, Message message, gmsecMIST.ResponseStatus responseStatus, List<Field> list) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contain an empty string");
        }
        if (message == null) {
            throw new IllegalArgumentException("Request Message is null");
        }
        this.m_jniConnMgr.acknowledgeSimpleService(string, message, responseStatus, list);
    }

    public void requestSimpleService(String string, String string2, Field field, List<Field> list, List<ServiceParam> list2) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contain an empty string");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("Operation Name is null or contain an empty string");
        }
        if (field == null) {
            throw new IllegalArgumentException("Operation Number Field is null");
        }
        this.m_jniConnMgr.requestSimpleService(string, string2, field, list, list2);
    }

    public void requestSimpleService(String string, String string2, Field field, List<Field> list, List<ServiceParam> list2, int n, ConnectionManagerReplyCallback connectionManagerReplyCallback, int n2) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contain an empty string");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("Operation Name is null or contain an empty string");
        }
        if (field == null) {
            throw new IllegalArgumentException("Operation Number Field is null");
        }
        if (connectionManagerReplyCallback == null) {
            throw new IllegalArgumentException("ConnectionManagerReplyCallback is null");
        }
        this.m_jniConnMgr.requestSimpleService(string, string2, field, list, list2, n, connectionManagerReplyCallback, n2);
    }

    public Message requestSimpleService(String string, String string2, Field field, List<Field> list, List<ServiceParam> list2, int n, int n2) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contain an empty string");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("Operation Name is null or contain an empty string");
        }
        if (field == null) {
            throw new IllegalArgumentException("Operation Number Field is null");
        }
        return this.m_jniConnMgr.requestSimpleService(string, string2, field, list, list2, n, n2);
    }
}

