/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.jni.mist;

import gov.nasa.gsfc.gmsec.api.GMSEC_Exception;
import gov.nasa.gsfc.gmsec.api.jni.gmsecJNI;
import gov.nasa.gsfc.gmsec.api.jni.mist.JNIDevice;
import gov.nasa.gsfc.gmsec.api.mist.Device;

public class JNIDeviceIterator {
    private long swigCPtr;
    private boolean swigCMemOwn;

    public JNIDeviceIterator(long l, boolean bl) {
        this.swigCPtr = l;
        this.swigCMemOwn = bl;
    }

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
        }
        this.swigCPtr = 0L;
    }

    protected static long getCPtr(JNIDeviceIterator jNIDeviceIterator) {
        return jNIDeviceIterator == null ? 0L : jNIDeviceIterator.swigCPtr;
    }

    public boolean hasNext() {
        return gmsecJNI.DeviceIterator_HasNext(this.swigCPtr, this);
    }

    public Device next() throws GMSEC_Exception {
        long l = gmsecJNI.DeviceIterator_Next(this.swigCPtr, this);
        return new Device(new JNIDevice(l, false));
    }

    public void reset() {
        gmsecJNI.DeviceIterator_Reset(this.swigCPtr, this);
    }
}

