/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.jni.mist;

import gov.nasa.gsfc.gmsec.api.Config;
import gov.nasa.gsfc.gmsec.api.Connection;
import gov.nasa.gsfc.gmsec.api.GMSEC_Exception;
import gov.nasa.gsfc.gmsec.api.Message;
import gov.nasa.gsfc.gmsec.api.Status;
import gov.nasa.gsfc.gmsec.api.field.Field;
import gov.nasa.gsfc.gmsec.api.jni.JNIConfig;
import gov.nasa.gsfc.gmsec.api.jni.JNIField;
import gov.nasa.gsfc.gmsec.api.jni.JNIMessage;
import gov.nasa.gsfc.gmsec.api.jni.JNIStatus;
import gov.nasa.gsfc.gmsec.api.jni.gmsecJNI;
import gov.nasa.gsfc.gmsec.api.jni.mist.ArrayListConverter;
import gov.nasa.gsfc.gmsec.api.jni.mist.JNIConnMgrCallback;
import gov.nasa.gsfc.gmsec.api.jni.mist.JNIConnMgrEventCallback;
import gov.nasa.gsfc.gmsec.api.jni.mist.JNIConnMgrReplyCallback;
import gov.nasa.gsfc.gmsec.api.jni.mist.JNIConnMgrSubscriptionInfo;
import gov.nasa.gsfc.gmsec.api.jni.mist.JNIServiceParam;
import gov.nasa.gsfc.gmsec.api.jni.mist.JNISpecification;
import gov.nasa.gsfc.gmsec.api.mist.ConnectionManager;
import gov.nasa.gsfc.gmsec.api.mist.ConnectionManagerCallback;
import gov.nasa.gsfc.gmsec.api.mist.ConnectionManagerEventCallback;
import gov.nasa.gsfc.gmsec.api.mist.ConnectionManagerReplyCallback;
import gov.nasa.gsfc.gmsec.api.mist.ServiceParam;
import gov.nasa.gsfc.gmsec.api.mist.Specification;
import gov.nasa.gsfc.gmsec.api.mist.SubscriptionInfo;
import gov.nasa.gsfc.gmsec.api.mist.gmsecMIST;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JNIConnectionManager {
    private ConnectionManager extConnMgr;
    private long swigCPtr;
    protected boolean swigCMemOwn;
    private List<SubscriptionInfo> subscriptions;
    private List<ConnectionManagerEventCallback> eventCallbacks;

    protected JNIConnectionManager(long l, boolean bl) {
        this.swigCPtr = l;
        this.swigCMemOwn = bl;
        this.subscriptions = Collections.synchronizedList(new ArrayList());
        this.eventCallbacks = new ArrayList<ConnectionManagerEventCallback>();
    }

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            gmsecJNI.delete_ConnectionManager(this.swigCPtr, this);
            this.subscriptions.clear();
            this.eventCallbacks.clear();
            this.extConnMgr = null;
            this.swigCPtr = 0L;
            this.swigCMemOwn = false;
            this.subscriptions = null;
            this.eventCallbacks = null;
        }
    }

    protected static long getCPtr(JNIConnectionManager jNIConnectionManager) {
        return jNIConnectionManager == null ? 0L : jNIConnectionManager.swigCPtr;
    }

    public JNIConnectionManager(ConnectionManager connectionManager, Config config) throws GMSEC_Exception {
        this(gmsecJNI.new_ConnectionManager(JNIConfig.getCPtr(Config.getInternal(config)), Config.getInternal(config)), true);
        this.extConnMgr = connectionManager;
    }

    public JNIConnectionManager(ConnectionManager connectionManager, Config config, boolean bl) throws GMSEC_Exception {
        this(gmsecJNI.new_ConnectionManager(JNIConfig.getCPtr(Config.getInternal(config)), Config.getInternal(config), bl), true);
        this.extConnMgr = connectionManager;
    }

    public JNIConnectionManager(ConnectionManager connectionManager, Config config, boolean bl, int n) throws GMSEC_Exception {
        this(gmsecJNI.new_ConnectionManager(JNIConfig.getCPtr(Config.getInternal(config)), Config.getInternal(config), bl, n), true);
        this.extConnMgr = connectionManager;
    }

    public void initialize() throws GMSEC_Exception {
        gmsecJNI.ConnectionManager_Initialize(this.swigCPtr, this);
    }

    public void cleanup() {
        gmsecJNI.ConnectionManager_Cleanup(this.swigCPtr, this);
    }

    public String getLibraryVersion() throws GMSEC_Exception {
        return gmsecJNI.ConnectionManager_GetLibraryVersion(this.swigCPtr, this);
    }

    public Specification getSpecification() throws GMSEC_Exception {
        long l = gmsecJNI.ConnectionManager_GetSpecification(this.swigCPtr, this);
        if (l != 0L) {
            return new Specification(new JNISpecification(l, false));
        }
        return null;
    }

    public void setStandardFields(List<Field> list) {
        long[] lArray = ArrayListConverter.listToFieldPtrs(list);
        JNIField[] jNIFieldArray = ArrayListConverter.listToJNIFields(list);
        int n = list == null ? 0 : list.size();
        gmsecJNI.ConnectionManager_SetStandardFields(this.swigCPtr, this, lArray, jNIFieldArray, n);
    }

    public void addStandardFields(Message message) {
        JNIMessage jNIMessage = Message.getInternal(message);
        gmsecJNI.ConnectionManager_AddStandardFields(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage);
    }

    public void registerEventCallback(Connection.ConnectionEvent connectionEvent, ConnectionManagerEventCallback connectionManagerEventCallback) throws GMSEC_Exception {
        connectionManagerEventCallback.setConnectionManager(this);
        long l = JNIConnMgrEventCallback.getCPtr(ConnectionManagerEventCallback.getInternal(connectionManagerEventCallback));
        gmsecJNI.ConnectionManager_RegisterEventCallback(this.swigCPtr, this, connectionEvent.ordinal(), l);
        if (this.eventCallbacks.indexOf(connectionManagerEventCallback) == -1) {
            this.eventCallbacks.add(connectionManagerEventCallback);
        }
    }

    public SubscriptionInfo subscribe(String string) throws GMSEC_Exception {
        long l = gmsecJNI.ConnectionManager_Subscribe(this.swigCPtr, this, string);
        if (l != 0L) {
            return new SubscriptionInfo(new JNIConnMgrSubscriptionInfo(l, false, string, null));
        }
        return null;
    }

    public SubscriptionInfo subscribe(String string, ConnectionManagerCallback connectionManagerCallback) throws GMSEC_Exception {
        connectionManagerCallback.setConnectionManager(this);
        long l = JNIConnMgrCallback.getCPtr(ConnectionManagerCallback.getInternal(connectionManagerCallback));
        long l2 = gmsecJNI.ConnectionManager_Subscribe(this.swigCPtr, this, string, l);
        if (l2 != 0L) {
            SubscriptionInfo subscriptionInfo = new SubscriptionInfo(new JNIConnMgrSubscriptionInfo(l2, false, string, connectionManagerCallback));
            this.subscriptions.add(subscriptionInfo);
            return subscriptionInfo;
        }
        return null;
    }

    public SubscriptionInfo subscribe(String string, Config config) throws GMSEC_Exception {
        JNIConfig jNIConfig = Config.getInternal(config);
        long l = gmsecJNI.ConnectionManager_Subscribe(this.swigCPtr, this, string, JNIConfig.getCPtr(jNIConfig), jNIConfig);
        if (l != 0L) {
            return new SubscriptionInfo(new JNIConnMgrSubscriptionInfo(l, false, string, null));
        }
        return null;
    }

    public SubscriptionInfo subscribe(String string, Config config, ConnectionManagerCallback connectionManagerCallback) throws GMSEC_Exception {
        connectionManagerCallback.setConnectionManager(this);
        JNIConfig jNIConfig = Config.getInternal(config);
        long l = JNIConnMgrCallback.getCPtr(ConnectionManagerCallback.getInternal(connectionManagerCallback));
        long l2 = gmsecJNI.ConnectionManager_Subscribe(this.swigCPtr, this, string, JNIConfig.getCPtr(jNIConfig), jNIConfig, l);
        if (l2 != 0L) {
            SubscriptionInfo subscriptionInfo = new SubscriptionInfo(new JNIConnMgrSubscriptionInfo(l2, false, string, connectionManagerCallback));
            this.subscriptions.add(subscriptionInfo);
            return subscriptionInfo;
        }
        return null;
    }

    public void unsubscribe(SubscriptionInfo subscriptionInfo) throws GMSEC_Exception {
        JNIConnMgrSubscriptionInfo jNIConnMgrSubscriptionInfo = SubscriptionInfo.getInternal(subscriptionInfo);
        gmsecJNI.ConnectionManager_Unsubscribe(this.swigCPtr, this, JNIConnMgrSubscriptionInfo.getCPtr(jNIConnMgrSubscriptionInfo), jNIConnMgrSubscriptionInfo);
        int n = this.subscriptions.indexOf(subscriptionInfo);
        if (n != -1) {
            this.subscriptions.remove(n);
        }
    }

    public void publish(Message message) throws GMSEC_Exception {
        JNIMessage jNIMessage = Message.getInternal(message);
        gmsecJNI.ConnectionManager_Publish(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage);
    }

    public void publish(Message message, Config config) throws GMSEC_Exception {
        JNIMessage jNIMessage = Message.getInternal(message);
        JNIConfig jNIConfig = Config.getInternal(config);
        gmsecJNI.ConnectionManager_Publish(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage, JNIConfig.getCPtr(jNIConfig), jNIConfig);
    }

    public void request(Message message, int n, ConnectionManagerReplyCallback connectionManagerReplyCallback, int n2) throws GMSEC_Exception {
        connectionManagerReplyCallback.setConnectionManager(this);
        long l = JNIConnMgrReplyCallback.getCPtr(ConnectionManagerReplyCallback.getInternal(connectionManagerReplyCallback));
        JNIMessage jNIMessage = Message.getInternal(message);
        gmsecJNI.ConnectionManager_Request(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage, n, l, n2);
    }

    public Message request(Message message, int n, int n2) throws GMSEC_Exception {
        JNIMessage jNIMessage = Message.getInternal(message);
        long l = gmsecJNI.ConnectionManager_Request(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage, n, n2);
        if (l != 0L) {
            return new Message(new JNIMessage(l, true));
        }
        return null;
    }

    public void cancelRequest(ConnectionManagerReplyCallback connectionManagerReplyCallback) throws GMSEC_Exception {
        if (connectionManagerReplyCallback.getConnectionManager() != this) {
            return;
        }
        long l = JNIConnMgrReplyCallback.getCPtr(ConnectionManagerReplyCallback.getInternal(connectionManagerReplyCallback));
        gmsecJNI.ConnectionManager_CancelRequest(this.swigCPtr, this, l);
    }

    public void reply(Message message, Message message2) throws GMSEC_Exception {
        JNIMessage jNIMessage = Message.getInternal(message);
        JNIMessage jNIMessage2 = Message.getInternal(message2);
        gmsecJNI.ConnectionManager_Reply(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage, JNIMessage.getCPtr(jNIMessage2), jNIMessage2);
    }

    public void dispatch(Message message) throws GMSEC_Exception {
        JNIMessage jNIMessage = Message.getInternal(message);
        gmsecJNI.ConnectionManager_Dispatch(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage);
    }

    public Message receive(int n) throws GMSEC_Exception {
        long l = gmsecJNI.ConnectionManager_Receive(this.swigCPtr, this, n);
        if (l != 0L) {
            return new Message(new JNIMessage(l, true));
        }
        return null;
    }

    public boolean startAutoDispatch() throws GMSEC_Exception {
        return gmsecJNI.ConnectionManager_StartAutoDispatch(this.swigCPtr, this);
    }

    public boolean stopAutoDispatch(boolean bl) throws GMSEC_Exception {
        return gmsecJNI.ConnectionManager_StopAutoDispatch(this.swigCPtr, this, bl);
    }

    public void excludeSubject(String string) throws GMSEC_Exception {
        gmsecJNI.ConnectionManager_ExcludeSubject(this.swigCPtr, this, string);
    }

    public void removeExcludedSubject(String string) throws GMSEC_Exception {
        gmsecJNI.ConnectionManager_RemoveExcludedSubject(this.swigCPtr, this, string);
    }

    public Message createHeartbeatMessage(String string, List<Field> list) throws GMSEC_Exception {
        int n;
        JNIField[] jNIFieldArray;
        long[] lArray = ArrayListConverter.listToFieldPtrs(list);
        long l = gmsecJNI.ConnectionManager_CreateHeartbeatMessage(this.swigCPtr, this, string, lArray, jNIFieldArray = ArrayListConverter.listToJNIFields(list), n = list == null ? 0 : list.size());
        if (l != 0L) {
            return new Message(new JNIMessage(l, true));
        }
        return null;
    }

    public void startHeartbeatService(String string, List<Field> list) throws GMSEC_Exception {
        long[] lArray = ArrayListConverter.listToFieldPtrs(list);
        JNIField[] jNIFieldArray = ArrayListConverter.listToJNIFields(list);
        int n = list == null ? 0 : list.size();
        gmsecJNI.ConnectionManager_StartHeartbeatService(this.swigCPtr, this, string, lArray, jNIFieldArray, n);
    }

    public void stopHeartbeatService() {
        gmsecJNI.ConnectionManager_StopHeartbeatService(this.swigCPtr, this);
    }

    public Status changeComponentStatus(Field field) {
        JNIField jNIField = Field.getInternal(field);
        long l = gmsecJNI.ConnectionManager_ChangeComponentStatus(this.swigCPtr, this, JNIField.getCPtr(jNIField), jNIField);
        return new JNIStatus(l, true);
    }

    public Status changeComponentInfo(Field field) {
        JNIField jNIField = Field.getInternal(field);
        long l = gmsecJNI.ConnectionManager_ChangeComponentInfo(this.swigCPtr, this, JNIField.getCPtr(jNIField), jNIField);
        return new JNIStatus(l, true);
    }

    public Status changeCPUMemory(Field field) {
        JNIField jNIField = Field.getInternal(field);
        long l = gmsecJNI.ConnectionManager_ChangeCPUMemory(this.swigCPtr, this, JNIField.getCPtr(jNIField), jNIField);
        return new JNIStatus(l, true);
    }

    public Status changeCPUUtil(Field field) {
        JNIField jNIField = Field.getInternal(field);
        long l = gmsecJNI.ConnectionManager_ChangeCPUUtil(this.swigCPtr, this, JNIField.getCPtr(jNIField), jNIField);
        return new JNIStatus(l, true);
    }

    public Message createLogMessage(String string, List<Field> list) throws GMSEC_Exception {
        int n;
        JNIField[] jNIFieldArray;
        long[] lArray = ArrayListConverter.listToFieldPtrs(list);
        long l = gmsecJNI.ConnectionManager_CreateLogMessage(this.swigCPtr, this, string, lArray, jNIFieldArray = ArrayListConverter.listToJNIFields(list), n = list == null ? 0 : list.size());
        if (l != 0L) {
            return new Message(new JNIMessage(l, true));
        }
        return null;
    }

    public void setLoggingDefaults(String string, List<Field> list) throws GMSEC_Exception {
        long[] lArray = ArrayListConverter.listToFieldPtrs(list);
        JNIField[] jNIFieldArray = ArrayListConverter.listToJNIFields(list);
        int n = list == null ? 0 : list.size();
        gmsecJNI.ConnectionManager_SetLoggingDefaults(this.swigCPtr, this, string, lArray, jNIFieldArray, n);
    }

    public void publishLog(String string, Field field) throws GMSEC_Exception {
        JNIField jNIField = Field.getInternal(field);
        gmsecJNI.ConnectionManager_PublishLog(this.swigCPtr, this, string, JNIField.getCPtr(jNIField), jNIField);
    }

    public void requestDirective(String string, Field field, List<Field> list) throws GMSEC_Exception {
        JNIField jNIField = Field.getInternal(field);
        long[] lArray = ArrayListConverter.listToFieldPtrs(list);
        JNIField[] jNIFieldArray = ArrayListConverter.listToJNIFields(list);
        int n = list == null ? 0 : list.size();
        gmsecJNI.ConnectionManager_RequestDirective(this.swigCPtr, this, string, JNIField.getCPtr(jNIField), jNIField, lArray, jNIFieldArray, n);
    }

    public void requestDirective(String string, Field field, List<Field> list, int n, ConnectionManagerReplyCallback connectionManagerReplyCallback, int n2) throws GMSEC_Exception {
        connectionManagerReplyCallback.setConnectionManager(this);
        long l = JNIConnMgrReplyCallback.getCPtr(ConnectionManagerReplyCallback.getInternal(connectionManagerReplyCallback));
        JNIField jNIField = Field.getInternal(field);
        long[] lArray = ArrayListConverter.listToFieldPtrs(list);
        JNIField[] jNIFieldArray = ArrayListConverter.listToJNIFields(list);
        int n3 = list == null ? 0 : list.size();
        gmsecJNI.ConnectionManager_RequestDirective(this.swigCPtr, this, string, JNIField.getCPtr(jNIField), jNIField, lArray, jNIFieldArray, n3, n, l, n2);
    }

    public Message requestDirective(String string, Field field, List<Field> list, int n, int n2) throws GMSEC_Exception {
        JNIField jNIField = Field.getInternal(field);
        long[] lArray = ArrayListConverter.listToFieldPtrs(list);
        JNIField[] jNIFieldArray = ArrayListConverter.listToJNIFields(list);
        int n3 = list == null ? 0 : list.size();
        long l = gmsecJNI.ConnectionManager_RequestDirective(this.swigCPtr, this, string, JNIField.getCPtr(jNIField), jNIField, lArray, jNIFieldArray, n3, n, n2);
        if (l != 0L) {
            return new Message(new JNIMessage(l, true));
        }
        return null;
    }

    public void acknowledgeDirectiveRequest(String string, Message message, gmsecMIST.ResponseStatus responseStatus, List<Field> list) throws GMSEC_Exception {
        JNIMessage jNIMessage = Message.getInternal(message);
        long[] lArray = ArrayListConverter.listToFieldPtrs(list);
        JNIField[] jNIFieldArray = ArrayListConverter.listToJNIFields(list);
        int n = list == null ? 0 : list.size();
        gmsecJNI.ConnectionManager_AcknowledgeDirectiveRequest(this.swigCPtr, this, string, JNIMessage.getCPtr(jNIMessage), jNIMessage, responseStatus.getValue(), lArray, jNIFieldArray, n);
    }

    public void publishResourceMessage(String string, long l, long l2) throws GMSEC_Exception {
        gmsecJNI.ConnectionManager_PublishResourceMessage(this.swigCPtr, this, string, l, l2);
    }

    public Message createResourceMessage(String string, long l, long l2) throws GMSEC_Exception {
        long l3 = gmsecJNI.ConnectionManager_CreateResourceMessage(this.swigCPtr, this, string, l, l2);
        if (l3 != 0L) {
            return new Message(new JNIMessage(l3, true));
        }
        return null;
    }

    public void startResourceMessageService(String string, long l, long l2, long l3) throws GMSEC_Exception {
        gmsecJNI.ConnectionManager_StartResourceMessageService(this.swigCPtr, this, string, l, l2, l3);
    }

    public boolean stopResourceMessageService() {
        return gmsecJNI.ConnectionManager_StopResourceMessageService(this.swigCPtr, this);
    }

    public void acknowledgeSimpleService(String string, Message message, gmsecMIST.ResponseStatus responseStatus, List<Field> list) throws GMSEC_Exception {
        JNIMessage jNIMessage = Message.getInternal(message);
        long[] lArray = ArrayListConverter.listToFieldPtrs(list);
        JNIField[] jNIFieldArray = ArrayListConverter.listToJNIFields(list);
        int n = list == null ? 0 : list.size();
        gmsecJNI.ConnectionManager_AcknowledgeSimpleService(this.swigCPtr, this, string, JNIMessage.getCPtr(jNIMessage), jNIMessage, responseStatus.getValue(), lArray, jNIFieldArray, n);
    }

    public void requestSimpleService(String string, String string2, Field field, List<Field> list, List<ServiceParam> list2) throws GMSEC_Exception {
        JNIField jNIField = Field.getInternal(field);
        long[] lArray = ArrayListConverter.listToFieldPtrs(list);
        JNIField[] jNIFieldArray = ArrayListConverter.listToJNIFields(list);
        int n = list == null ? 0 : list.size();
        long[] lArray2 = ArrayListConverter.listToServiceParamPtrs(list2);
        JNIServiceParam[] jNIServiceParamArray = ArrayListConverter.listToJNIServiceParams(list2);
        int n2 = list2 == null ? 0 : list2.size();
        gmsecJNI.ConnectionManager_RequestSimpleService(this.swigCPtr, this, string, string2, JNIField.getCPtr(jNIField), jNIField, lArray, jNIFieldArray, n, lArray2, jNIServiceParamArray, n2);
    }

    public void requestSimpleService(String string, String string2, Field field, List<Field> list, List<ServiceParam> list2, int n, ConnectionManagerReplyCallback connectionManagerReplyCallback, int n2) throws GMSEC_Exception {
        connectionManagerReplyCallback.setConnectionManager(this);
        long l = JNIConnMgrReplyCallback.getCPtr(ConnectionManagerReplyCallback.getInternal(connectionManagerReplyCallback));
        JNIField jNIField = Field.getInternal(field);
        long[] lArray = ArrayListConverter.listToFieldPtrs(list);
        JNIField[] jNIFieldArray = ArrayListConverter.listToJNIFields(list);
        int n3 = list == null ? 0 : list.size();
        long[] lArray2 = ArrayListConverter.listToServiceParamPtrs(list2);
        JNIServiceParam[] jNIServiceParamArray = ArrayListConverter.listToJNIServiceParams(list2);
        int n4 = list2 == null ? 0 : list2.size();
        gmsecJNI.ConnectionManager_RequestSimpleService(this.swigCPtr, this, string, string2, JNIField.getCPtr(jNIField), jNIField, lArray, jNIFieldArray, n3, lArray2, jNIServiceParamArray, n4, n, l, n2);
    }

    public Message requestSimpleService(String string, String string2, Field field, List<Field> list, List<ServiceParam> list2, int n, int n2) throws GMSEC_Exception {
        JNIField jNIField = Field.getInternal(field);
        long[] lArray = ArrayListConverter.listToFieldPtrs(list);
        JNIField[] jNIFieldArray = ArrayListConverter.listToJNIFields(list);
        int n3 = list == null ? 0 : list.size();
        long[] lArray2 = ArrayListConverter.listToServiceParamPtrs(list2);
        JNIServiceParam[] jNIServiceParamArray = ArrayListConverter.listToJNIServiceParams(list2);
        int n4 = list2 == null ? 0 : list2.size();
        long l = gmsecJNI.ConnectionManager_RequestSimpleService(this.swigCPtr, this, string, string2, JNIField.getCPtr(jNIField), jNIField, lArray, jNIFieldArray, n3, lArray2, jNIServiceParamArray, n4, n, n2);
        if (l != 0L) {
            return new Message(new JNIMessage(l, true));
        }
        return null;
    }
}

