/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.jni;

import gov.nasa.gsfc.gmsec.api.jni.JNILogHandler;
import gov.nasa.gsfc.gmsec.api.jni.gmsecJNI;
import gov.nasa.gsfc.gmsec.api.util.Log;
import gov.nasa.gsfc.gmsec.api.util.LogEntry;
import gov.nasa.gsfc.gmsec.api.util.LogHandler;
import gov.nasa.gsfc.gmsec.api.util.LogLevel;
import gov.nasa.gsfc.gmsec.api.util.TimeUtil;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class JNILog {
    private static Map<LogLevel, LogHandler> logHandlers = new HashMap<LogLevel, LogHandler>();
    private static final DefaultLogHandler defaultLogHandler = new DefaultLogHandler();

    private static void storeLogHandler(LogLevel logLevel, LogHandler logHandler) {
        logHandlers.put(logLevel, logHandler);
    }

    public static DefaultLogHandler getDefaultLogHandler() {
        return defaultLogHandler;
    }

    public static void setReportingLevel(LogLevel logLevel) {
        gmsecJNI.Log_SetReportingLevel(logLevel.getValue());
    }

    public static LogLevel getReportingLevel() {
        int n = gmsecJNI.Log_GetReportingLevel();
        return LogLevel.values()[n];
    }

    public static void registerHandler(LogHandler logHandler) {
        long l = JNILogHandler.getCPtr(LogHandler.getInternal(logHandler));
        gmsecJNI.Log_RegisterHandler(l);
        for (int i = LogLevel.ERROR.getValue(); i <= LogLevel.DEBUG.getValue(); ++i) {
            JNILog.storeLogHandler(LogLevel.getUsingValue(i), logHandler);
        }
    }

    public static void registerHandler(LogLevel logLevel, LogHandler logHandler) {
        long l = JNILogHandler.getCPtr(LogHandler.getInternal(logHandler));
        gmsecJNI.Log_RegisterHandler(logLevel.getValue(), l);
        JNILog.storeLogHandler(logLevel, logHandler);
    }

    public static String logLevelToString(LogLevel logLevel) {
        return gmsecJNI.Log_LogLevelToString(logLevel.getValue());
    }

    public static LogLevel logLevelFromString(String string) {
        int n = gmsecJNI.Log_LogLevelFromString(string);
        return LogLevel.values()[n];
    }

    public static void logError(String string) {
        JNILog.doLog(LogLevel.ERROR, string);
    }

    public static void logSecure(String string) {
        JNILog.doLog(LogLevel.SECURE, string);
    }

    public static void logWarning(String string) {
        JNILog.doLog(LogLevel.WARNING, string);
    }

    public static void logInfo(String string) {
        JNILog.doLog(LogLevel.INFO, string);
    }

    public static void logVerbose(String string) {
        JNILog.doLog(LogLevel.VERBOSE, string);
    }

    public static void logDebug(String string) {
        JNILog.doLog(LogLevel.DEBUG, string);
    }

    private static void doLog(LogLevel logLevel, String string) {
        LogHandler logHandler;
        if (Log.getReportingLevel().getValue() >= logLevel.getValue() && (logHandler = logHandlers.get((Object)logLevel)) != null) {
            logHandler.onMessage(JNILog.generateEntry(logLevel, string));
        }
    }

    private static LogEntry generateEntry(LogLevel logLevel, String string) {
        LogEntry logEntry = new LogEntry();
        logEntry.time = TimeUtil.getCurrentTime();
        logEntry.level = logLevel;
        logEntry.fileName = Thread.currentThread().getStackTrace()[5].getFileName();
        logEntry.lineNumber = Thread.currentThread().getStackTrace()[5].getLineNumber();
        logEntry.message = string;
        return logEntry;
    }

    static {
        for (int i = 0; i < 7; ++i) {
            Log.registerHandler(LogLevel.getUsingValue(i), defaultLogHandler);
        }
    }

    public static class DefaultLogHandler
    extends LogHandler {
        private Writer writer = new PrintWriter(System.err);

        @Override
        public void onMessage(LogEntry logEntry) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(TimeUtil.formatTime(logEntry.time)).append(" [").append(logEntry.level.toString()).append("] ");
            stringBuilder.append("[").append(logEntry.fileName).append(":").append(logEntry.lineNumber).append("] ");
            stringBuilder.append(logEntry.message).append("\n");
            String string = stringBuilder.toString().replace("\n", "\n\t");
            try {
                this.writer.write(string + "\n");
                this.writer.flush();
            }
            catch (IOException iOException) {
                System.err.println("*** Error writing log ***\n");
                System.err.println(string);
            }
        }

        public void setStream(String string) {
            if (string.equalsIgnoreCase("stderr")) {
                if (this.writer instanceof FileWriter) {
                    try {
                        this.writer.close();
                    }
                    catch (IOException iOException) {
                        System.err.println("ERROR: Unable to close file.");
                    }
                }
                this.writer = new PrintWriter(System.err);
            } else if (string.equalsIgnoreCase("stdout")) {
                if (this.writer instanceof FileWriter) {
                    try {
                        this.writer.close();
                    }
                    catch (IOException iOException) {
                        System.err.println("ERROR: Unable to close file.");
                    }
                }
                this.writer = new PrintWriter(System.out);
            } else {
                if (this.writer instanceof FileWriter) {
                    try {
                        this.writer.close();
                    }
                    catch (IOException iOException) {
                        System.err.println("ERROR: Unable to close file.");
                    }
                    this.writer = new PrintWriter(System.err);
                }
                try {
                    FileWriter fileWriter = new FileWriter(string, true);
                    this.writer = fileWriter;
                }
                catch (IOException iOException) {
                    System.err.println("ERROR: Unable to open and/or append to log file\n");
                }
            }
        }
    }
}

