/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.jni;

import gov.nasa.gsfc.gmsec.api.ConfigFile;
import gov.nasa.gsfc.gmsec.api.jni.JNIConfigEntry;
import gov.nasa.gsfc.gmsec.api.jni.JNIMessageEntry;
import gov.nasa.gsfc.gmsec.api.jni.JNISubscriptionEntry;
import gov.nasa.gsfc.gmsec.api.jni.gmsecJNI;

public class JNIConfigFileIterator {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected JNIConfigFileIterator(long l, boolean bl) {
        this.swigCPtr = l;
        this.swigCMemOwn = bl;
    }

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void delete() {
        this.swigCPtr = 0L;
        this.swigCMemOwn = false;
    }

    protected static long getCPtr(JNIConfigFileIterator jNIConfigFileIterator) {
        return jNIConfigFileIterator == null ? 0L : jNIConfigFileIterator.swigCPtr;
    }

    public boolean hasNextConfig() {
        return gmsecJNI.ConfigFileIterator_HasNextConfig(this.swigCPtr, this);
    }

    public boolean hasNextMessage() {
        return gmsecJNI.ConfigFileIterator_HasNextMessage(this.swigCPtr, this);
    }

    public boolean hasNextSubscription() {
        return gmsecJNI.ConfigFileIterator_HasNextSubscription(this.swigCPtr, this);
    }

    public boolean hasNextCustomElement() {
        return gmsecJNI.ConfigFileIterator_HasNextCustomElement(this.swigCPtr, this);
    }

    public ConfigFile.ConfigEntry nextConfig() {
        long l = gmsecJNI.ConfigFileIterator_NextConfig(this.swigCPtr, this);
        return new ConfigFile.ConfigEntry(new JNIConfigEntry(l, false));
    }

    public ConfigFile.MessageEntry nextMessage() {
        long l = gmsecJNI.ConfigFileIterator_NextMessage(this.swigCPtr, this);
        return new ConfigFile.MessageEntry(new JNIMessageEntry(l, false));
    }

    public ConfigFile.SubscriptionEntry nextSubscription() {
        long l = gmsecJNI.ConfigFileIterator_NextSubscription(this.swigCPtr, this);
        return new ConfigFile.SubscriptionEntry(new JNISubscriptionEntry(l, false));
    }

    public String nextCustomElement() {
        return gmsecJNI.ConfigFileIterator_NextCustomElement(this.swigCPtr, this);
    }

    public void reset() {
        gmsecJNI.ConfigFileIterator_Reset(this.swigCPtr, this);
    }
}

