/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.jni;

import gov.nasa.gsfc.gmsec.api.Config;
import gov.nasa.gsfc.gmsec.api.GMSEC_Exception;
import gov.nasa.gsfc.gmsec.api.jni.JNILog;
import gov.nasa.gsfc.gmsec.api.jni.gmsecJNI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class JNIConfig {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected JNIConfig(long l, boolean bl) {
        this.swigCPtr = l;
        this.swigCMemOwn = bl;
        this.initLogging(gmsecJNI.Config_GetValue(this.swigCPtr, this, "logfile"));
    }

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            gmsecJNI.delete_Config(this.swigCPtr, this);
            this.swigCMemOwn = false;
        }
        this.swigCPtr = 0L;
    }

    public static long getCPtr(JNIConfig jNIConfig) {
        return jNIConfig == null ? 0L : jNIConfig.swigCPtr;
    }

    public JNIConfig() {
        this(gmsecJNI.new_Config(), true);
    }

    public JNIConfig(String[] stringArray) {
        this(gmsecJNI.new_Config_String(stringArray), true);
    }

    public JNIConfig(Config config) {
        this(gmsecJNI.new_Config_Copy(JNIConfig.getCPtr(Config.getInternal(config)), Config.getInternal(config)), true);
    }

    public JNIConfig(JNIConfig jNIConfig) {
        this(gmsecJNI.new_Config_Copy(JNIConfig.getCPtr(jNIConfig), jNIConfig), true);
    }

    public JNIConfig(String string) {
        this(gmsecJNI.new_Config(), true);
        gmsecJNI.Config_FromXML(this.swigCPtr, this, string);
    }

    public void addValue(String string, String string2) {
        gmsecJNI.Config_AddValue(this.swigCPtr, this, string, string2);
        if (string.equalsIgnoreCase("logfile")) {
            this.initLogging(string2);
        }
    }

    public boolean clearValue(String string) {
        return gmsecJNI.Config_ClearValue(this.swigCPtr, this, string);
    }

    public void clear() {
        gmsecJNI.Config_Clear(this.swigCPtr, this);
    }

    public Collection<Map.Entry<String, String>> entrySet() {
        HashSet<Map.Entry<String, String>> hashSet = new HashSet<Map.Entry<String, String>>();
        String[] stringArray = gmsecJNI.Config_KeySet(this.swigCPtr, this);
        String[] stringArray2 = gmsecJNI.Config_Values(this.swigCPtr, this);
        int n = 0;
        for (String string : stringArray) {
            AbstractMap.SimpleImmutableEntry<String, String> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<String, String>(string, stringArray2[n++]);
            hashSet.add(simpleImmutableEntry);
        }
        return hashSet;
    }

    public Collection<String> keySet() {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray = gmsecJNI.Config_KeySet(this.swigCPtr, this)) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public String getValue(String string) {
        return gmsecJNI.Config_GetValue(this.swigCPtr, this, string);
    }

    public String getValue(String string, String string2) {
        return gmsecJNI.Config_GetValue(this.swigCPtr, this, string, string2);
    }

    public boolean getBooleanValue(String string) throws GMSEC_Exception {
        boolean bl = false;
        bl = gmsecJNI.Config_GetBooleanValue(this.swigCPtr, this, string);
        return bl;
    }

    public boolean getBooleanValue(String string, boolean bl) {
        return gmsecJNI.Config_GetBooleanValue(this.swigCPtr, this, string, bl);
    }

    public int getIntegerValue(String string) {
        return gmsecJNI.Config_GetIntegerValue(this.swigCPtr, this, string);
    }

    public int getIntegerValue(String string, int n) {
        return gmsecJNI.Config_GetIntegerValue(this.swigCPtr, this, string, n);
    }

    public double getDoubleValue(String string) {
        return gmsecJNI.Config_GetDoubleValue(this.swigCPtr, this, string);
    }

    public double getDoubleValue(String string, double d) {
        return gmsecJNI.Config_GetDoubleValue(this.swigCPtr, this, string, d);
    }

    public void merge(Config config, boolean bl) {
        JNIConfig jNIConfig = Config.getInternal(config);
        gmsecJNI.Config_Merge(this.swigCPtr, this, JNIConfig.getCPtr(jNIConfig), jNIConfig, bl);
    }

    public String toXML() {
        return gmsecJNI.Config_ToXML(this.swigCPtr, this);
    }

    public void fromXML(String string) {
        gmsecJNI.Config_FromXML(this.swigCPtr, this, string);
    }

    private void initLogging(String string) {
        if (string != null) {
            JNILog.getDefaultLogHandler().setStream(string);
        }
    }
}

