/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api;

import gov.nasa.gsfc.gmsec.api.Config;
import gov.nasa.gsfc.gmsec.api.GMSEC_Exception;
import gov.nasa.gsfc.gmsec.api.MessageFieldIterator;
import gov.nasa.gsfc.gmsec.api.U16;
import gov.nasa.gsfc.gmsec.api.U32;
import gov.nasa.gsfc.gmsec.api.U64;
import gov.nasa.gsfc.gmsec.api.U8;
import gov.nasa.gsfc.gmsec.api.field.BinaryField;
import gov.nasa.gsfc.gmsec.api.field.BooleanField;
import gov.nasa.gsfc.gmsec.api.field.CharField;
import gov.nasa.gsfc.gmsec.api.field.F32Field;
import gov.nasa.gsfc.gmsec.api.field.F64Field;
import gov.nasa.gsfc.gmsec.api.field.Field;
import gov.nasa.gsfc.gmsec.api.field.I16Field;
import gov.nasa.gsfc.gmsec.api.field.I32Field;
import gov.nasa.gsfc.gmsec.api.field.I64Field;
import gov.nasa.gsfc.gmsec.api.field.I8Field;
import gov.nasa.gsfc.gmsec.api.field.StringField;
import gov.nasa.gsfc.gmsec.api.field.U16Field;
import gov.nasa.gsfc.gmsec.api.field.U32Field;
import gov.nasa.gsfc.gmsec.api.field.U64Field;
import gov.nasa.gsfc.gmsec.api.field.U8Field;
import gov.nasa.gsfc.gmsec.api.jni.JNIMessage;

public class Message {
    private JNIMessage m_jniMessage = null;

    public Message(JNIMessage jNIMessage) {
        this.m_jniMessage = jNIMessage;
    }

    public static JNIMessage getInternal(Message message) {
        return message == null ? null : message.m_jniMessage;
    }

    protected void registerChild(JNIMessage jNIMessage) {
        this.m_jniMessage = jNIMessage;
    }

    public Message(String string, MessageKind messageKind) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contains an empty string");
        }
        this.m_jniMessage = new JNIMessage(string, messageKind);
    }

    public Message(String string, MessageKind messageKind, Config config) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contains an empty string");
        }
        if (config == null) {
            throw new IllegalArgumentException("Config is null");
        }
        this.m_jniMessage = new JNIMessage(string, messageKind, config);
    }

    public Message(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("The XML/JSON string is null or contains an empty string");
        }
        this.m_jniMessage = new JNIMessage(string);
    }

    public Message(Message message) throws IllegalArgumentException {
        if (message == null) {
            throw new IllegalArgumentException("Message is null");
        }
        this.m_jniMessage = new JNIMessage(Message.getInternal(message));
    }

    public void addConfig(Config config) throws IllegalArgumentException {
        if (config == null) {
            throw new IllegalArgumentException("Config is null");
        }
        this.m_jniMessage.addConfig(config);
    }

    public Config getConfig() {
        return this.m_jniMessage.getConfig();
    }

    public String getSubject() {
        return this.m_jniMessage.getSubject();
    }

    public MessageKind getKind() {
        return this.m_jniMessage.getKind();
    }

    public boolean addField(Field field) throws IllegalArgumentException {
        if (field == null) {
            throw new IllegalArgumentException("Field is null");
        }
        return this.m_jniMessage.addField(field);
    }

    public boolean addField(String string, byte[] byArray) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Byte array is null");
        }
        return this.m_jniMessage.addField(string, byArray);
    }

    public boolean addField(String string, boolean bl) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.addField(string, bl);
    }

    public boolean addField(String string, char c) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.addField(string, c);
    }

    public boolean addField(String string, byte by) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.addField(string, by);
    }

    public boolean addField(String string, short s) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.addField(string, s);
    }

    public boolean addField(String string, int n) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.addField(string, n);
    }

    public boolean addField(String string, long l) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.addField(string, l);
    }

    public boolean addField(String string, U8 u8) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        if (u8 == null) {
            throw new IllegalArgumentException("U8 data object is null");
        }
        return this.m_jniMessage.addField(string, u8);
    }

    public boolean addField(String string, U16 u16) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        if (u16 == null) {
            throw new IllegalArgumentException("U16 data object is null");
        }
        return this.m_jniMessage.addField(string, u16);
    }

    public boolean addField(String string, U32 u32) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        if (u32 == null) {
            throw new IllegalArgumentException("U32 data object is null");
        }
        return this.m_jniMessage.addField(string, u32);
    }

    public boolean addField(String string, U64 u64) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        if (u64 == null) {
            throw new IllegalArgumentException("U64 data object is null");
        }
        return this.m_jniMessage.addField(string, u64);
    }

    public boolean addField(String string, float f) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.addField(string, f);
    }

    public boolean addField(String string, double d) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.addField(string, d);
    }

    public boolean addField(String string, String string2) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("Data value is null or contains an empty string");
        }
        return this.m_jniMessage.addField(string, string2);
    }

    public void clearFields() {
        this.m_jniMessage.clearFields();
    }

    public boolean clearField(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.clearField(string);
    }

    public long getIntegerValue(String string) throws GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.getIntegerValue(string);
    }

    public U64 getUnsignedIntegerValue(String string) throws GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.getUnsignedIntegerValue(string);
    }

    public double getDoubleValue(String string) throws GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.getDoubleValue(string);
    }

    public String getStringValue(String string) throws GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.getStringValue(string);
    }

    public Field getField(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.getField(string);
    }

    public Field.FieldType getFieldType(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.getFieldType(string);
    }

    public BinaryField getBinaryField(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.getBinaryField(string);
    }

    public BooleanField getBooleanField(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.getBooleanField(string);
    }

    public CharField getCharField(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.getCharField(string);
    }

    public F32Field getF32Field(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.getF32Field(string);
    }

    public F64Field getF64Field(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.getF64Field(string);
    }

    public I8Field getI8Field(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.getI8Field(string);
    }

    public I16Field getI16Field(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.getI16Field(string);
    }

    public I32Field getI32Field(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.getI32Field(string);
    }

    public I64Field getI64Field(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.getI64Field(string);
    }

    public U8Field getU8Field(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.getU8Field(string);
    }

    public U16Field getU16Field(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.getU16Field(string);
    }

    public U32Field getU32Field(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.getU32Field(string);
    }

    public U64Field getU64Field(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.getU64Field(string);
    }

    public StringField getStringField(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Field name is null or contains an empty string");
        }
        return this.m_jniMessage.getStringField(string);
    }

    public int getFieldCount() {
        return this.m_jniMessage.getFieldCount();
    }

    public void copyFields(Message message) throws IllegalArgumentException {
        if (message == null) {
            throw new IllegalArgumentException("Message object is null");
        }
        this.m_jniMessage.copyFields(Message.getInternal(message));
    }

    public String toXML() {
        return this.m_jniMessage.toXML();
    }

    public String toJSON() {
        return this.m_jniMessage.toJSON();
    }

    public long getSize() {
        return this.m_jniMessage.getSize();
    }

    public MessageFieldIterator getFieldIterator() {
        return this.m_jniMessage.getFieldIterator();
    }

    public MessageFieldIterator getFieldIterator(MessageFieldIterator.Selector selector) {
        return this.m_jniMessage.getFieldIterator(selector);
    }

    public static enum MessageKind {
        PUBLISH,
        REQUEST,
        REPLY;

    }
}

