/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api;

import gov.nasa.gsfc.gmsec.api.Callback;
import gov.nasa.gsfc.gmsec.api.Config;
import gov.nasa.gsfc.gmsec.api.EventCallback;
import gov.nasa.gsfc.gmsec.api.GMSEC_Exception;
import gov.nasa.gsfc.gmsec.api.Message;
import gov.nasa.gsfc.gmsec.api.ReplyCallback;
import gov.nasa.gsfc.gmsec.api.StatusClassification;
import gov.nasa.gsfc.gmsec.api.StatusCode;
import gov.nasa.gsfc.gmsec.api.SubscriptionInfo;
import gov.nasa.gsfc.gmsec.api.jni.JNIConnection;

public class Connection {
    private JNIConnection m_jniConnection = null;

    public static JNIConnection getInternal(Connection connection) {
        return connection == null ? null : connection.m_jniConnection;
    }

    public static void resetInternal(Connection connection) {
        if (connection != null) {
            connection.m_jniConnection = null;
        }
    }

    public Connection(JNIConnection jNIConnection) throws GMSEC_Exception {
        if (jNIConnection == null) {
            throw new GMSEC_Exception(StatusClassification.FACTORY_ERROR, StatusCode.UNINITIALIZED_OBJECT, "JNIConnection is null");
        }
        this.m_jniConnection = jNIConnection;
    }

    private Connection() {
    }

    public static Connection create(Config config) throws IllegalArgumentException, GMSEC_Exception {
        if (config == null) {
            throw new IllegalArgumentException("Config is null");
        }
        return JNIConnection.create(config);
    }

    public static void destroy(Connection connection) throws IllegalArgumentException {
        if (connection == null) {
            throw new IllegalArgumentException("Connection is null");
        }
        JNIConnection.destroy(connection);
        Connection.resetInternal(connection);
    }

    public static String getAPIVersion() {
        return JNIConnection.getAPIVersion();
    }

    public void connect() throws GMSEC_Exception {
        this.m_jniConnection.connect();
    }

    public void disconnect() {
        this.m_jniConnection.disconnect();
    }

    public ConnectionState getState() {
        return this.m_jniConnection.getState();
    }

    public String getLibraryRootName() {
        return this.m_jniConnection.getLibraryRootName();
    }

    public String getLibraryVersion() {
        return this.m_jniConnection.getLibraryVersion();
    }

    public void registerEventCallback(ConnectionEvent connectionEvent, EventCallback eventCallback) throws IllegalArgumentException {
        if (eventCallback == null) {
            throw new IllegalArgumentException("EventCallback is null");
        }
        this.m_jniConnection.registerEventCallback(connectionEvent, eventCallback);
    }

    public SubscriptionInfo subscribe(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contains an empty string");
        }
        return this.m_jniConnection.subscribe(string);
    }

    public SubscriptionInfo subscribe(String string, Callback callback) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contains an empty string");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Callback is null");
        }
        return this.m_jniConnection.subscribe(string, callback);
    }

    public SubscriptionInfo subscribe(String string, Config config) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contains an empty string");
        }
        if (config == null) {
            throw new IllegalArgumentException("Config is null");
        }
        return this.m_jniConnection.subscribe(string, config);
    }

    public SubscriptionInfo subscribe(String string, Config config, Callback callback) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contains an empty string");
        }
        if (config == null) {
            throw new IllegalArgumentException("Config is null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("Callback is null");
        }
        return this.m_jniConnection.subscribe(string, config, callback);
    }

    public void unsubscribe(SubscriptionInfo subscriptionInfo) throws IllegalArgumentException, GMSEC_Exception {
        if (subscriptionInfo == null) {
            throw new IllegalArgumentException("SubscriptionInfo is null");
        }
        this.m_jniConnection.unsubscribe(subscriptionInfo);
    }

    public boolean startAutoDispatch() {
        return this.m_jniConnection.startAutoDispatch();
    }

    public boolean stopAutoDispatch() {
        return this.m_jniConnection.stopAutoDispatch(true);
    }

    public boolean stopAutoDispatch(boolean bl) {
        return this.m_jniConnection.stopAutoDispatch(bl);
    }

    public void publish(Message message) throws IllegalArgumentException, GMSEC_Exception {
        if (message == null) {
            throw new IllegalArgumentException("Message is null");
        }
        this.m_jniConnection.publish(message);
    }

    public void publish(Message message, Config config) throws IllegalArgumentException, GMSEC_Exception {
        if (message == null) {
            throw new IllegalArgumentException("Message is null");
        }
        if (config == null) {
            throw new IllegalArgumentException("Config is null");
        }
        this.m_jniConnection.publish(message, config);
    }

    public void request(Message message, int n, ReplyCallback replyCallback, int n2) throws IllegalArgumentException, GMSEC_Exception {
        if (message == null) {
            throw new IllegalArgumentException("Request Message is null");
        }
        if (replyCallback == null) {
            throw new IllegalArgumentException("ReplyCallback is null");
        }
        this.m_jniConnection.request(message, n, replyCallback, n2);
    }

    public Message request(Message message, int n, int n2) throws IllegalArgumentException, GMSEC_Exception {
        if (message == null) {
            throw new IllegalArgumentException("Request Message is null");
        }
        return this.m_jniConnection.request(message, n, n2);
    }

    public void cancelRequest(ReplyCallback replyCallback) throws IllegalArgumentException {
        if (replyCallback == null) {
            throw new IllegalArgumentException("ReplyCallback is null");
        }
        this.m_jniConnection.cancelRequest(replyCallback);
    }

    public void reply(Message message, Message message2) throws IllegalArgumentException, GMSEC_Exception {
        if (message == null) {
            throw new IllegalArgumentException("Request Message is null");
        }
        if (message2 == null) {
            throw new IllegalArgumentException("Reply Message is null");
        }
        this.m_jniConnection.reply(message, message2);
    }

    public void dispatch(Message message) throws IllegalArgumentException, GMSEC_Exception {
        if (message == null) {
            throw new IllegalArgumentException("Message is null");
        }
        this.m_jniConnection.dispatch(message);
    }

    public Message receive() throws GMSEC_Exception {
        return this.receive(-1);
    }

    public Message receive(int n) throws GMSEC_Exception {
        return this.m_jniConnection.receive(n);
    }

    public void excludeSubject(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contains an empty string");
        }
        this.m_jniConnection.excludeSubject(string);
    }

    public void removeExcludedSubject(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject is null or contains an empty string");
        }
        this.m_jniConnection.removeExcludedSubject(string);
    }

    public String getName() {
        return this.m_jniConnection.getName();
    }

    public void setName(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Name is null or contains an empty string");
        }
        this.m_jniConnection.setName(string);
    }

    public String getID() {
        return this.m_jniConnection.getID();
    }

    public String getMWInfo() {
        return this.m_jniConnection.getMWInfo();
    }

    public long getPublishQueueMessageCount() {
        return this.m_jniConnection.getPublishQueueMessageCount();
    }

    public static void shutdownAllMiddlewares() {
        JNIConnection.shutdownAllMiddlewares();
    }

    public static void shutdownMiddleware(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Name is null or contains an empty string");
        }
        JNIConnection.shutdownMiddleware(string);
    }

    public static enum ConnectionEvent {
        DISPATCHER_ERROR_EVENT,
        REQUEST_TIMEOUT_EVENT,
        CONNECTION_SUCCESSFUL_EVENT,
        CONNECTION_BROKEN_EVENT,
        CONNECTION_RECONNECT_EVENT,
        CONNECTION_EXCEPTION_EVENT,
        GMD_ERROR_EVENT,
        WSMQ_ASYNC_STATUS_CHECK_EVENT,
        ALL_EVENTS,
        MSG_PUBLISH_FAILURE_EVENT;

    }

    public static enum ConnectionState {
        NOT_CONNECTED,
        CONNECTED,
        RECONNECTING;

    }
}

