/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api;

import gov.nasa.gsfc.gmsec.api.Config;
import gov.nasa.gsfc.gmsec.api.ConfigFileIterator;
import gov.nasa.gsfc.gmsec.api.GMSEC_Exception;
import gov.nasa.gsfc.gmsec.api.Message;
import gov.nasa.gsfc.gmsec.api.jni.JNIConfigEntry;
import gov.nasa.gsfc.gmsec.api.jni.JNIConfigFile;
import gov.nasa.gsfc.gmsec.api.jni.JNIMessageEntry;
import gov.nasa.gsfc.gmsec.api.jni.JNISubscriptionEntry;

public class ConfigFile {
    private JNIConfigFile m_jniConfigFile = null;

    public static JNIConfigFile getInternal(ConfigFile configFile) {
        return configFile == null ? null : configFile.m_jniConfigFile;
    }

    public ConfigFile(JNIConfigFile jNIConfigFile) {
        this.m_jniConfigFile = jNIConfigFile;
    }

    public ConfigFile() {
        this.m_jniConfigFile = new JNIConfigFile();
    }

    public void load(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("File Path is null or contains an empty string");
        }
        this.m_jniConfigFile.load(string);
    }

    public void save() throws GMSEC_Exception {
        this.save(null, false);
    }

    public void save(String string) throws IllegalArgumentException, GMSEC_Exception {
        this.save(string, false);
    }

    public void save(String string, boolean bl) throws IllegalArgumentException, GMSEC_Exception {
        if (string != null && string.isEmpty()) {
            throw new IllegalArgumentException("File Path contains an empty string");
        }
        this.m_jniConfigFile.save(string, bl);
    }

    public void fromXML(String string) throws GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("XML string is null or contains an empty string");
        }
        this.m_jniConfigFile.fromXML(string);
    }

    public String toXML() {
        return this.m_jniConfigFile.toXML();
    }

    public boolean isLoaded() {
        return this.m_jniConfigFile.isLoaded();
    }

    public Config lookupConfig(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Config name is null or contains an empty string");
        }
        return this.m_jniConfigFile.lookupConfig(string);
    }

    public Message lookupMessage(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Message name is null or contains an empty string");
        }
        return this.m_jniConfigFile.lookupMessage(string);
    }

    public String lookupSubscription(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subscription name is null or contains an empty string");
        }
        return this.m_jniConfigFile.lookupSubscription(string);
    }

    public void addSubscription(String string, String string2) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subscription name is null or contain an empty string");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("Subscription subject is null or contain an empty string");
        }
        this.m_jniConfigFile.addSubscription(string, string2);
    }

    public void addConfig(String string, Config config) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Config name is null or contains an empty string");
        }
        if (config == null) {
            throw new IllegalArgumentException("Config object handle is null");
        }
        this.m_jniConfigFile.addConfig(string, config);
    }

    public void addMessage(String string, Message message) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Message name is null or contains an empty string");
        }
        if (message == null) {
            throw new IllegalArgumentException("Message object handle is null");
        }
        this.m_jniConfigFile.addMessage(string, message);
    }

    public void addCustomXML(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Custom XML string is null or contains an empty string");
        }
        this.m_jniConfigFile.addCustomXML(string);
    }

    public boolean removeSubscription(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subscription name is null or contains an empty string");
        }
        return this.m_jniConfigFile.removeSubscription(string);
    }

    public boolean removeConfig(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Config name is null or contains an empty string");
        }
        return this.m_jniConfigFile.removeConfig(string);
    }

    public boolean removeMessage(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Message name is null or contains an empty string");
        }
        return this.m_jniConfigFile.removeMessage(string);
    }

    public boolean removeCustomXML(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Custom XML string is null or contains an empty string");
        }
        return this.m_jniConfigFile.removeCustomXML(string);
    }

    public ConfigFileIterator getIterator() {
        return this.m_jniConfigFile.getIterator();
    }

    public static class SubscriptionEntry {
        private JNISubscriptionEntry m_jniEntry = null;

        public SubscriptionEntry(JNISubscriptionEntry jNISubscriptionEntry) {
            this.m_jniEntry = jNISubscriptionEntry;
        }

        public String getName() {
            return this.m_jniEntry.getName();
        }

        public String getSubject() {
            return this.m_jniEntry.getSubject();
        }
    }

    public static class MessageEntry {
        private JNIMessageEntry m_jniEntry = null;

        public MessageEntry(JNIMessageEntry jNIMessageEntry) {
            this.m_jniEntry = jNIMessageEntry;
        }

        public String getName() {
            return this.m_jniEntry.getName();
        }

        public Message getMessage() {
            return this.m_jniEntry.getMessage();
        }
    }

    public static class ConfigEntry {
        private JNIConfigEntry m_jniEntry = null;

        public ConfigEntry(JNIConfigEntry jNIConfigEntry) {
            this.m_jniEntry = jNIConfigEntry;
        }

        public String getName() {
            return this.m_jniEntry.getName();
        }

        public Config getConfig() {
            return this.m_jniEntry.getConfig();
        }
    }
}

