/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api;

import gov.nasa.gsfc.gmsec.api.GMSEC_Exception;
import gov.nasa.gsfc.gmsec.api.jni.JNIConfig;
import java.util.Collection;
import java.util.Map;

public class Config {
    private JNIConfig m_jniConfig = null;

    public static JNIConfig getInternal(Config config) {
        return config == null ? null : config.m_jniConfig;
    }

    public Config(JNIConfig jNIConfig) {
        this.m_jniConfig = jNIConfig;
    }

    public Config() {
        this.m_jniConfig = new JNIConfig();
    }

    public Config(String[] stringArray) {
        this.m_jniConfig = new JNIConfig(stringArray);
    }

    public Config(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("XML string is null or contains an empty string");
        }
        this.m_jniConfig = new JNIConfig(string);
    }

    public Config(Config config) {
        this.m_jniConfig = config != null ? new JNIConfig(config.m_jniConfig) : new JNIConfig();
    }

    public void addValue(String string, String string2) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Key is null or contains an empty string");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Value is null");
        }
        this.m_jniConfig.addValue(string, string2);
    }

    public boolean clearValue(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Key is null or contains an empty string");
        }
        return this.m_jniConfig.clearValue(string);
    }

    public void clear() {
        this.m_jniConfig.clear();
    }

    public Collection<Map.Entry<String, String>> entrySet() {
        return this.m_jniConfig.entrySet();
    }

    public Collection<String> keySet() {
        return this.m_jniConfig.keySet();
    }

    public String getValue(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Key is null or contains an empty string");
        }
        return this.m_jniConfig.getValue(string);
    }

    public String getValue(String string, String string2) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Key is null or contains an empty string");
        }
        return this.m_jniConfig.getValue(string, string2);
    }

    public boolean getBooleanValue(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Key is null or contains an empty string");
        }
        return this.m_jniConfig.getBooleanValue(string);
    }

    public boolean getBooleanValue(String string, boolean bl) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Key is null or contains an empty string");
        }
        return this.m_jniConfig.getBooleanValue(string, bl);
    }

    public int getIntegerValue(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Key is null or contains an empty string");
        }
        return this.m_jniConfig.getIntegerValue(string);
    }

    public int getIntegerValue(String string, int n) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Key is null or contains an empty string");
        }
        return this.m_jniConfig.getIntegerValue(string, n);
    }

    public double getDoubleValue(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Key is null or contains an empty string");
        }
        return this.m_jniConfig.getDoubleValue(string);
    }

    public double getDoubleValue(String string, double d) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Key is null or contains an empty string");
        }
        return this.m_jniConfig.getDoubleValue(string, d);
    }

    public String toXML() {
        return this.m_jniConfig.toXML();
    }

    public void merge(Config config, boolean bl) {
        this.m_jniConfig.merge(config, bl);
    }

    public void fromXML(String string) throws IllegalArgumentException, GMSEC_Exception {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("XML string is null or contains an empty string");
        }
        this.m_jniConfig.fromXML(string);
    }
}

