/*
 * Decompiled with CFR 0.152.
 */
package bolt;

import bolt.Header;
import bolt.Log;
import bolt.Message;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Unpacker {
    private static Logger source = Log.createSource("Unpacker");
    private ByteBuffer headerBuffer = ByteBuffer.allocate(8);
    private ByteBuffer messageBuffer = null;
    private Message message = null;
    private Target target;

    public Unpacker(Target target) {
        this.target = target;
    }

    public boolean ingest(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            int n4 = n3 - n;
            int n5 = 0;
            if (this.messageBuffer != null) {
                if (n4 < this.messageBuffer.remaining()) {
                    n5 = n4;
                    this.messageBuffer.put(byArray, n, n5);
                } else {
                    n5 = this.messageBuffer.remaining();
                    this.messageBuffer.put(byArray, n, n5);
                    this.messageBuffer.flip();
                    this.headerBuffer = ByteBuffer.allocate(8);
                    this.messageBuffer = null;
                    if (source.isLoggable(Level.FINER)) {
                        this.message.dump("Unpacker: received body, consuming", System.out);
                    }
                    this.target.consume(this.message);
                }
            } else if (n4 < this.headerBuffer.remaining()) {
                n5 = n4;
                this.headerBuffer.put(byArray, n, n5);
            } else {
                n5 = this.headerBuffer.remaining();
                this.headerBuffer.put(byArray, n, n5);
                this.headerBuffer.flip();
                Header header = Header.parse(this.headerBuffer);
                if (header == null) {
                    return false;
                }
                if (!this.target.isAcceptable(header)) {
                    return false;
                }
                this.message = Message.create(header, this.headerBuffer);
                if (header.getSize() == 0) {
                    if (source.isLoggable(Level.FINER)) {
                        this.message.dump("Unpacker: received header and size=0 so consuming", System.out);
                    }
                    this.headerBuffer = ByteBuffer.allocate(8);
                    this.target.consume(this.message);
                } else {
                    this.messageBuffer = this.message.getBuffer();
                }
            }
            n += n5;
        }
        return true;
    }

    public static interface Target {
        public void consume(Message var1);

        public boolean isAcceptable(Header var1);
    }
}

