/*
 * Decompiled with CFR 0.152.
 */
package bolt;

public class Topic {
    private static final boolean ALLOW_LOWERCASE = true;
    static boolean[] validTopicChar;

    public static boolean isValid(String string) {
        return Topic.areValidElements(Topic.getElements(string), false);
    }

    public static boolean isValidSubscription(String string) {
        return Topic.areValidElements(Topic.getElements(string), true);
    }

    public static String[] getElements(String string) {
        return string.split("\\.", -1);
    }

    public static boolean areValidElements(String[] stringArray, boolean bl) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (Topic.isValidElement(stringArray[i], bl, i == stringArray.length - 1)) continue;
            return false;
        }
        return true;
    }

    static boolean isValidElement(String string, boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (string.length() < 1) {
            bl3 = false;
        } else if (bl && bl2 && (string.equals(">") || string.equals("+"))) {
            bl3 = true;
        } else if (bl && string.equals("*")) {
            bl3 = true;
        } else {
            bl3 = true;
            for (char c : string.toCharArray()) {
                if (Topic.isValidCharacter(c)) continue;
                bl3 = false;
            }
        }
        return bl3;
    }

    static boolean isValidCharacter(char c) {
        if (c >= '\u0000' && c < validTopicChar.length) {
            return validTopicChar[c];
        }
        return false;
    }

    static void test(String string) {
        boolean bl = Topic.isValid(string);
        System.out.println("test(" + string + ") => " + bl);
    }

    static void test(String string, boolean bl) {
        boolean bl2 = Topic.isValid(string);
        System.out.println("test(" + string + ") => " + bl2);
        if (bl2 != bl) {
            System.out.println("WRONG");
        }
    }

    static void test() {
        Topic.test("A.B", true);
        Topic.test("AB.", false);
        Topic.test("A>", false);
        Topic.test(">A", false);
        Topic.test(">.A", false);
        Topic.test("..", false);
        Topic.test("*.A", true);
        Topic.test("A.*.B", true);
        Topic.test("A.**.B", false);
        Topic.test("A.>.B", false);
        Topic.test("a.>", false);
        Topic.test("HELLo", false);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            for (String string : stringArray) {
                Topic.test(string);
            }
        } else {
            Topic.test();
        }
    }

    static {
        int n;
        validTopicChar = new boolean[128];
        for (n = 0; n < 10; ++n) {
            Topic.validTopicChar[48 + n] = true;
        }
        for (n = 0; n < 26; ++n) {
            Topic.validTopicChar[65 + n] = true;
        }
        Topic.validTopicChar[45] = true;
        Topic.validTopicChar[95] = true;
        for (n = 0; n < 26; ++n) {
            Topic.validTopicChar[97 + n] = true;
        }
    }
}

