/*
 * Decompiled with CFR 0.152.
 */
package bolt;

import bolt.Client;
import bolt.Header;
import bolt.MessageType;
import bolt.Meta;
import bolt.Property;
import java.io.PrintStream;
import java.nio.ByteBuffer;

public class Message {
    private Header header;
    private Meta meta;
    private ByteBuffer buffer;
    private byte[] body;
    private Client client;
    long rxTime;
    long txTime;
    long procTime;
    long distTime;

    Message() {
    }

    public Message(Header header, Meta meta, byte[] byArray) {
        this.header = header;
        this.meta = meta;
        this.body = byArray;
    }

    public Header getHeader() {
        return this.header;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    void setClient(Client client) {
        this.client = client;
    }

    Client getClient() {
        return this.client;
    }

    public static Message create(Header header, ByteBuffer byteBuffer) {
        assert (byteBuffer.capacity() == 8);
        Message message = new Message();
        message.header = header;
        message.buffer = ByteBuffer.allocate(8 + header.getSize());
        message.buffer.put(byteBuffer.array(), 0, 8);
        return message;
    }

    public void dump(String string, PrintStream printStream) {
        printStream.println(string);
        if (this.header != null) {
            this.header.dump("header:", printStream);
        } else {
            printStream.println("header: null");
        }
        if (this.meta != null) {
            this.meta.dump("meta:", printStream);
        } else {
            printStream.println("meta: null");
        }
        if (this.body != null) {
            printStream.println("body: size=" + this.body.length);
        } else {
            printStream.println("body: null");
        }
        if (this.buffer != null) {
            printStream.println("buffer: capacity=" + this.buffer.capacity() + " position=" + this.buffer.position() + " remaining=" + this.buffer.remaining());
        } else {
            printStream.println("buffer: null");
        }
    }

    public synchronized ByteBuffer getEncoded() {
        if (this.buffer == null) {
            this.encode();
        }
        return this.buffer;
    }

    private ByteBuffer encode() {
        int n = 0;
        int n2 = 0;
        if (this.meta != null) {
            n += this.meta.determineSize();
            n2 |= 1;
        }
        if (this.body != null) {
            n += this.body.length;
            n2 |= 2;
        }
        this.header.setSize(n);
        this.header.setFlags(n2);
        this.buffer = ByteBuffer.allocate(8 + n);
        this.header.put(this.buffer);
        if (this.meta != null) {
            this.meta.put(this.buffer);
        }
        if (this.body != null) {
            this.buffer.put(this.body);
        }
        this.buffer.flip();
        return this.buffer;
    }

    private static byte[] copyOfRange(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, Math.min(byArray.length - n, n3));
        return byArray2;
    }

    public void decode() {
        assert (this.buffer != null);
        assert (this.header != null);
        assert (this.meta == null);
        assert (this.body == null);
        this.buffer.position(8);
        if (this.header.hasMeta()) {
            this.meta = new Meta();
            this.meta.parse(this.buffer);
        }
        if (this.buffer.remaining() > 0) {
            int n = this.buffer.position();
            int n2 = this.buffer.capacity();
            this.body = Message.copyOfRange(this.buffer.array(), n, n2);
        }
    }

    public Message makeAck() {
        Object object;
        Header header = new Header(MessageType.ACK);
        Meta meta = null;
        if (this.meta != null && (object = this.meta.getID()) != null) {
            meta = new Meta();
            meta.addProperty(Property.createID((String)object));
        }
        object = new Message(header, meta, null);
        return object;
    }
}

