/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsecapi.mist;

import gov.nasa.gsfc.gmsecapi.Config;
import gov.nasa.gsfc.gmsecapi.Field;
import gov.nasa.gsfc.gmsecapi.Message;
import gov.nasa.gsfc.gmsecapi.Status;
import gov.nasa.gsfc.gmsecapi.jni.JNIConnectionManager;
import gov.nasa.gsfc.gmsecapi.mist.ConnectionManagerCallback;
import gov.nasa.gsfc.gmsecapi.mist.ConnectionManagerErrorCallback;
import gov.nasa.gsfc.gmsecapi.mist.ConnectionManagerReplyCallback;

public class ConnectionManager {
    private JNIConnectionManager m_jniConnMgr = null;

    public ConnectionManager(Config config, int n, boolean bl) {
        if (config != null) {
            this.m_jniConnMgr = new JNIConnectionManager(this, config, n, bl);
        }
    }

    public ConnectionManager(Config config) {
        if (config != null) {
            this.m_jniConnMgr = new JNIConnectionManager(this, config);
        }
    }

    public Status SetStandardFields(Field[] fieldArray) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (fieldArray == null || fieldArray.length == 0) {
            return new Status(1001, 1011L, "Standard Field is null or is empty");
        }
        return this.m_jniConnMgr.SetStandardFields(fieldArray);
    }

    public Status Initialize() {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        return this.m_jniConnMgr.Initialize();
    }

    public Status Cleanup() {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        return this.m_jniConnMgr.Cleanup();
    }

    public Status RegisterErrorCallback(String string, ConnectionManagerErrorCallback connectionManagerErrorCallback) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (string == null) {
            return new Status(1001, 1011L, "Event string is null");
        }
        if (connectionManagerErrorCallback == null) {
            return new Status(1001, 1011L, "Error Callback is null");
        }
        return this.m_jniConnMgr.RegisterErrorCallback(string, connectionManagerErrorCallback);
    }

    public Status Subscribe(String string) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (string == null) {
            return new Status(1001, 1011L, "Subject string is null");
        }
        return this.m_jniConnMgr.Subscribe(string);
    }

    public Status Subscribe(String string, ConnectionManagerCallback connectionManagerCallback) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (string == null) {
            return new Status(1001, 1011L, "Subject string is null");
        }
        if (connectionManagerCallback == null) {
            return new Status(1001, 1011L, "Callback is null");
        }
        return this.m_jniConnMgr.Subscribe(string, connectionManagerCallback);
    }

    public Status Subscribe(String string, Config config) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (string == null) {
            return new Status(1001, 1011L, "Subject string is null");
        }
        if (config == null) {
            return new Status(1001, 1011L, "Config is null");
        }
        return this.m_jniConnMgr.Subscribe(string, config);
    }

    public Status UnSubscribe(String string) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (string == null) {
            return new Status(1001, 1011L, "Subject string is null");
        }
        return this.m_jniConnMgr.UnSubscribe(string);
    }

    public Status UnSubscribe(String string, ConnectionManagerCallback connectionManagerCallback) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (string == null) {
            return new Status(1001, 1011L, "Subject string is null");
        }
        if (connectionManagerCallback == null) {
            return new Status(1001, 1011L, "Callback is null");
        }
        return this.m_jniConnMgr.UnSubscribe(string, connectionManagerCallback);
    }

    public Status CreateMessage(String string, int n, Message message) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (string == null) {
            return new Status(1001, 1011L, "Subject string is null");
        }
        if (message == null) {
            return new Status(1001, 1011L, "Message is null");
        }
        return this.m_jniConnMgr.CreateMessage(string, n, message);
    }

    public Status ConvertMessage(Message message, Message message2) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (message == null) {
            return new Status(1001, 1011L, "In-Message is null");
        }
        if (message2 == null) {
            return new Status(1001, 1011L, "Out-Message is null");
        }
        return this.m_jniConnMgr.ConvertMessage(message, message2);
    }

    public Status ConvertCleanup(Message message, Message message2) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (message == null) {
            return new Status(1001, 1011L, "In-Message is null");
        }
        if (message2 == null) {
            return new Status(1001, 1011L, "Out-Message is null");
        }
        return this.m_jniConnMgr.ConvertCleanup(message, message2);
    }

    public Status CloneMessage(Message message, Message message2) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (message == null) {
            return new Status(1001, 1011L, "In-Message is null");
        }
        if (message2 == null) {
            return new Status(1001, 1011L, "Out-Message is null");
        }
        return this.m_jniConnMgr.CloneMessage(message, message2);
    }

    public Status DestroyMessage(Message message) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (message == null) {
            return new Status(1001, 1011L, "Message is null");
        }
        return this.m_jniConnMgr.DestroyMessage(message);
    }

    public Status Publish(Message message) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (message == null) {
            return new Status(1001, 1011L, "Message is null");
        }
        return this.m_jniConnMgr.Publish(message);
    }

    public Status Publish(Message message, Config config) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (message == null) {
            return new Status(1001, 1011L, "Message is null");
        }
        if (config == null) {
            return new Status(1001, 1011L, "Config is null");
        }
        return this.m_jniConnMgr.Publish(message, config);
    }

    public Status Request(Message message, int n, ConnectionManagerReplyCallback connectionManagerReplyCallback) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (message == null) {
            return new Status(1001, 1011L, "Request message is null");
        }
        if (connectionManagerReplyCallback == null) {
            return new Status(1001, 1011L, "Reply Callback is null");
        }
        return this.m_jniConnMgr.Request(message, n, connectionManagerReplyCallback);
    }

    public Status Request(Message message, int n, Message message2) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (message == null) {
            return new Status(1001, 1011L, "Request message is null");
        }
        if (message2 == null) {
            return new Status(1001, 1011L, "Reply message is null");
        }
        return this.m_jniConnMgr.Request(message, n, message2);
    }

    public Status Reply(Message message, Message message2) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (message == null) {
            return new Status(1001, 1011L, "Request message is null");
        }
        if (message2 == null) {
            return new Status(1001, 1011L, "Reply message is null");
        }
        return this.m_jniConnMgr.Reply(message, message2);
    }

    public Status StartAutoDispatch() {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        return this.m_jniConnMgr.StartAutoDispatch();
    }

    public Status StopAutoDispatch() {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        return this.m_jniConnMgr.StopAutoDispatch();
    }

    public Status StopAutoDispatch(boolean bl) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        return this.m_jniConnMgr.StopAutoDispatch(bl);
    }

    public Status GetNextMsg(Message message, int n) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (message == null) {
            return new Status(1001, 1011L, "Message is null");
        }
        return this.m_jniConnMgr.GetNextMsg(message, n);
    }

    public Status DispatchMsg(Message message) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (message == null) {
            return new Status(1001, 1011L, "Message is null");
        }
        return this.m_jniConnMgr.DispatchMsg(message);
    }

    public Status GetLastDispatcherStatus() {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        return this.m_jniConnMgr.GetLastDispatcherStatus();
    }

    public Status ExcludeSubject(String string) {
        if (this.m_jniConnMgr == null) {
            return new Status(2, 35L, "Connection not initialized");
        }
        return this.m_jniConnMgr.ExcludeSubject(string);
    }

    public Status RemoveExcludedSubject(String string) {
        if (this.m_jniConnMgr == null) {
            return new Status(2, 35L, "Connection not initialized");
        }
        return this.m_jniConnMgr.RemoveExcludedSubject(string);
    }

    public Status GetHeartbeatMessage(Field[] fieldArray, Message message, String string) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (message == null) {
            return new Status(1001, 1011L, "Message is null");
        }
        if (string == null) {
            return new Status(1001, 1011L, "Subject string is null");
        }
        return this.m_jniConnMgr.GetHeartbeatMessage(fieldArray, message, string);
    }

    public Status StartHeartbeatService(Field[] fieldArray, String string) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (string == null) {
            return new Status(1001, 1011L, "Subject string is null");
        }
        return this.m_jniConnMgr.StartHeartbeatService(fieldArray, string);
    }

    public Status ChangeComponentStatus(Field field) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (field == null) {
            return new Status(1001, 1011L, "Component Status field is null");
        }
        return this.m_jniConnMgr.ChangeComponentStatus(field);
    }

    public Status ChangeComponentInfo(Field field) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (field == null) {
            return new Status(1001, 1011L, "Component Info field is null");
        }
        return this.m_jniConnMgr.ChangeComponentInfo(field);
    }

    public Status ChangeCPUMemory(Field field) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (field == null) {
            return new Status(1001, 1011L, "CPU Memory field is null");
        }
        return this.m_jniConnMgr.ChangeCPUMemory(field);
    }

    public Status ChangeCPUUtil(Field field) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (field == null) {
            return new Status(1001, 1011L, "CPU Util field is null");
        }
        return this.m_jniConnMgr.ChangeCPUUtil(field);
    }

    public Status StopHeartbeatService() {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        return this.m_jniConnMgr.StopHeartbeatService();
    }

    public Status GetLogMessage(Field[] fieldArray, Message message, String string) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (message == null) {
            return new Status(1001, 1011L, "Message is null");
        }
        if (string == null) {
            return new Status(1001, 1011L, "Subject string is null");
        }
        return this.m_jniConnMgr.GetLogMessage(fieldArray, message, string);
    }

    public Status SetLoggingDefaults(Field[] fieldArray, String string) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (string == null) {
            return new Status(1001, 1011L, "Subject string is null");
        }
        return this.m_jniConnMgr.SetLoggingDefaults(fieldArray, string);
    }

    public Status QuickLog(String string, Field field) {
        if (this.m_jniConnMgr == null) {
            return new Status(1001, 29L, "ConnectionManager has not been properly initialized");
        }
        if (string == null) {
            return new Status(1001, 1011L, "Message is null");
        }
        if (field == null) {
            return new Status(1001, 1011L, "Severity field is null");
        }
        return this.m_jniConnMgr.QuickLog(string, field);
    }
}

