/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsecapi.jni;

import gov.nasa.gsfc.gmsecapi.Config;
import gov.nasa.gsfc.gmsecapi.Field;
import gov.nasa.gsfc.gmsecapi.GMSEC_U16;
import gov.nasa.gsfc.gmsecapi.GMSEC_UShort;
import gov.nasa.gsfc.gmsecapi.Message;
import gov.nasa.gsfc.gmsecapi.Status;
import gov.nasa.gsfc.gmsecapi.internal.MessageImpl;
import gov.nasa.gsfc.gmsecapi.jni.JNIConfig;
import gov.nasa.gsfc.gmsecapi.jni.JNIField;
import gov.nasa.gsfc.gmsecapi.jni.JNIMessage;
import gov.nasa.gsfc.gmsecapi.jni.JNIStatus;
import gov.nasa.gsfc.gmsecapi.jni.gmsecJNI;
import gov.nasa.gsfc.gmsecapi.mist.ConnectionManager;
import gov.nasa.gsfc.gmsecapi.mist.ConnectionManagerCallback;
import gov.nasa.gsfc.gmsecapi.mist.ConnectionManagerErrorCallback;
import gov.nasa.gsfc.gmsecapi.mist.ConnectionManagerReplyCallback;

public class JNIConnectionManager {
    private ConnectionManager extConnMgr;
    public long swigCPtr;
    public boolean swigCMemOwn;
    private long[] m_fieldPtrs = null;
    private JNIField[] m_jniFields = null;
    private int m_fieldCount = 0;

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            gmsecJNI.delete_ConnectionManager(this.swigCPtr, this);
            this.swigCMemOwn = false;
        }
        this.swigCPtr = 0L;
    }

    protected static long getCPtr(JNIConnectionManager jNIConnectionManager) {
        return jNIConnectionManager == null ? 0L : jNIConnectionManager.swigCPtr;
    }

    public JNIConnectionManager(ConnectionManager connectionManager, Config config, int n, boolean bl) {
        this.extConnMgr = connectionManager;
        JNIConfig jNIConfig = Config.getInternal(config);
        this.swigCPtr = gmsecJNI.new_ConnectionManager(JNIConfig.getCPtr(jNIConfig), jNIConfig, n, bl);
        this.swigCMemOwn = this.swigCPtr != 0L;
    }

    public JNIConnectionManager(ConnectionManager connectionManager, Config config) {
        this.extConnMgr = connectionManager;
        JNIConfig jNIConfig = Config.getInternal(config);
        this.swigCPtr = gmsecJNI.new_ConnectionManager(JNIConfig.getCPtr(jNIConfig), jNIConfig);
        this.swigCMemOwn = this.swigCPtr != 0L;
    }

    public Status SetStandardFields(Field[] fieldArray) {
        this.getValidFields(fieldArray);
        long l = gmsecJNI.ConnectionManager_SetStandardFields(this.swigCPtr, this, this.m_fieldPtrs, this.m_jniFields, this.m_fieldCount);
        return new JNIStatus(l, true);
    }

    public Status Initialize() {
        long l = gmsecJNI.ConnectionManager_Initialize(this.swigCPtr, this);
        return new JNIStatus(l, true);
    }

    public Status Cleanup() {
        long l = gmsecJNI.ConnectionManager_Cleanup(this.swigCPtr, this);
        return new JNIStatus(l, true);
    }

    public Status RegisterErrorCallback(String string, ConnectionManagerErrorCallback connectionManagerErrorCallback) {
        long l = gmsecJNI.ConnectionManager_RegisterErrorCallback(this.swigCPtr, this, string, connectionManagerErrorCallback);
        return new JNIStatus(l, true);
    }

    public Status Subscribe(String string) {
        long l = gmsecJNI.ConnectionManager_Subscribe(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }

    public Status Subscribe(String string, ConnectionManagerCallback connectionManagerCallback) {
        long l = gmsecJNI.ConnectionManager_Subscribe(this.swigCPtr, this, string, connectionManagerCallback);
        return new JNIStatus(l, true);
    }

    public Status Subscribe(String string, Config config) {
        JNIConfig jNIConfig = Config.getInternal(config);
        long l = gmsecJNI.ConnectionManager_Subscribe(this.swigCPtr, this, string, JNIConfig.getCPtr(jNIConfig), jNIConfig);
        return new JNIStatus(l, true);
    }

    public Status UnSubscribe(String string) {
        long l = gmsecJNI.ConnectionManager_UnSubscribe(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }

    public Status UnSubscribe(String string, ConnectionManagerCallback connectionManagerCallback) {
        long l = gmsecJNI.ConnectionManager_UnSubscribe(this.swigCPtr, this, string, connectionManagerCallback);
        return new JNIStatus(l, true);
    }

    public Status CreateMessage(String string, int n, Message message) {
        JNIMessage jNIMessage = new JNIMessage();
        long l = gmsecJNI.ConnectionManager_CreateMessage(this.swigCPtr, this, string, n, jNIMessage);
        message.SetImpl(jNIMessage);
        return new JNIStatus(l, true);
    }

    public Status ConvertMessage(Message message, Message message2) {
        JNIMessage jNIMessage = (JNIMessage)message.GetImpl();
        JNIMessage jNIMessage2 = (JNIMessage)message2.GetImpl();
        long l = gmsecJNI.ConnectionManager_ConvertMessage(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage, JNIMessage.getCPtr(jNIMessage2), jNIMessage2);
        message2.SetImpl(jNIMessage2);
        return new JNIStatus(l, true);
    }

    public Status ConvertCleanup(Message message, Message message2) {
        JNIMessage jNIMessage = (JNIMessage)message.GetImpl();
        JNIMessage jNIMessage2 = (JNIMessage)message2.GetImpl();
        long l = gmsecJNI.ConnectionManager_ConvertCleanup(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage, JNIMessage.getCPtr(jNIMessage2), jNIMessage2);
        message2.SetImpl(jNIMessage2);
        return new JNIStatus(l, true);
    }

    public Status CloneMessage(Message message, Message message2) {
        JNIMessage jNIMessage = (JNIMessage)message.GetImpl();
        JNIMessage jNIMessage2 = (JNIMessage)message2.GetImpl();
        long l = gmsecJNI.ConnectionManager_CloneMessage(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage, JNIMessage.getCPtr(jNIMessage2), jNIMessage2);
        message2.SetImpl(jNIMessage2);
        return new JNIStatus(l, true);
    }

    public Status DestroyMessage(Message message) {
        MessageImpl messageImpl = message.GetImpl();
        if (messageImpl instanceof JNIMessage) {
            JNIMessage jNIMessage = (JNIMessage)messageImpl;
            if (jNIMessage.swigCMemOwn) {
                long l = gmsecJNI.ConnectionManager_DestroyMessage(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage);
                jNIMessage.swigCPtr = 0L;
                jNIMessage.swigCMemOwn = false;
                message.SetImpl(null);
                return new JNIStatus(l, true);
            }
            return new Status(2, 7L, "Message not owned");
        }
        return new Status(5, 7L, "Message is of invalid type.");
    }

    public Status Publish(Message message) {
        MessageImpl messageImpl = message.GetImpl();
        if (messageImpl instanceof JNIMessage) {
            JNIMessage jNIMessage = (JNIMessage)messageImpl;
            long l = gmsecJNI.ConnectionManager_Publish(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage);
            return new JNIStatus(l, true);
        }
        return new Status(5, 7L, "Message is of invalid type.");
    }

    public Status Publish(Message message, Config config) {
        MessageImpl messageImpl = message.GetImpl();
        if (messageImpl instanceof JNIMessage) {
            JNIMessage jNIMessage = (JNIMessage)messageImpl;
            JNIConfig jNIConfig = Config.getInternal(config);
            long l = gmsecJNI.ConnectionManager_Publish(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage, JNIConfig.getCPtr(jNIConfig), jNIConfig);
            return new JNIStatus(l, true);
        }
        return new Status(5, 7L, "Message is of invalid type.");
    }

    public Status Request(Message message, int n, ConnectionManagerReplyCallback connectionManagerReplyCallback) {
        MessageImpl messageImpl = message.GetImpl();
        if (messageImpl instanceof JNIMessage) {
            JNIMessage jNIMessage = (JNIMessage)messageImpl;
            long l = gmsecJNI.ConnectionManager_Request(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage, n, connectionManagerReplyCallback);
            return new JNIStatus(l, true);
        }
        return new Status(5, 7L, "Message is of invalid type.");
    }

    public Status Request(Message message, int n, Message message2) {
        MessageImpl messageImpl = message.GetImpl();
        if (messageImpl instanceof JNIMessage) {
            JNIMessage jNIMessage = (JNIMessage)messageImpl;
            JNIMessage jNIMessage2 = new JNIMessage();
            long l = gmsecJNI.ConnectionManager_Request(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage, n, jNIMessage2);
            message2.SetImpl(jNIMessage2);
            return new JNIStatus(l, true);
        }
        return new Status(5, 7L, "Message is of invalid type.");
    }

    public Status Reply(Message message, Message message2) {
        MessageImpl messageImpl = message.GetImpl();
        MessageImpl messageImpl2 = message2.GetImpl();
        if (messageImpl instanceof JNIMessage && messageImpl2 instanceof JNIMessage) {
            JNIMessage jNIMessage = (JNIMessage)messageImpl;
            JNIMessage jNIMessage2 = (JNIMessage)messageImpl2;
            long l = gmsecJNI.ConnectionManager_Reply(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage, JNIMessage.getCPtr(jNIMessage2), jNIMessage2);
            return new JNIStatus(l, true);
        }
        return new Status(5, 7L, "Message is of invalid type.");
    }

    public Status StartAutoDispatch() {
        long l = gmsecJNI.ConnectionManager_StartAutoDispatch(this.swigCPtr, this);
        return new JNIStatus(l, true);
    }

    public Status StopAutoDispatch() {
        long l = gmsecJNI.ConnectionManager_StopAutoDispatch(this.swigCPtr, this);
        return new JNIStatus(l, true);
    }

    public Status StopAutoDispatch(boolean bl) {
        long l = gmsecJNI.ConnectionManager_StopAutoDispatch(this.swigCPtr, this, bl);
        return new JNIStatus(l, true);
    }

    public Status GetNextMsg(Message message, int n) {
        JNIMessage jNIMessage = new JNIMessage();
        long l = gmsecJNI.ConnectionManager_GetNextMsg(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage, n);
        message.SetImpl(jNIMessage);
        return new JNIStatus(l, true);
    }

    public Status DispatchMsg(Message message) {
        MessageImpl messageImpl = message.GetImpl();
        if (messageImpl instanceof JNIMessage) {
            JNIMessage jNIMessage = (JNIMessage)messageImpl;
            long l = gmsecJNI.ConnectionManager_DispatchMsg(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage);
            return new JNIStatus(l, true);
        }
        return new Status(5, 7L, "Message is of invalid type.");
    }

    public Status GetLastDispatcherStatus() {
        long l = gmsecJNI.ConnectionManager_GetLastDispatcherStatus(this.swigCPtr, this);
        return new JNIStatus(l, true);
    }

    public Status ExcludeSubject(String string) {
        long l = gmsecJNI.ConnectionManager_ExcludeSubject(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }

    public Status RemoveExcludedSubject(String string) {
        long l = gmsecJNI.ConnectionManager_RemoveExcludedSubject(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }

    public Status GetHeartbeatMessage(Field[] fieldArray, Message message, String string) {
        this.getValidFields(fieldArray);
        JNIMessage jNIMessage = new JNIMessage();
        long l = gmsecJNI.ConnectionManager_GetHeartbeatMessage(this.swigCPtr, this, this.m_fieldPtrs, this.m_jniFields, this.m_fieldCount, JNIMessage.getCPtr(jNIMessage), jNIMessage, string);
        message.SetImpl(jNIMessage);
        return new JNIStatus(l, true);
    }

    public Status StartHeartbeatService(Field[] fieldArray, String string) {
        this.getValidFields(fieldArray);
        long l = gmsecJNI.ConnectionManager_StartHeartbeatService(this.swigCPtr, this, this.m_fieldPtrs, this.m_jniFields, this.m_fieldCount, string);
        return new JNIStatus(l, true);
    }

    public Status ChangeComponentStatus(Field field) {
        JNIField jNIField = new JNIField(field);
        long l = gmsecJNI.ConnectionManager_ChangeComponentStatus(this.swigCPtr, this, JNIField.getCPtr(jNIField), jNIField);
        return new JNIStatus(l, true);
    }

    public Status ChangeComponentInfo(Field field) {
        JNIField jNIField = new JNIField(field);
        long l = gmsecJNI.ConnectionManager_ChangeComponentInfo(this.swigCPtr, this, JNIField.getCPtr(jNIField), jNIField);
        return new JNIStatus(l, true);
    }

    public Status ChangeCPUMemory(Field field) {
        JNIField jNIField = new JNIField(field);
        long l = gmsecJNI.ConnectionManager_ChangeCPUMemory(this.swigCPtr, this, JNIField.getCPtr(jNIField), jNIField);
        return new JNIStatus(l, true);
    }

    public Status ChangeCPUUtil(Field field) {
        JNIField jNIField = new JNIField(field);
        long l = gmsecJNI.ConnectionManager_ChangeCPUUtil(this.swigCPtr, this, JNIField.getCPtr(jNIField), jNIField);
        return new JNIStatus(l, true);
    }

    public Status StopHeartbeatService() {
        long l = gmsecJNI.ConnectionManager_StopHeartbeatService(this.swigCPtr, this);
        return new JNIStatus(l, true);
    }

    public Status GetLogMessage(Field[] fieldArray, Message message, String string) {
        this.getValidFields(fieldArray);
        JNIMessage jNIMessage = new JNIMessage();
        long l = gmsecJNI.ConnectionManager_GetLogMessage(this.swigCPtr, this, this.m_fieldPtrs, this.m_jniFields, this.m_fieldCount, JNIMessage.getCPtr(jNIMessage), jNIMessage, string);
        message.SetImpl(jNIMessage);
        return new JNIStatus(l, true);
    }

    public Status SetLoggingDefaults(Field[] fieldArray, String string) {
        this.getValidFields(fieldArray);
        long l = gmsecJNI.ConnectionManager_SetLoggingDefaults(this.swigCPtr, this, this.m_fieldPtrs, this.m_jniFields, this.m_fieldCount, string);
        return new JNIStatus(l, true);
    }

    public Status QuickLog(String string, Field field) {
        JNIField jNIField = new JNIField(field);
        long l = gmsecJNI.ConnectionManager_QuickLog(this.swigCPtr, this, string, JNIField.getCPtr(jNIField), jNIField);
        return new JNIStatus(l, true);
    }

    private void getValidFields(Field[] fieldArray) {
        Object object;
        int n;
        this.m_fieldPtrs = null;
        this.m_jniFields = null;
        this.m_fieldCount = 0;
        if (fieldArray == null) {
            return;
        }
        for (n = 0; n < fieldArray.length; ++n) {
            GMSEC_UShort gMSEC_UShort;
            if (fieldArray[n] == null || ((Status)(object = fieldArray[n].GetType(gMSEC_UShort = new GMSEC_UShort()))).IsError() || gMSEC_UShort.Get() == 0) continue;
            ++this.m_fieldCount;
        }
        if (this.m_fieldCount > 0) {
            this.m_fieldPtrs = new long[this.m_fieldCount];
            this.m_jniFields = new JNIField[this.m_fieldCount];
            int n2 = 0;
            for (n = 0; n < fieldArray.length; ++n) {
                Status status;
                if (fieldArray[n] == null || (status = fieldArray[n].GetType((GMSEC_UShort)(object = new GMSEC_UShort()))).IsError() || ((GMSEC_U16)object).Get() == 0) continue;
                JNIField jNIField = new JNIField(fieldArray[n]);
                this.m_fieldPtrs[n2] = JNIField.getCPtr(jNIField);
                this.m_jniFields[n2] = jNIField;
                ++n2;
            }
        }
    }
}

