/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsecapi.jni;

import gov.nasa.gsfc.gmsecapi.Config;
import gov.nasa.gsfc.gmsecapi.Connection;
import gov.nasa.gsfc.gmsecapi.Status;
import gov.nasa.gsfc.gmsecapi.jni.JNIConfig;
import gov.nasa.gsfc.gmsecapi.jni.JNIConnection;
import gov.nasa.gsfc.gmsecapi.jni.JNIStatus;
import gov.nasa.gsfc.gmsecapi.jni.gmsecJNI;

public class JNIConnectionFactory {
    private JNIConnectionFactory() {
    }

    public static Status Create(Config config, Connection connection) {
        if (config == null) {
            return new Status(2, 35L, "Null Config object");
        }
        if (connection == null) {
            return new Status(2, 35L, "Null Connection object");
        }
        JNIConfig jNIConfig = new JNIConfig(config);
        JNIConnection jNIConnection = new JNIConnection();
        Status status = new Status();
        try {
            long l = gmsecJNI.ConnectionFactory_Create(JNIConfig.getCPtr(jNIConfig), jNIConfig, jNIConnection);
            status = new JNIStatus(l, true);
            if (status.IsError()) {
                connection.setImpl(null);
            } else {
                jNIConnection.setExternal(connection);
                connection.setImpl(jNIConnection);
            }
        }
        catch (Exception exception) {
            status.Set(2, 3L, "Can't load GMSEC JNI integration: " + exception.getMessage());
            connection.setImpl(null);
        }
        return status;
    }

    public static String GetAPIVersion() {
        return gmsecJNI.ConnectionFactory_GetAPIVersion();
    }

    public static Status Destroy(Connection connection) {
        if (connection == null || connection.getImpl() == null) {
            return new Status(2, 35L, "Null Connection object");
        }
        JNIConnection jNIConnection = connection.getImpl();
        long l = gmsecJNI.ConnectionFactory_Destroy(JNIConnection.getCPtr(jNIConnection), jNIConnection);
        jNIConnection.swigCPtr = 0L;
        return new JNIStatus(l, true);
    }
}

