/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsecapi.jni;

import gov.nasa.gsfc.gmsecapi.Config;
import gov.nasa.gsfc.gmsecapi.GMSEC_String;
import gov.nasa.gsfc.gmsecapi.Message;
import gov.nasa.gsfc.gmsecapi.Status;
import gov.nasa.gsfc.gmsecapi.jni.JNIConfig;
import gov.nasa.gsfc.gmsecapi.jni.JNIMessage;
import gov.nasa.gsfc.gmsecapi.jni.JNIStatus;
import gov.nasa.gsfc.gmsecapi.jni.gmsecJNI;

public class JNIConfigFile {
    private long swigCPtr;
    private boolean swigCMemOwn;

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    protected synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            gmsecJNI.delete_ConfigFile(this.swigCPtr, this);
            this.swigCMemOwn = false;
        }
        this.swigCPtr = 0L;
    }

    protected static long getCPtr(JNIConfigFile jNIConfigFile) {
        return jNIConfigFile == null ? 0L : jNIConfigFile.swigCPtr;
    }

    public JNIConfigFile() {
        this.swigCPtr = gmsecJNI.new_ConfigFile(this);
        if (this.swigCPtr != 0L) {
            this.swigCMemOwn = true;
        }
    }

    public JNIConfigFile(String string) {
        this.swigCPtr = gmsecJNI.new_ConfigFile(this, string);
        if (this.swigCPtr != 0L) {
            this.swigCMemOwn = true;
        }
    }

    public Status Load() {
        long l = gmsecJNI.ConfigFile_Load(this.swigCPtr, this);
        return new JNIStatus(l, true);
    }

    public Status Load(String string) {
        long l = gmsecJNI.ConfigFile_Load(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }

    public Status Save(String string, boolean bl) {
        long l = gmsecJNI.ConfigFile_Save(this.swigCPtr, this, string, bl);
        return new JNIStatus(l, true);
    }

    public Status FromXML(String string) {
        long l = gmsecJNI.ConfigFile_FromXML(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }

    public Status ToXML(GMSEC_String gMSEC_String) {
        long l = gmsecJNI.ConfigFile_ToXML(this.swigCPtr, this, gMSEC_String);
        return new JNIStatus(l, true);
    }

    public boolean IsLoaded() {
        return gmsecJNI.ConfigFile_IsLoaded(this.swigCPtr, this);
    }

    public Status LookupConfig(String string, JNIConfig jNIConfig) {
        JNIConfig jNIConfig2 = new JNIConfig();
        long l = gmsecJNI.ConfigFile_LookupConfig(this.swigCPtr, this, string, JNIConfig.getCPtr(jNIConfig2), jNIConfig2);
        jNIConfig.Set(jNIConfig2);
        return new JNIStatus(l, true);
    }

    public Status LookupMessage(String string, Message message) {
        JNIMessage jNIMessage = (JNIMessage)message.GetImpl();
        long l = gmsecJNI.ConfigFile_LookupMessage(this.swigCPtr, this, string, JNIMessage.getCPtr(jNIMessage), jNIMessage);
        message.SetImpl(jNIMessage);
        return new JNIStatus(l, true);
    }

    public Status LookupSubscription(String string, GMSEC_String gMSEC_String) {
        long l = gmsecJNI.ConfigFile_LookupSubscription(this.swigCPtr, this, string, gMSEC_String);
        return new JNIStatus(l, true);
    }

    public Status AddSubscription(String string, String string2) {
        long l = gmsecJNI.ConfigFile_AddSubscription(this.swigCPtr, this, string, string2);
        return new JNIStatus(l, true);
    }

    public Status AddConfig(String string, Config config) {
        JNIConfig jNIConfig = Config.getInternal(config);
        long l = gmsecJNI.ConfigFile_AddConfig(this.swigCPtr, this, JNIConfig.getCPtr(jNIConfig), string, config);
        return new JNIStatus(l, true);
    }

    public Status AddMessage(String string, Message message) {
        JNIMessage jNIMessage = (JNIMessage)message.GetImpl();
        long l = gmsecJNI.ConfigFile_AddMessage(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), string, message);
        return new JNIStatus(l, true);
    }

    public Status AddCustomXML(String string) {
        long l = gmsecJNI.ConfigFile_AddCustomXML(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }

    public Status RemoveSubscription(String string) {
        long l = gmsecJNI.ConfigFile_RemoveSubscription(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }

    public Status RemoveConfig(String string) {
        long l = gmsecJNI.ConfigFile_RemoveConfig(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }

    public Status RemoveMessage(String string) {
        long l = gmsecJNI.ConfigFile_RemoveMessage(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }

    public Status RemoveCustomXML(String string) {
        long l = gmsecJNI.ConfigFile_RemoveCustomXML(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }
}

