/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsecapi.jni;

import gov.nasa.gsfc.gmsecapi.Config;
import gov.nasa.gsfc.gmsecapi.GMSEC_String;
import gov.nasa.gsfc.gmsecapi.Status;
import gov.nasa.gsfc.gmsecapi.jni.JNIStatus;
import gov.nasa.gsfc.gmsecapi.jni.gmsecJNI;

public class JNIConfig {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected JNIConfig(long l, boolean bl) {
        this.swigCPtr = l;
        this.swigCMemOwn = bl;
    }

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            gmsecJNI.delete_Config(this.swigCPtr, this);
            this.swigCMemOwn = false;
        }
        this.swigCPtr = 0L;
    }

    protected static long getCPtr(JNIConfig jNIConfig) {
        return jNIConfig == null ? 0L : jNIConfig.swigCPtr;
    }

    public JNIConfig() {
        this(gmsecJNI.new_Config(), true);
    }

    public JNIConfig(String[] stringArray) {
        this(gmsecJNI.new_Config_String(stringArray), true);
    }

    public JNIConfig(Config config) {
        this(gmsecJNI.new_Config_Copy(JNIConfig.getCPtr(Config.getInternal(config)), Config.getInternal(config)), true);
    }

    public JNIConfig(JNIConfig jNIConfig) {
        this(gmsecJNI.new_Config_Copy(JNIConfig.getCPtr(jNIConfig), jNIConfig), true);
    }

    public JNIConfig(String string) {
        this(gmsecJNI.new_Config(), true);
        this.FromXML(string);
    }

    public void Set(JNIConfig jNIConfig) {
        GMSEC_String gMSEC_String = new GMSEC_String();
        GMSEC_String gMSEC_String2 = new GMSEC_String();
        Status status = new Status();
        status = jNIConfig.GetFirst(gMSEC_String, gMSEC_String2);
        while (!status.isError()) {
            this.AddValue(gMSEC_String.Get(), gMSEC_String2.Get());
            status = jNIConfig.GetNext(gMSEC_String, gMSEC_String2);
        }
    }

    public Status AddValue(String string, String string2) {
        long l = gmsecJNI.Config_AddValue(this.swigCPtr, this, string, string2);
        return new JNIStatus(l, true);
    }

    public Status ClearValue(String string) {
        long l = gmsecJNI.Config_ClearValue(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }

    public Status GetValue(String string, GMSEC_String gMSEC_String) {
        long l = gmsecJNI.Config_GetValue(this.swigCPtr, this, string, gMSEC_String);
        return new JNIStatus(l, true);
    }

    public Status Clear() {
        long l = gmsecJNI.Config_Clear(this.swigCPtr, this);
        return new JNIStatus(l, true);
    }

    public Status GetFirst(GMSEC_String gMSEC_String, GMSEC_String gMSEC_String2) {
        long l = gmsecJNI.Config_GetFirst(this.swigCPtr, this, gMSEC_String, gMSEC_String2);
        return new JNIStatus(l, true);
    }

    public Status GetNext(GMSEC_String gMSEC_String, GMSEC_String gMSEC_String2) {
        long l = gmsecJNI.Config_GetNext(this.swigCPtr, this, gMSEC_String, gMSEC_String2);
        return new JNIStatus(l, true);
    }

    public Status ToXML(GMSEC_String gMSEC_String) {
        long l = gmsecJNI.Config_ToXML(this.swigCPtr, this, gMSEC_String);
        return new JNIStatus(l, true);
    }

    public Status FromXML(String string) {
        long l = gmsecJNI.Config_FromXML(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }
}

