/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsecapi;

import gov.nasa.gsfc.gmsecapi.Status;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class Log {
    protected static Log instance = new Log();
    protected PrintWriter fLogger = null;
    protected FileOutputStream fFileOut = null;

    protected Log() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Log.this.destroyLog();
            }
        });
    }

    public static Log getLog() {
        return instance;
    }

    protected void setLogger(OutputStream outputStream, boolean bl) {
        this.notifyDeprecatedMethod("setLogger");
        this.fLogger = new PrintWriter(new BufferedOutputStream(outputStream), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status createLog(File file) {
        this.notifyDeprecatedMethod("createLog");
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            Status status = new Status();
            if (file == null) {
                status.Set(20, 50L, "User passed null log file.");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return status;
            }
            try {
                if (this.fLogger == null) {
                    this.fFileOut = new FileOutputStream(file);
                    this.setLogger(this.fFileOut, false);
                } else {
                    status.Set(20, 50L, "Log already created.");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                status.Set(20, 50L, "Error opening log file.  Using console for debug messages.");
                this.setLogger(System.out, true);
            }
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status createLog(OutputStream outputStream, boolean bl) {
        this.notifyDeprecatedMethod("createLog");
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            Status status = new Status();
            if (outputStream == null) {
                status.Set(20, 50L, "User passed null output stream.");
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return status;
            }
            if (this.fLogger == null) {
                this.setLogger(outputStream, bl);
            } else {
                status.Set(20, 50L, "Log already created.");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status destroyLog() {
        this.notifyDeprecatedMethod("destroyLog");
        Status status = new Status();
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            if (this.fLogger != null) {
                this.fLogger.flush();
                this.fLogger = null;
                if (this.fFileOut != null) {
                    try {
                        this.fFileOut.close();
                        this.fFileOut = null;
                    }
                    catch (IOException iOException) {
                        status.Set(20, 50L, "Error closing Log file.");
                    }
                }
            } else {
                status.Set(20, 50L, "No Log created yet.");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return status;
        }
    }

    public boolean isDebug() {
        return this.fLogger != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void debug(String string) {
        if (this.fLogger == null) return;
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            this.fLogger.println(string);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void debug(String string, String string2) {
        this.notifyDeprecatedMethod("debug");
        if (this.fLogger == null) return;
        String string3 = "\t[" + string + "]\t" + string2;
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            this.fLogger.println(string3);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void notifyDeprecatedMethod(String string) {
        if (this.fLogger == null) return;
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            this.fLogger.println("The method " + string + " is being deprecated.");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

