/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsecapi;

import gov.nasa.gsfc.gmsecapi.GMSEC_Bin;
import gov.nasa.gsfc.gmsecapi.GMSEC_Bool;
import gov.nasa.gsfc.gmsecapi.GMSEC_Char;
import gov.nasa.gsfc.gmsecapi.GMSEC_Double;
import gov.nasa.gsfc.gmsecapi.GMSEC_F32;
import gov.nasa.gsfc.gmsecapi.GMSEC_F64;
import gov.nasa.gsfc.gmsecapi.GMSEC_Float;
import gov.nasa.gsfc.gmsecapi.GMSEC_I16;
import gov.nasa.gsfc.gmsecapi.GMSEC_I32;
import gov.nasa.gsfc.gmsecapi.GMSEC_I64;
import gov.nasa.gsfc.gmsecapi.GMSEC_I8;
import gov.nasa.gsfc.gmsecapi.GMSEC_Long;
import gov.nasa.gsfc.gmsecapi.GMSEC_Short;
import gov.nasa.gsfc.gmsecapi.GMSEC_String;
import gov.nasa.gsfc.gmsecapi.GMSEC_U16;
import gov.nasa.gsfc.gmsecapi.GMSEC_U32;
import gov.nasa.gsfc.gmsecapi.GMSEC_U8;
import gov.nasa.gsfc.gmsecapi.GMSEC_ULong;
import gov.nasa.gsfc.gmsecapi.GMSEC_UShort;
import gov.nasa.gsfc.gmsecapi.Status;

public class Field {
    protected static final int DEFAULT_XML_FIELD_SIZE = 150;
    protected static final String XML_FIELD_CHAR_HEAD = "<FIELD TYPE=\"CHAR\" NAME=\"";
    protected static final String XML_FIELD_BOOL_HEAD = "<FIELD TYPE=\"BOOL\" NAME=\"";
    protected static final String XML_FIELD_SHORT_HEAD = "<FIELD TYPE=\"SHORT\" NAME=\"";
    protected static final String XML_FIELD_USHORT_HEAD = "<FIELD TYPE=\"USHORT\" NAME=\"";
    protected static final String XML_FIELD_LONG_HEAD = "<FIELD TYPE=\"LONG\" NAME=\"";
    protected static final String XML_FIELD_ULONG_HEAD = "<FIELD TYPE=\"ULONG\" NAME=\"";
    protected static final String XML_FIELD_FLOAT_HEAD = "<FIELD TYPE=\"FLOAT\" NAME=\"";
    protected static final String XML_FIELD_DOUBLE_HEAD = "<FIELD TYPE=\"DOUBLE\" NAME=\"";
    protected static final String XML_FIELD_STRING_HEAD = "<FIELD TYPE=\"STRING\" NAME=\"";
    protected static final String XML_FIELD_BIN_HEAD = "<FIELD TYPE=\"BIN\" NAME=\"";
    protected static final String XML_FIELD_I8_HEAD = "<FIELD TYPE=\"I8\" NAME=\"";
    protected static final String XML_FIELD_U8_HEAD = "<FIELD TYPE=\"U8\" NAME=\"";
    protected static final String XML_FIELD_U16_HEAD = "<FIELD TYPE=\"U16\" NAME=\"";
    protected static final String XML_FIELD_I16_HEAD = "<FIELD TYPE=\"I16\" NAME=\"";
    protected static final String XML_FIELD_U32_HEAD = "<FIELD TYPE=\"U32\" NAME=\"";
    protected static final String XML_FIELD_I32_HEAD = "<FIELD TYPE=\"I32\" NAME=\"";
    protected static final String XML_FIELD_I64_HEAD = "<FIELD TYPE=\"I64\" NAME=\"";
    protected static final String XML_FIELD_F32_HEAD = "<FIELD TYPE=\"F32\" NAME=\"";
    protected static final String XML_FIELD_F64_HEAD = "<FIELD TYPE=\"F64\" NAME=\"";
    protected static final String XML_FIELD_HEAD_END = "\">";
    protected static final String XML_FIELD_CLOSE = "</FIELD>";
    protected static final String XML_FIELD_BOOL_TRUE = "TRUE";
    protected static final String XML_FIELD_BOOL_FALSE = "FALSE";
    private int fType = 0;
    private String fName = new String();
    private GMSEC_Bin fBinValue = null;
    private GMSEC_Bool fBoolValue = null;
    private GMSEC_String fStringValue = null;
    private GMSEC_Char fCharValue = null;
    private GMSEC_U8 fU8Value = null;
    private GMSEC_I8 fI8Value = null;
    private GMSEC_U16 fU16Value = null;
    private GMSEC_I16 fI16Value = null;
    private GMSEC_U32 fU32Value = null;
    private GMSEC_I32 fI32Value = null;
    private GMSEC_I64 fI64Value = null;
    private GMSEC_F32 fF32Value = null;
    private GMSEC_F64 fF64Value = null;

    public Field() {
    }

    public Status SetFieldValueCHAR(String string, byte by) {
        this.fType = 1;
        this.fName = string;
        this.fCharValue = new GMSEC_Char(by);
        return new Status();
    }

    public Status SetFieldValueBOOL(String string, boolean bl) {
        this.fType = 2;
        this.fName = string;
        this.fBoolValue = new GMSEC_Bool(bl);
        return new Status();
    }

    public Status SetFieldValueBYTE(String string, byte by) {
        return this.SetFieldValueI8(string, by);
    }

    public Status SetFieldValueUBYTE(String string, int n) {
        return this.SetFieldValueU8(string, n);
    }

    public Status SetFieldValueSHORT(String string, short s) {
        return this.SetFieldValueI16(string, s);
    }

    public Status SetFieldValueUSHORT(String string, int n) {
        return this.SetFieldValueU16(string, n);
    }

    public Status SetFieldValueLONG(String string, int n) {
        return this.SetFieldValueI32(string, n);
    }

    public Status SetFieldValueULONG(String string, long l) {
        return this.SetFieldValueU32(string, l);
    }

    public Status SetFieldValueFLOAT(String string, float f) {
        return this.SetFieldValueF32(string, f);
    }

    public Status SetFieldValueDOUBLE(String string, double d) {
        return this.SetFieldValueF64(string, d);
    }

    public Status SetFieldValueSTRING(String string, String string2) {
        this.fType = 9;
        this.fName = string;
        this.fStringValue = new GMSEC_String(string2);
        return new Status();
    }

    public Status SetFieldValueBIN(String string, byte[] byArray) {
        this.fType = 10;
        this.fName = string;
        this.fBinValue = new GMSEC_Bin(byArray);
        return new Status();
    }

    public Status SetFieldValueU8(String string, int n) {
        this.fType = 21;
        this.fName = string;
        this.fU8Value = new GMSEC_U8(n);
        return new Status();
    }

    public Status SetFieldValueI8(String string, byte by) {
        this.fType = 20;
        this.fName = string;
        this.fI8Value = new GMSEC_I8(by);
        return new Status();
    }

    public Status SetFieldValueU16(String string, int n) {
        this.fType = 4;
        this.fName = string;
        this.fU16Value = new GMSEC_U16(n);
        return new Status();
    }

    public Status SetFieldValueI16(String string, short s) {
        this.fType = 3;
        this.fName = string;
        this.fI16Value = new GMSEC_I16(s);
        return new Status();
    }

    public Status SetFieldValueU32(String string, long l) {
        this.fType = 6;
        this.fName = string;
        this.fU32Value = new GMSEC_U32(l);
        return new Status();
    }

    public Status SetFieldValueI32(String string, int n) {
        this.fType = 5;
        this.fName = string;
        this.fI32Value = new GMSEC_I32(n);
        return new Status();
    }

    public Status SetFieldValueI64(String string, long l) {
        this.fType = 22;
        this.fName = string;
        this.fI64Value = new GMSEC_I64(l);
        return new Status();
    }

    public Status SetFieldValueF32(String string, float f) {
        this.fType = 7;
        this.fName = string;
        this.fF32Value = new GMSEC_F32(f);
        return new Status();
    }

    public Status SetFieldValueF64(String string, double d) {
        this.fType = 8;
        this.fName = string;
        this.fF64Value = new GMSEC_F64(d);
        return new Status();
    }

    public Field(Field field) {
        this.Set(field);
    }

    public void Set(Field field) {
        if (field == null) {
            return;
        }
        GMSEC_String gMSEC_String = new GMSEC_String();
        field.GetName(gMSEC_String);
        this.SetName(gMSEC_String.Get() == null ? "" : gMSEC_String.Get());
        GMSEC_UShort gMSEC_UShort = new GMSEC_UShort();
        field.GetType(gMSEC_UShort);
        this.SetType(gMSEC_UShort.Get());
        switch (gMSEC_UShort.Get()) {
            case 0: {
                break;
            }
            case 2: {
                GMSEC_Bool gMSEC_Bool = new GMSEC_Bool();
                field.GetValueBOOL(gMSEC_Bool);
                this.SetValueBOOL(gMSEC_Bool.Get());
                break;
            }
            case 1: {
                GMSEC_Char gMSEC_Char = new GMSEC_Char();
                field.GetValueCHAR(gMSEC_Char);
                this.SetValueCHAR(gMSEC_Char.Get());
                break;
            }
            case 9: {
                GMSEC_String gMSEC_String2 = new GMSEC_String();
                field.GetValueSTRING(gMSEC_String2);
                if (gMSEC_String2.Get() == null) break;
                this.SetValueSTRING(gMSEC_String2.Get());
                break;
            }
            case 10: {
                GMSEC_Bin gMSEC_Bin = new GMSEC_Bin();
                field.GetValueBIN(gMSEC_Bin);
                if (gMSEC_Bin.Get() == null) break;
                this.SetValueBIN(gMSEC_Bin.Get());
                break;
            }
            case 21: {
                GMSEC_U8 gMSEC_U8 = new GMSEC_U8();
                field.GetValueU8(gMSEC_U8);
                this.SetValueU8(gMSEC_U8.Get());
                break;
            }
            case 20: {
                GMSEC_I8 gMSEC_I8 = new GMSEC_I8();
                field.GetValueI8(gMSEC_I8);
                this.SetValueI8(gMSEC_I8.Get());
                break;
            }
            case 4: {
                GMSEC_U16 gMSEC_U16 = new GMSEC_U16();
                field.GetValueU16(gMSEC_U16);
                this.SetValueU16(gMSEC_U16.Get());
                break;
            }
            case 3: {
                GMSEC_I16 gMSEC_I16 = new GMSEC_I16();
                field.GetValueI16(gMSEC_I16);
                this.SetValueI16(gMSEC_I16.Get());
                break;
            }
            case 6: {
                GMSEC_U32 gMSEC_U32 = new GMSEC_U32();
                field.GetValueU32(gMSEC_U32);
                this.SetValueU32(gMSEC_U32.Get());
                break;
            }
            case 5: {
                GMSEC_I32 gMSEC_I32 = new GMSEC_I32();
                field.GetValueI32(gMSEC_I32);
                this.SetValueI32(gMSEC_I32.Get());
                break;
            }
            case 22: {
                GMSEC_I64 gMSEC_I64 = new GMSEC_I64();
                field.GetValueI64(gMSEC_I64);
                this.SetValueI64(gMSEC_I64.Get());
                break;
            }
            case 7: {
                GMSEC_F32 gMSEC_F32 = new GMSEC_F32();
                field.GetValueF32(gMSEC_F32);
                this.SetValueF32(gMSEC_F32.Get());
                break;
            }
            case 8: {
                GMSEC_F64 gMSEC_F64 = new GMSEC_F64();
                field.GetValueF64(gMSEC_F64);
                this.SetValueF64(gMSEC_F64.Get());
                break;
            }
        }
    }

    public Status GetName(GMSEC_String gMSEC_String) {
        if (gMSEC_String == null) {
            return new Status(6, 35L, "Name is null");
        }
        gMSEC_String.Set(this.fName);
        return new Status();
    }

    public Status SetName(String string) {
        if (string == null) {
            return new Status(6, 35L, "Name is null");
        }
        this.fName = string;
        return new Status();
    }

    public Status SetType(int n) {
        this.fType = n;
        return new Status();
    }

    public Status GetType(GMSEC_UShort gMSEC_UShort) {
        gMSEC_UShort.Set(this.fType);
        return new Status();
    }

    public Status GetValueCHAR(GMSEC_Char gMSEC_Char) {
        if (this.fType != 1) {
            return new Status(6, 10L, "Field is not of requested type");
        }
        if (this.fCharValue == null) {
            return new Status(6, 35L, "Field value has not been set");
        }
        gMSEC_Char.Set(this.fCharValue.Get());
        return new Status();
    }

    public Status GetValueBOOL(GMSEC_Bool gMSEC_Bool) {
        if (this.fType != 2) {
            return new Status(6, 10L, "Field is not of requested type");
        }
        if (this.fBoolValue == null) {
            return new Status(6, 35L, "Field value has not been set");
        }
        gMSEC_Bool.Set(this.fBoolValue.Get());
        return new Status();
    }

    public Status GetValueBYTE(GMSEC_I8 gMSEC_I8) {
        return this.GetValueI8(gMSEC_I8);
    }

    public Status GetValueUBYTE(GMSEC_U8 gMSEC_U8) {
        return this.GetValueU8(gMSEC_U8);
    }

    public Status GetValueSHORT(GMSEC_Short gMSEC_Short) {
        return this.GetValueI16(gMSEC_Short);
    }

    public Status GetValueUSHORT(GMSEC_UShort gMSEC_UShort) {
        return this.GetValueU16(gMSEC_UShort);
    }

    public Status GetValueLONG(GMSEC_Long gMSEC_Long) {
        return this.GetValueI32(gMSEC_Long);
    }

    public Status GetValueULONG(GMSEC_ULong gMSEC_ULong) {
        return this.GetValueU32(gMSEC_ULong);
    }

    public Status GetValueFLOAT(GMSEC_Float gMSEC_Float) {
        return this.GetValueF32(gMSEC_Float);
    }

    public Status GetValueDOUBLE(GMSEC_Double gMSEC_Double) {
        return this.GetValueF64(gMSEC_Double);
    }

    public Status GetValueSTRING(GMSEC_String gMSEC_String) {
        if (this.fType != 9) {
            return new Status(6, 10L, "Field is not of requested type");
        }
        if (this.fStringValue == null) {
            return new Status(6, 35L, "Field value has not been set");
        }
        gMSEC_String.Set(this.fStringValue.Get());
        return new Status();
    }

    public Status GetValueBIN(GMSEC_Bin gMSEC_Bin) {
        if (this.fType != 10) {
            return new Status(6, 10L, "Field is not of requested type");
        }
        if (this.fBinValue == null) {
            return new Status(6, 35L, "Field value has not been set");
        }
        gMSEC_Bin.Set(this.fBinValue.Get());
        return new Status();
    }

    public Status GetValueU8(GMSEC_U8 gMSEC_U8) {
        if (this.fType != 21) {
            return new Status(6, 10L, "Field is not of requested type");
        }
        if (this.fU8Value == null) {
            return new Status(6, 35L, "Field value has not been set");
        }
        gMSEC_U8.Set(this.fU8Value.Get());
        return new Status();
    }

    public Status GetValueI8(GMSEC_I8 gMSEC_I8) {
        if (this.fType != 20) {
            return new Status(6, 10L, "Field is not of requested type");
        }
        if (this.fI8Value == null) {
            return new Status(6, 35L, "Field value has not been set");
        }
        gMSEC_I8.Set(this.fI8Value.Get());
        return new Status();
    }

    public Status GetValueU16(GMSEC_U16 gMSEC_U16) {
        if (this.fType != 4) {
            return new Status(6, 10L, "Field is not of requested type");
        }
        if (this.fU16Value == null) {
            return new Status(6, 35L, "Field value has not been set");
        }
        gMSEC_U16.Set(this.fU16Value.Get());
        return new Status();
    }

    public Status GetValueI16(GMSEC_I16 gMSEC_I16) {
        if (this.fType != 3) {
            return new Status(6, 10L, "Field is not of requested type");
        }
        if (this.fI16Value == null) {
            return new Status(6, 35L, "Field value has not been set");
        }
        gMSEC_I16.Set(this.fI16Value.Get());
        return new Status();
    }

    public Status GetValueU32(GMSEC_U32 gMSEC_U32) {
        if (this.fType != 6) {
            return new Status(6, 10L, "Field is not of requested type");
        }
        if (this.fU32Value == null) {
            return new Status(6, 35L, "Field value has not been set");
        }
        gMSEC_U32.Set(this.fU32Value.Get());
        return new Status();
    }

    public Status GetValueI32(GMSEC_I32 gMSEC_I32) {
        if (this.fType != 5) {
            return new Status(6, 10L, "Field is not of requested type");
        }
        if (this.fI32Value == null) {
            return new Status(6, 35L, "Field value has not been set");
        }
        gMSEC_I32.Set(this.fI32Value.Get());
        return new Status();
    }

    public Status GetValueI64(GMSEC_I64 gMSEC_I64) {
        if (this.fType != 22) {
            return new Status(6, 10L, "Field is not of requested type");
        }
        if (this.fI64Value == null) {
            return new Status(6, 35L, "Field value has not been set");
        }
        gMSEC_I64.Set(this.fI64Value.Get());
        return new Status();
    }

    public Status GetValueF32(GMSEC_F32 gMSEC_F32) {
        if (this.fType != 7) {
            return new Status(6, 10L, "Field is not of requested type");
        }
        if (this.fF32Value == null) {
            return new Status(6, 35L, "Field value has not been set");
        }
        gMSEC_F32.Set(this.fF32Value.Get());
        return new Status();
    }

    public Status GetValueF64(GMSEC_F64 gMSEC_F64) {
        if (this.fType != 8) {
            return new Status(6, 10L, "Field is not of requested type");
        }
        if (this.fF64Value == null) {
            return new Status(6, 35L, "Field value has not been set");
        }
        gMSEC_F64.Set(this.fF64Value.Get());
        return new Status();
    }

    public Status SetValueCHAR(byte by) {
        this.fType = 1;
        this.fCharValue = new GMSEC_Char(by);
        return new Status();
    }

    public Status SetValueBOOL(boolean bl) {
        this.fType = 2;
        this.fBoolValue = new GMSEC_Bool(bl);
        return new Status();
    }

    public Status SetValueBYTE(byte by) {
        return this.SetValueI8(by);
    }

    public Status SetValueUBYTE(int n) {
        return this.SetValueU8(n);
    }

    public Status SetValueSHORT(short s) {
        return this.SetValueI16(s);
    }

    public Status SetValueUSHORT(int n) {
        return this.SetValueU16(n);
    }

    public Status SetValueLONG(int n) {
        return this.SetValueI32(n);
    }

    public Status SetValueULONG(long l) {
        return this.SetValueU32(l);
    }

    public Status SetValueFLOAT(float f) {
        return this.SetValueF32(f);
    }

    public Status SetValueDOUBLE(double d) {
        return this.SetValueF64(d);
    }

    public Status SetValueSTRING(String string) {
        this.fType = 9;
        this.fStringValue = new GMSEC_String(string);
        return new Status();
    }

    public Status SetValueBIN(byte[] byArray) {
        this.fType = 10;
        this.fBinValue = new GMSEC_Bin(byArray);
        return new Status();
    }

    public Status SetValueU8(int n) {
        this.fType = 21;
        this.fU8Value = new GMSEC_U8(n);
        return new Status();
    }

    public Status SetValueI8(byte by) {
        this.fType = 20;
        this.fI8Value = new GMSEC_I8(by);
        return new Status();
    }

    public Status SetValueU16(int n) {
        this.fType = 4;
        this.fU16Value = new GMSEC_U16(n);
        return new Status();
    }

    public Status SetValueI16(short s) {
        this.fType = 3;
        this.fI16Value = new GMSEC_I16(s);
        return new Status();
    }

    public Status SetValueU32(long l) {
        this.fType = 6;
        this.fU32Value = new GMSEC_U32(l);
        return new Status();
    }

    public Status SetValueI32(int n) {
        this.fType = 5;
        this.fI32Value = new GMSEC_I32(n);
        return new Status();
    }

    public Status SetValueI64(long l) {
        this.fType = 22;
        this.fI64Value = new GMSEC_I64(l);
        return new Status();
    }

    public Status SetValueF32(float f) {
        this.fType = 7;
        this.fF32Value = new GMSEC_F32(f);
        return new Status();
    }

    public Status SetValueF64(double d) {
        this.fType = 8;
        this.fF64Value = new GMSEC_F64(d);
        return new Status();
    }

    public Status UnSet() {
        this.fName = "";
        this.fType = 0;
        this.fBinValue = null;
        this.fBoolValue = null;
        this.fCharValue = null;
        this.fU8Value = null;
        this.fI8Value = null;
        this.fU16Value = null;
        this.fI16Value = null;
        this.fU32Value = null;
        this.fI32Value = null;
        this.fI64Value = null;
        this.fF32Value = null;
        this.fF64Value = null;
        this.fStringValue = null;
        return new Status();
    }

    public Status ToXML(GMSEC_String gMSEC_String) {
        Status status = new Status();
        StringBuffer stringBuffer = new StringBuffer(150);
        String string = "";
        if (null != this.fName) {
            string = this.fName;
        }
        GMSEC_UShort gMSEC_UShort = new GMSEC_UShort();
        this.GetType(gMSEC_UShort);
        switch (gMSEC_UShort.Get()) {
            case 2: {
                if (this.fBoolValue.Get()) {
                    stringBuffer.append(XML_FIELD_BOOL_HEAD).append(string).append(XML_FIELD_HEAD_END).append(XML_FIELD_BOOL_TRUE).append(XML_FIELD_CLOSE);
                    break;
                }
                stringBuffer.append(XML_FIELD_BOOL_HEAD).append(string).append(XML_FIELD_HEAD_END).append(XML_FIELD_BOOL_FALSE).append(XML_FIELD_CLOSE);
                break;
            }
            case 1: {
                stringBuffer.append(XML_FIELD_CHAR_HEAD).append(string).append(XML_FIELD_HEAD_END);
                if (this.fCharValue.Get() == 0) {
                    stringBuffer.append("nul");
                } else {
                    stringBuffer.append((char)this.fCharValue.Get());
                }
                stringBuffer.append(XML_FIELD_CLOSE);
                break;
            }
            case 9: {
                stringBuffer.append(XML_FIELD_STRING_HEAD).append(string).append(XML_FIELD_HEAD_END).append(this.fStringValue).append(XML_FIELD_CLOSE);
                break;
            }
            case 10: {
                stringBuffer.append(XML_FIELD_BIN_HEAD).append(string).append(XML_FIELD_HEAD_END).append(this.fBinValue).append(XML_FIELD_CLOSE);
                break;
            }
            case 21: {
                stringBuffer.append(XML_FIELD_U8_HEAD).append(string).append(XML_FIELD_HEAD_END).append(this.fU8Value.Get()).append(XML_FIELD_CLOSE);
                break;
            }
            case 20: {
                stringBuffer.append(XML_FIELD_I8_HEAD).append(string).append(XML_FIELD_HEAD_END).append(this.fI8Value.Get()).append(XML_FIELD_CLOSE);
                break;
            }
            case 4: {
                stringBuffer.append(XML_FIELD_U16_HEAD).append(string).append(XML_FIELD_HEAD_END).append(this.fU16Value.Get()).append(XML_FIELD_CLOSE);
                break;
            }
            case 3: {
                stringBuffer.append(XML_FIELD_I16_HEAD).append(string).append(XML_FIELD_HEAD_END).append(this.fI16Value.Get()).append(XML_FIELD_CLOSE);
                break;
            }
            case 6: {
                stringBuffer.append(XML_FIELD_U32_HEAD).append(string).append(XML_FIELD_HEAD_END).append(this.fU32Value.Get()).append(XML_FIELD_CLOSE);
                break;
            }
            case 5: {
                stringBuffer.append(XML_FIELD_I32_HEAD).append(string).append(XML_FIELD_HEAD_END).append(this.fI32Value.Get()).append(XML_FIELD_CLOSE);
                break;
            }
            case 22: {
                stringBuffer.append(XML_FIELD_I64_HEAD).append(string).append(XML_FIELD_HEAD_END).append(this.fI64Value.Get()).append(XML_FIELD_CLOSE);
                break;
            }
            case 7: {
                stringBuffer.append(XML_FIELD_F32_HEAD).append(string).append(XML_FIELD_HEAD_END).append(this.fF32Value.Get()).append(XML_FIELD_CLOSE);
                break;
            }
            case 8: {
                stringBuffer.append(XML_FIELD_F64_HEAD).append(string).append(XML_FIELD_HEAD_END).append(this.fF64Value.Get()).append(XML_FIELD_CLOSE);
                break;
            }
            default: {
                status.Set(6, 11L, "Field has unknown or unset type.");
            }
        }
        gMSEC_String.Set(stringBuffer.toString());
        return status;
    }

    public static int LookupType(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equalsIgnoreCase("CHAR")) {
            return 1;
        }
        if (string.equalsIgnoreCase("BOOL")) {
            return 2;
        }
        if (string.equalsIgnoreCase("SHORT")) {
            return 3;
        }
        if (string.equalsIgnoreCase("USHORT")) {
            return 4;
        }
        if (string.equalsIgnoreCase("LONG")) {
            return 5;
        }
        if (string.equalsIgnoreCase("ULONG")) {
            return 6;
        }
        if (string.equalsIgnoreCase("FLOAT")) {
            return 7;
        }
        if (string.equalsIgnoreCase("DOUBLE")) {
            return 8;
        }
        if (string.equalsIgnoreCase("STRING")) {
            return 9;
        }
        if (string.equalsIgnoreCase("BIN")) {
            return 10;
        }
        if (string.equalsIgnoreCase("I8")) {
            return 20;
        }
        if (string.equalsIgnoreCase("U8")) {
            return 21;
        }
        if (string.equalsIgnoreCase("U16")) {
            return 4;
        }
        if (string.equalsIgnoreCase("I16")) {
            return 3;
        }
        if (string.equalsIgnoreCase("U32")) {
            return 6;
        }
        if (string.equalsIgnoreCase("I32")) {
            return 5;
        }
        if (string.equalsIgnoreCase("I64")) {
            return 5;
        }
        if (string.equalsIgnoreCase("F32")) {
            return 7;
        }
        if (string.equalsIgnoreCase("F64")) {
            return 8;
        }
        return 0;
    }

    private char lookupHexDigit(char c) {
        switch (c) {
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return (char)(c - 97 + 10);
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return (char)(c - 65 + 10);
            }
        }
        return (char)(c - 48);
    }

    public Status SetValue(int n, String string) {
        Status status = new Status();
        switch (n) {
            case 2: {
                this.SetValueBOOL(Boolean.valueOf(string));
                break;
            }
            case 1: {
                byte by = 0;
                if (string.equals("nul")) {
                    by = 0;
                } else if (string.length() > 0) {
                    by = string.getBytes()[0];
                } else {
                    status.Set(6, 16L, "Invalid CHAR value");
                }
                this.SetValueCHAR(by);
                break;
            }
            case 9: {
                this.SetValueSTRING(string);
                break;
            }
            case 10: {
                if (string.length() % 2 != 0) {
                    status.Set(6, 16L, "Invalid hex value.  An even number of hex digits is required.");
                    return status;
                }
                byte[] byArray = new byte[string.length() / 2];
                for (int i = 0; i < string.length() / 2; ++i) {
                    byArray[i] = (byte)(this.lookupHexDigit(string.charAt(i * 2)) * 16 + this.lookupHexDigit(string.charAt(i * 2 + 1)));
                }
                this.SetValueBIN(byArray);
                break;
            }
            case 21: {
                this.SetValueU8(Integer.parseInt(string));
                break;
            }
            case 20: {
                this.SetValueI8(Byte.parseByte(string));
                break;
            }
            case 4: {
                this.SetValueU16(Integer.parseInt(string));
                break;
            }
            case 3: {
                this.SetValueI16(Short.parseShort(string));
                break;
            }
            case 6: {
                this.SetValueU32(Long.parseLong(string));
                break;
            }
            case 5: {
                this.SetValueI32(Integer.parseInt(string));
                break;
            }
            case 22: {
                this.SetValueI32(Integer.parseInt(string));
                break;
            }
            case 7: {
                this.SetValueF32(Float.parseFloat(string));
                break;
            }
            case 8: {
                this.SetValueF64(Double.parseDouble(string));
                break;
            }
        }
        return status;
    }

    public String toString() {
        GMSEC_String gMSEC_String = new GMSEC_String();
        this.ToXML(gMSEC_String);
        return gMSEC_String.Get();
    }
}

