/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.util;

import gov.nasa.gsfc.gmsec.api.jni.JNILog;
import gov.nasa.gsfc.gmsec.api.util.LogHandler;
import gov.nasa.gsfc.gmsec.api.util.LogLevel;

public class Log {
    public static void setReportingLevel(LogLevel logLevel) {
        JNILog.setReportingLevel(logLevel);
    }

    public static LogLevel getReportingLevel() {
        return JNILog.getReportingLevel();
    }

    public static void registerHandler(LogHandler logHandler) throws IllegalArgumentException {
        if (logHandler == null) {
            throw new IllegalArgumentException("LogHandler is null");
        }
        JNILog.registerHandler(logHandler);
    }

    public static void registerHandler(LogLevel logLevel, LogHandler logHandler) throws IllegalArgumentException {
        if (logHandler == null) {
            throw new IllegalArgumentException("LogHandler is null");
        }
        JNILog.registerHandler(logLevel, logHandler);
    }

    public static String levelToString(LogLevel logLevel) {
        return JNILog.logLevelToString(logLevel);
    }

    public static LogLevel levelFromString(String string) {
        if (string == null) {
            return LogLevel.NONE;
        }
        return JNILog.logLevelFromString(string);
    }

    public static void error(String string) {
        if (string != null) {
            JNILog.logError(string);
        }
    }

    public static void secure(String string) {
        if (string != null) {
            JNILog.logSecure(string);
        }
    }

    public static void warning(String string) {
        if (string != null) {
            JNILog.logWarning(string);
        }
    }

    public static void info(String string) {
        if (string != null) {
            JNILog.logInfo(string);
        }
    }

    public static void verbose(String string) {
        if (string != null) {
            JNILog.logVerbose(string);
        }
    }

    public static void debug(String string) {
        if (string != null) {
            JNILog.logDebug(string);
        }
    }
}

