/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.mist;

import gov.nasa.gsfc.gmsec.api.Config;
import gov.nasa.gsfc.gmsec.api.GMSEC_Exception;
import gov.nasa.gsfc.gmsec.api.Message;
import gov.nasa.gsfc.gmsec.api.jni.mist.JNISpecification;
import gov.nasa.gsfc.gmsec.api.mist.SchemaIDIterator;

public class Specification {
    private JNISpecification m_jniSpecification = null;

    public static JNISpecification getInternal(Specification specification) {
        return specification == null ? null : specification.m_jniSpecification;
    }

    public Specification(JNISpecification jNISpecification) {
        this.m_jniSpecification = jNISpecification;
    }

    public Specification(Config config) throws IllegalArgumentException, GMSEC_Exception {
        if (config == null) {
            throw new IllegalArgumentException("Config object is null");
        }
        this.m_jniSpecification = new JNISpecification(Config.getInternal(config));
    }

    public Specification(Specification specification) throws IllegalArgumentException, GMSEC_Exception {
        if (specification == null) {
            throw new IllegalArgumentException("Specification object is null");
        }
        this.m_jniSpecification = new JNISpecification(Specification.getInternal(specification));
    }

    public void validateMessage(Message message) {
        if (message == null) {
            throw new IllegalArgumentException("Message object is null");
        }
        this.m_jniSpecification.validateMessage(Message.getInternal(message));
    }

    public SchemaIDIterator getSchemaIDIterator() {
        return this.m_jniSpecification.getSchemaIDIterator();
    }

    public int getVersion() {
        return this.m_jniSpecification.getVersion();
    }

    public String getTemplateXML(String string, String string2) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject object is null or contains empty string");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("Message object is null or contains empty string");
        }
        return this.m_jniSpecification.getTemplateXML(string, string2);
    }
}

