/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.mist;

import gov.nasa.gsfc.gmsec.api.GMSEC_Exception;
import gov.nasa.gsfc.gmsec.api.field.Field;
import gov.nasa.gsfc.gmsec.api.jni.mist.JNIMnemonicSample;

public class MnemonicSample {
    private JNIMnemonicSample m_jniMnemonicSample = null;

    public static JNIMnemonicSample getInternal(MnemonicSample mnemonicSample) {
        return mnemonicSample == null ? null : mnemonicSample.m_jniMnemonicSample;
    }

    public MnemonicSample(JNIMnemonicSample jNIMnemonicSample) {
        this.m_jniMnemonicSample = jNIMnemonicSample;
    }

    protected MnemonicSample() {
    }

    public MnemonicSample(String string, Field field) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("MnemonicSample timestamp is null or contains an empty string");
        }
        if (field == null) {
            throw new IllegalArgumentException("MnemonicSample raw value Field is null");
        }
        this.m_jniMnemonicSample = new JNIMnemonicSample(string, field);
    }

    public MnemonicSample(MnemonicSample mnemonicSample) throws IllegalArgumentException {
        if (mnemonicSample == null) {
            throw new IllegalArgumentException("MnemonicSample is null");
        }
        this.m_jniMnemonicSample = new JNIMnemonicSample(MnemonicSample.getInternal(mnemonicSample));
    }

    public String getTimestamp() {
        return this.m_jniMnemonicSample.getTimestamp();
    }

    public Field getRawValue() {
        return this.m_jniMnemonicSample.getRawValue();
    }

    public boolean hasEUValue() {
        return this.m_jniMnemonicSample.hasEUValue();
    }

    public Field getEUValue() throws GMSEC_Exception {
        return this.m_jniMnemonicSample.getEUValue();
    }

    public void setEUValue(Field field) throws IllegalArgumentException {
        if (field == null) {
            throw new IllegalArgumentException("EU Field value is null");
        }
        this.m_jniMnemonicSample.setEUValue(field);
    }

    public boolean hasTextValue() {
        return this.m_jniMnemonicSample.hasTextValue();
    }

    public String getTextValue() throws GMSEC_Exception {
        return this.m_jniMnemonicSample.getTextValue();
    }

    public void setTextValue(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Text value is null or contains an empty string");
        }
        this.m_jniMnemonicSample.setTextValue(string);
    }

    public boolean hasFlags() {
        return this.m_jniMnemonicSample.hasFlags();
    }

    public int getFlags() throws GMSEC_Exception {
        return this.m_jniMnemonicSample.getFlags();
    }

    public void setFlags(int n) {
        this.m_jniMnemonicSample.setFlags(n);
    }

    public boolean hasLimitEnableDisable() {
        return this.m_jniMnemonicSample.hasLimitEnableDisable();
    }

    public boolean getLimitEnableDisable() throws GMSEC_Exception {
        return this.m_jniMnemonicSample.getLimitEnableDisable();
    }

    public void setLimitEnableDisable(boolean bl) {
        this.m_jniMnemonicSample.setLimitEnableDisable(bl);
    }

    public boolean hasLimit() {
        return this.m_jniMnemonicSample.hasLimit();
    }

    public LimitFlag getLimit() throws GMSEC_Exception {
        return this.m_jniMnemonicSample.getLimit();
    }

    public void setLimit(LimitFlag limitFlag) {
        this.m_jniMnemonicSample.setLimit(limitFlag);
    }

    public boolean hasStalenessStatus() {
        return this.m_jniMnemonicSample.hasStalenessStatus();
    }

    public boolean getStalenessStatus() throws GMSEC_Exception {
        return this.m_jniMnemonicSample.getStalenessStatus();
    }

    public void setStalenessStatus(boolean bl) {
        this.m_jniMnemonicSample.setStalenessStatus(bl);
    }

    public boolean hasQuality() {
        return this.m_jniMnemonicSample.hasQuality();
    }

    public boolean getQuality() throws GMSEC_Exception {
        return this.m_jniMnemonicSample.getQuality();
    }

    public void setQuality(boolean bl) {
        this.m_jniMnemonicSample.setQuality(bl);
    }

    public static enum LimitFlag {
        UNSPECIFIED,
        NO_LIMIT_VIOLATION,
        RED_LOW,
        YELLOW_LOW,
        YELLOW_HIGH,
        RED_HIGH;

    }
}

