/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.mist;

import gov.nasa.gsfc.gmsec.api.GMSEC_Exception;
import gov.nasa.gsfc.gmsec.api.field.Field;
import gov.nasa.gsfc.gmsec.api.jni.mist.JNIMnemonic;
import gov.nasa.gsfc.gmsec.api.mist.MnemonicSample;
import java.util.List;

public class Mnemonic {
    private JNIMnemonic m_jniMnemonic = null;

    public static JNIMnemonic getInternal(Mnemonic mnemonic) {
        return mnemonic == null ? null : mnemonic.m_jniMnemonic;
    }

    public Mnemonic(JNIMnemonic jNIMnemonic) {
        this.m_jniMnemonic = jNIMnemonic;
    }

    protected Mnemonic() {
    }

    public Mnemonic(String string, List<MnemonicSample> list) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Mnemonic name is null or contains an empty string");
        }
        if (list == null) {
            throw new IllegalArgumentException("MnemonicSample list is null");
        }
        this.m_jniMnemonic = new JNIMnemonic(string, list);
    }

    public Mnemonic(Mnemonic mnemonic) throws IllegalArgumentException {
        if (mnemonic == null) {
            throw new IllegalArgumentException("Mnemonic is null");
        }
        this.m_jniMnemonic = new JNIMnemonic(Mnemonic.getInternal(mnemonic));
    }

    public String getName() {
        return this.m_jniMnemonic.getName();
    }

    public boolean statusAvailable() {
        return this.m_jniMnemonic.statusAvailable();
    }

    public Field getStatus() throws GMSEC_Exception {
        return this.m_jniMnemonic.getStatus();
    }

    public void setStatus(Field field) throws IllegalArgumentException {
        if (field == null) {
            throw new IllegalArgumentException("Field is null");
        }
        this.m_jniMnemonic.setStatus(field);
    }

    public boolean unitsAvailable() {
        return this.m_jniMnemonic.unitsAvailable();
    }

    public String getUnits() throws GMSEC_Exception {
        return this.m_jniMnemonic.getUnits();
    }

    public void setUnits(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Units is null or contains an empty string");
        }
        this.m_jniMnemonic.setUnits(string);
    }

    public long getSampleCount() {
        return this.m_jniMnemonic.getSampleCount();
    }

    public MnemonicSample getSample(long l) throws GMSEC_Exception {
        return this.m_jniMnemonic.getSample(l);
    }

    public void addSample(MnemonicSample mnemonicSample) throws IllegalArgumentException {
        if (mnemonicSample == null) {
            throw new IllegalArgumentException("MnemonicSample is null");
        }
        this.m_jniMnemonic.addSample(mnemonicSample);
    }
}

