/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.jni.mist.message;

import gov.nasa.gsfc.gmsec.api.Config;
import gov.nasa.gsfc.gmsec.api.GMSEC_Exception;
import gov.nasa.gsfc.gmsec.api.Message;
import gov.nasa.gsfc.gmsec.api.jni.JNIConfig;
import gov.nasa.gsfc.gmsec.api.jni.JNIMessage;
import gov.nasa.gsfc.gmsec.api.jni.gmsecJNI;
import gov.nasa.gsfc.gmsec.api.jni.mist.JNISpecification;
import gov.nasa.gsfc.gmsec.api.mist.Specification;
import gov.nasa.gsfc.gmsec.api.util.Log;

public class JNIMistMessage
extends JNIMessage {
    public static String buildSchemaID(Message.MessageKind messageKind, String string, String string2, String string3, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n);
        stringBuilder.insert(4, ".");
        stringBuilder.append(".GMSEC");
        switch (messageKind) {
            case PUBLISH: {
                stringBuilder.append(".MSG");
                break;
            }
            case REQUEST: {
                stringBuilder.append(".REQ");
                break;
            }
            case REPLY: {
                stringBuilder.append(".RESP");
            }
        }
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(".").append(string);
        }
        if (string2 != null && !string2.isEmpty()) {
            stringBuilder.append(".").append(string2);
        }
        if (string3 != null && !string3.isEmpty()) {
            stringBuilder.append(".").append(string3);
        }
        return stringBuilder.toString();
    }

    public static Specification buildSpecification(int n) {
        Config config = new Config();
        config.addValue("gmsec-specification-version", Integer.toString(n));
        Specification specification = null;
        try {
            specification = new Specification(config);
        }
        catch (GMSEC_Exception gMSEC_Exception) {
            Log.warning("Invalid version number given; using GMSEC_ISD_CURRENT instead.");
        }
        return specification;
    }

    protected JNIMistMessage(long l, boolean bl) {
        super(l, bl);
    }

    public JNIMistMessage(String string, String string2, JNISpecification jNISpecification) throws GMSEC_Exception {
        this(gmsecJNI.new_MistMessage(string, string2, JNISpecification.getCPtr(jNISpecification), jNISpecification), true);
    }

    public JNIMistMessage(String string, String string2, JNIConfig jNIConfig, JNISpecification jNISpecification) throws GMSEC_Exception {
        this(gmsecJNI.new_MistMessageWithConfig(string, string2, JNIConfig.getCPtr(jNIConfig), jNIConfig, JNISpecification.getCPtr(jNISpecification), jNISpecification), true);
    }

    public JNIMistMessage(String string) throws GMSEC_Exception {
        this(gmsecJNI.new_MistMessageWithData(string), true);
    }

    public JNIMistMessage(JNIMistMessage jNIMistMessage) {
        this(gmsecJNI.new_MistMessageCopy(JNIMistMessage.getCPtr(jNIMistMessage), jNIMistMessage), true);
    }

    public String getSchemaID() {
        return gmsecJNI.MistMessageGetSchemaID(this.swigCPtr, this);
    }

    public void setValue(String string, String string2) throws GMSEC_Exception {
        gmsecJNI.MistMessageSetValueString(this.swigCPtr, this, string, string2);
    }

    public void setValue(String string, long l) throws GMSEC_Exception {
        gmsecJNI.MistMessageSetValueLong(this.swigCPtr, this, string, l);
    }

    public void setValue(String string, double d) throws GMSEC_Exception {
        gmsecJNI.MistMessageSetValueDouble(this.swigCPtr, this, string, d);
    }
}

