/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.jni.mist;

import gov.nasa.gsfc.gmsec.api.GMSEC_Exception;
import gov.nasa.gsfc.gmsec.api.jni.JNIConfig;
import gov.nasa.gsfc.gmsec.api.jni.JNIMessage;
import gov.nasa.gsfc.gmsec.api.jni.gmsecJNI;
import gov.nasa.gsfc.gmsec.api.jni.mist.JNISchemaIDIterator;
import gov.nasa.gsfc.gmsec.api.mist.SchemaIDIterator;

public class JNISpecification {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected JNISpecification(long l, boolean bl) {
        this.swigCPtr = l;
        this.swigCMemOwn = bl;
    }

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            gmsecJNI.delete_Specification(this.swigCPtr, this);
            this.swigCMemOwn = false;
        }
        this.swigCPtr = 0L;
    }

    public static long getCPtr(JNISpecification jNISpecification) {
        return jNISpecification == null ? 0L : jNISpecification.swigCPtr;
    }

    public JNISpecification(JNIConfig jNIConfig) throws GMSEC_Exception {
        this(gmsecJNI.new_Specification(JNIConfig.getCPtr(jNIConfig), jNIConfig), true);
    }

    public JNISpecification(JNISpecification jNISpecification) throws GMSEC_Exception {
        this(gmsecJNI.new_Specification_Copy(JNISpecification.getCPtr(jNISpecification), jNISpecification), true);
    }

    public void validateMessage(JNIMessage jNIMessage) {
        gmsecJNI.Specification_ValidateMessage(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage);
    }

    public SchemaIDIterator getSchemaIDIterator() {
        long l = gmsecJNI.Specification_GetSchemaIDIterator(this.swigCPtr, this);
        return new SchemaIDIterator(new JNISchemaIDIterator(l, false));
    }

    public int getVersion() {
        return gmsecJNI.Specification_GetVersion(this.swigCPtr, this);
    }

    public String getTemplateXML(String string, String string2) {
        return gmsecJNI.Specification_GetTemplateXML(this.swigCPtr, this, string, string2);
    }
}

