/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.jni;

import gov.nasa.gsfc.gmsec.api.Config;
import gov.nasa.gsfc.gmsec.api.GMSEC_Exception;
import gov.nasa.gsfc.gmsec.api.Message;
import gov.nasa.gsfc.gmsec.api.MessageFieldIterator;
import gov.nasa.gsfc.gmsec.api.U16;
import gov.nasa.gsfc.gmsec.api.U32;
import gov.nasa.gsfc.gmsec.api.U64;
import gov.nasa.gsfc.gmsec.api.U8;
import gov.nasa.gsfc.gmsec.api.field.BinaryField;
import gov.nasa.gsfc.gmsec.api.field.BooleanField;
import gov.nasa.gsfc.gmsec.api.field.CharField;
import gov.nasa.gsfc.gmsec.api.field.F32Field;
import gov.nasa.gsfc.gmsec.api.field.F64Field;
import gov.nasa.gsfc.gmsec.api.field.Field;
import gov.nasa.gsfc.gmsec.api.field.I16Field;
import gov.nasa.gsfc.gmsec.api.field.I32Field;
import gov.nasa.gsfc.gmsec.api.field.I64Field;
import gov.nasa.gsfc.gmsec.api.field.I8Field;
import gov.nasa.gsfc.gmsec.api.field.StringField;
import gov.nasa.gsfc.gmsec.api.field.U16Field;
import gov.nasa.gsfc.gmsec.api.field.U32Field;
import gov.nasa.gsfc.gmsec.api.field.U64Field;
import gov.nasa.gsfc.gmsec.api.field.U8Field;
import gov.nasa.gsfc.gmsec.api.jni.JNIBinaryField;
import gov.nasa.gsfc.gmsec.api.jni.JNIBooleanField;
import gov.nasa.gsfc.gmsec.api.jni.JNICharField;
import gov.nasa.gsfc.gmsec.api.jni.JNIConfig;
import gov.nasa.gsfc.gmsec.api.jni.JNIF32Field;
import gov.nasa.gsfc.gmsec.api.jni.JNIF64Field;
import gov.nasa.gsfc.gmsec.api.jni.JNIFieldConverter;
import gov.nasa.gsfc.gmsec.api.jni.JNII16Field;
import gov.nasa.gsfc.gmsec.api.jni.JNII32Field;
import gov.nasa.gsfc.gmsec.api.jni.JNII64Field;
import gov.nasa.gsfc.gmsec.api.jni.JNII8Field;
import gov.nasa.gsfc.gmsec.api.jni.JNIMessageFieldIterator;
import gov.nasa.gsfc.gmsec.api.jni.JNIStringField;
import gov.nasa.gsfc.gmsec.api.jni.JNIU16Field;
import gov.nasa.gsfc.gmsec.api.jni.JNIU32Field;
import gov.nasa.gsfc.gmsec.api.jni.JNIU64Field;
import gov.nasa.gsfc.gmsec.api.jni.JNIU8Field;
import gov.nasa.gsfc.gmsec.api.jni.gmsecJNI;

public class JNIMessage {
    protected long swigCPtr;
    protected boolean swigCMemOwn;

    public JNIMessage(long l, boolean bl) {
        this.swigCPtr = l;
        this.swigCMemOwn = bl;
    }

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            gmsecJNI.delete_Message(this.swigCPtr, this);
            this.swigCMemOwn = false;
        }
        this.swigCPtr = 0L;
    }

    public static long getCPtr(JNIMessage jNIMessage) {
        return jNIMessage == null ? 0L : jNIMessage.swigCPtr;
    }

    public JNIMessage(String string, Message.MessageKind messageKind) {
        this(gmsecJNI.new_Message(string, messageKind.ordinal()), true);
    }

    public JNIMessage(String string, Message.MessageKind messageKind, Config config) {
        this(gmsecJNI.new_Message(string, messageKind.ordinal(), JNIConfig.getCPtr(Config.getInternal(config)), Config.getInternal(config)), true);
    }

    public JNIMessage(String string) throws GMSEC_Exception {
        this(gmsecJNI.new_Message(string), true);
    }

    public JNIMessage(JNIMessage jNIMessage) {
        this(gmsecJNI.new_Message_Copy(JNIMessage.getCPtr(jNIMessage), jNIMessage), true);
    }

    public void addConfig(Config config) {
        JNIConfig jNIConfig = new JNIConfig(config);
        gmsecJNI.Message_AddConfig(this.swigCPtr, this, JNIConfig.getCPtr(jNIConfig), jNIConfig);
    }

    public Config getConfig() {
        long l = gmsecJNI.Message_GetConfig(this.swigCPtr, this);
        return new Config(new JNIConfig(l, false));
    }

    public String getSubject() {
        return gmsecJNI.Message_GetSubject(this.swigCPtr, this);
    }

    public Message.MessageKind getKind() {
        int n = gmsecJNI.Message_GetKind(this.swigCPtr, this);
        return Message.MessageKind.values()[n];
    }

    public boolean addField(Field field) {
        Field.FieldType fieldType = field.getType();
        boolean bl = false;
        switch (fieldType) {
            case BIN_TYPE: {
                JNIBinaryField jNIBinaryField = (JNIBinaryField)Field.getInternal(field);
                bl = gmsecJNI.Message_AddField(this.swigCPtr, this, JNIBinaryField.getCPtr(jNIBinaryField), jNIBinaryField);
                break;
            }
            case BOOL_TYPE: {
                JNIBooleanField jNIBooleanField = (JNIBooleanField)Field.getInternal(field);
                bl = gmsecJNI.Message_AddField(this.swigCPtr, this, JNIBooleanField.getCPtr(jNIBooleanField), jNIBooleanField);
                break;
            }
            case CHAR_TYPE: {
                JNICharField jNICharField = (JNICharField)Field.getInternal(field);
                bl = gmsecJNI.Message_AddField(this.swigCPtr, this, JNICharField.getCPtr(jNICharField), jNICharField);
                break;
            }
            case F32_TYPE: {
                JNIF32Field jNIF32Field = (JNIF32Field)Field.getInternal(field);
                bl = gmsecJNI.Message_AddField(this.swigCPtr, this, JNIF32Field.getCPtr(jNIF32Field), jNIF32Field);
                break;
            }
            case F64_TYPE: {
                JNIF64Field jNIF64Field = (JNIF64Field)Field.getInternal(field);
                bl = gmsecJNI.Message_AddField(this.swigCPtr, this, JNIF64Field.getCPtr(jNIF64Field), jNIF64Field);
                break;
            }
            case I8_TYPE: {
                JNII8Field jNII8Field = (JNII8Field)Field.getInternal(field);
                bl = gmsecJNI.Message_AddField(this.swigCPtr, this, JNII8Field.getCPtr(jNII8Field), jNII8Field);
                break;
            }
            case I16_TYPE: {
                JNII16Field jNII16Field = (JNII16Field)Field.getInternal(field);
                bl = gmsecJNI.Message_AddField(this.swigCPtr, this, JNII16Field.getCPtr(jNII16Field), jNII16Field);
                break;
            }
            case I32_TYPE: {
                JNII32Field jNII32Field = (JNII32Field)Field.getInternal(field);
                bl = gmsecJNI.Message_AddField(this.swigCPtr, this, JNII32Field.getCPtr(jNII32Field), jNII32Field);
                break;
            }
            case I64_TYPE: {
                JNII64Field jNII64Field = (JNII64Field)Field.getInternal(field);
                bl = gmsecJNI.Message_AddField(this.swigCPtr, this, JNII64Field.getCPtr(jNII64Field), jNII64Field);
                break;
            }
            case U8_TYPE: {
                JNIU8Field jNIU8Field = (JNIU8Field)Field.getInternal(field);
                bl = gmsecJNI.Message_AddField(this.swigCPtr, this, JNIU8Field.getCPtr(jNIU8Field), jNIU8Field);
                break;
            }
            case U16_TYPE: {
                JNIU16Field jNIU16Field = (JNIU16Field)Field.getInternal(field);
                bl = gmsecJNI.Message_AddField(this.swigCPtr, this, JNIU16Field.getCPtr(jNIU16Field), jNIU16Field);
                break;
            }
            case U32_TYPE: {
                JNIU32Field jNIU32Field = (JNIU32Field)Field.getInternal(field);
                bl = gmsecJNI.Message_AddField(this.swigCPtr, this, JNIU32Field.getCPtr(jNIU32Field), jNIU32Field);
                break;
            }
            case U64_TYPE: {
                JNIU64Field jNIU64Field = (JNIU64Field)Field.getInternal(field);
                bl = gmsecJNI.Message_AddField(this.swigCPtr, this, JNIU64Field.getCPtr(jNIU64Field), jNIU64Field);
                break;
            }
            case STRING_TYPE: {
                JNIStringField jNIStringField = (JNIStringField)Field.getInternal(field);
                bl = gmsecJNI.Message_AddField(this.swigCPtr, this, JNIStringField.getCPtr(jNIStringField), jNIStringField);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean addField(String string, byte[] byArray) {
        return this.addField(new BinaryField(string, byArray));
    }

    public boolean addField(String string, boolean bl) {
        return this.addField(new BooleanField(string, bl));
    }

    public boolean addField(String string, char c) {
        return this.addField(new CharField(string, c));
    }

    public boolean addField(String string, byte by) {
        return this.addField(new I8Field(string, by));
    }

    public boolean addField(String string, short s) {
        return this.addField(new I16Field(string, s));
    }

    public boolean addField(String string, int n) {
        return this.addField(new I32Field(string, n));
    }

    public boolean addField(String string, long l) {
        return this.addField(new I64Field(string, l));
    }

    public boolean addField(String string, float f) {
        return this.addField(new F32Field(string, f));
    }

    public boolean addField(String string, double d) {
        return this.addField(new F64Field(string, d));
    }

    public boolean addField(String string, String string2) {
        return this.addField(new StringField(string, string2));
    }

    public boolean addField(String string, U8 u8) {
        return this.addField(new U8Field(string, u8));
    }

    public boolean addField(String string, U16 u16) {
        return this.addField(new U16Field(string, u16));
    }

    public boolean addField(String string, U32 u32) {
        return this.addField(new U32Field(string, u32));
    }

    public boolean addField(String string, U64 u64) {
        return this.addField(new U64Field(string, u64));
    }

    public void clearFields() {
        gmsecJNI.Message_ClearFields(this.swigCPtr, this);
    }

    public boolean clearField(String string) {
        return gmsecJNI.Message_ClearField(this.swigCPtr, this, string);
    }

    public long getIntegerValue(String string) throws GMSEC_Exception {
        return gmsecJNI.Message_GetIntegerValue(this.swigCPtr, this, string);
    }

    public U64 getUnsignedIntegerValue(String string) throws GMSEC_Exception {
        return gmsecJNI.Message_GetUnsignedIntegerValue(this.swigCPtr, this, string);
    }

    public double getDoubleValue(String string) throws GMSEC_Exception {
        return gmsecJNI.Message_GetDoubleValue(this.swigCPtr, this, string);
    }

    public String getStringValue(String string) throws GMSEC_Exception {
        return gmsecJNI.Message_GetStringValue(this.swigCPtr, this, string);
    }

    public Field getField(String string) {
        long l = gmsecJNI.Message_GetField(this.swigCPtr, this, string);
        return JNIFieldConverter.createFieldReference(l);
    }

    public Field.FieldType getFieldType(String string) throws GMSEC_Exception {
        int n = gmsecJNI.Message_GetFieldType(this.swigCPtr, this, string);
        return Field.FieldType.values()[n];
    }

    public BinaryField getBinaryField(String string) throws GMSEC_Exception {
        long l = gmsecJNI.Message_GetBinaryField(this.swigCPtr, this, string);
        return new BinaryField(new JNIBinaryField(l, false));
    }

    public BooleanField getBooleanField(String string) throws GMSEC_Exception {
        long l = gmsecJNI.Message_GetBooleanField(this.swigCPtr, this, string);
        return new BooleanField(new JNIBooleanField(l, false));
    }

    public CharField getCharField(String string) throws GMSEC_Exception {
        long l = gmsecJNI.Message_GetCharField(this.swigCPtr, this, string);
        return new CharField(new JNICharField(l, false));
    }

    public F32Field getF32Field(String string) throws GMSEC_Exception {
        long l = gmsecJNI.Message_GetF32Field(this.swigCPtr, this, string);
        return new F32Field(new JNIF32Field(l, false));
    }

    public F64Field getF64Field(String string) throws GMSEC_Exception {
        long l = gmsecJNI.Message_GetF64Field(this.swigCPtr, this, string);
        return new F64Field(new JNIF64Field(l, false));
    }

    public I8Field getI8Field(String string) throws GMSEC_Exception {
        long l = gmsecJNI.Message_GetI8Field(this.swigCPtr, this, string);
        return new I8Field(new JNII8Field(l, false));
    }

    public I16Field getI16Field(String string) throws GMSEC_Exception {
        long l = gmsecJNI.Message_GetI16Field(this.swigCPtr, this, string);
        return new I16Field(new JNII16Field(l, false));
    }

    public I32Field getI32Field(String string) throws GMSEC_Exception {
        long l = gmsecJNI.Message_GetI32Field(this.swigCPtr, this, string);
        return new I32Field(new JNII32Field(l, false));
    }

    public I64Field getI64Field(String string) throws GMSEC_Exception {
        long l = gmsecJNI.Message_GetI64Field(this.swigCPtr, this, string);
        return new I64Field(new JNII64Field(l, false));
    }

    public U8Field getU8Field(String string) throws GMSEC_Exception {
        long l = gmsecJNI.Message_GetU8Field(this.swigCPtr, this, string);
        return new U8Field(new JNIU8Field(l, false));
    }

    public U16Field getU16Field(String string) throws GMSEC_Exception {
        long l = gmsecJNI.Message_GetU16Field(this.swigCPtr, this, string);
        return new U16Field(new JNIU16Field(l, false));
    }

    public U32Field getU32Field(String string) throws GMSEC_Exception {
        long l = gmsecJNI.Message_GetU32Field(this.swigCPtr, this, string);
        return new U32Field(new JNIU32Field(l, false));
    }

    public U64Field getU64Field(String string) throws GMSEC_Exception {
        long l = gmsecJNI.Message_GetU64Field(this.swigCPtr, this, string);
        return new U64Field(new JNIU64Field(l, false));
    }

    public StringField getStringField(String string) throws GMSEC_Exception {
        long l = gmsecJNI.Message_GetStringField(this.swigCPtr, this, string);
        return new StringField(new JNIStringField(l, false));
    }

    public int getFieldCount() {
        return gmsecJNI.Message_GetFieldCount(this.swigCPtr, this);
    }

    public void copyFields(JNIMessage jNIMessage) {
        gmsecJNI.Message_CopyFields(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage);
    }

    public String toXML() {
        return gmsecJNI.Message_ToXML(this.swigCPtr, this);
    }

    public String toJSON() {
        return gmsecJNI.Message_ToJSON(this.swigCPtr, this);
    }

    public long getSize() {
        return gmsecJNI.Message_GetSize(this.swigCPtr, this);
    }

    public MessageFieldIterator getFieldIterator() {
        long l = gmsecJNI.Message_GetFieldIterator(this.swigCPtr, this, MessageFieldIterator.Selector.ALL_FIELDS.ordinal());
        return new MessageFieldIterator(new JNIMessageFieldIterator(l, false));
    }

    public MessageFieldIterator getFieldIterator(MessageFieldIterator.Selector selector) {
        long l = gmsecJNI.Message_GetFieldIterator(this.swigCPtr, this, selector.ordinal());
        return new MessageFieldIterator(new JNIMessageFieldIterator(l, false));
    }
}

