/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.jni;

import gov.nasa.gsfc.gmsec.api.field.BinaryField;
import gov.nasa.gsfc.gmsec.api.field.BooleanField;
import gov.nasa.gsfc.gmsec.api.field.CharField;
import gov.nasa.gsfc.gmsec.api.field.F32Field;
import gov.nasa.gsfc.gmsec.api.field.F64Field;
import gov.nasa.gsfc.gmsec.api.field.Field;
import gov.nasa.gsfc.gmsec.api.field.I16Field;
import gov.nasa.gsfc.gmsec.api.field.I32Field;
import gov.nasa.gsfc.gmsec.api.field.I64Field;
import gov.nasa.gsfc.gmsec.api.field.I8Field;
import gov.nasa.gsfc.gmsec.api.field.StringField;
import gov.nasa.gsfc.gmsec.api.field.U16Field;
import gov.nasa.gsfc.gmsec.api.field.U32Field;
import gov.nasa.gsfc.gmsec.api.field.U64Field;
import gov.nasa.gsfc.gmsec.api.field.U8Field;
import gov.nasa.gsfc.gmsec.api.jni.JNIBinaryField;
import gov.nasa.gsfc.gmsec.api.jni.JNIBooleanField;
import gov.nasa.gsfc.gmsec.api.jni.JNICharField;
import gov.nasa.gsfc.gmsec.api.jni.JNIF32Field;
import gov.nasa.gsfc.gmsec.api.jni.JNIF64Field;
import gov.nasa.gsfc.gmsec.api.jni.JNII16Field;
import gov.nasa.gsfc.gmsec.api.jni.JNII32Field;
import gov.nasa.gsfc.gmsec.api.jni.JNII64Field;
import gov.nasa.gsfc.gmsec.api.jni.JNII8Field;
import gov.nasa.gsfc.gmsec.api.jni.JNIStringField;
import gov.nasa.gsfc.gmsec.api.jni.JNIU16Field;
import gov.nasa.gsfc.gmsec.api.jni.JNIU32Field;
import gov.nasa.gsfc.gmsec.api.jni.JNIU64Field;
import gov.nasa.gsfc.gmsec.api.jni.JNIU8Field;
import gov.nasa.gsfc.gmsec.api.jni.gmsecJNI;

public class JNIFieldConverter {
    public static Field createFieldReference(long l) {
        Field field = null;
        if (l != 0L) {
            int n = gmsecJNI.Field_GetType(l, null);
            Field.FieldType fieldType = Field.FieldType.values()[n];
            switch (fieldType) {
                case BIN_TYPE: {
                    field = new BinaryField(new JNIBinaryField(l, false));
                    break;
                }
                case BOOL_TYPE: {
                    field = new BooleanField(new JNIBooleanField(l, false));
                    break;
                }
                case CHAR_TYPE: {
                    field = new CharField(new JNICharField(l, false));
                    break;
                }
                case F32_TYPE: {
                    field = new F32Field(new JNIF32Field(l, false));
                    break;
                }
                case F64_TYPE: {
                    field = new F64Field(new JNIF64Field(l, false));
                    break;
                }
                case I8_TYPE: {
                    field = new I8Field(new JNII8Field(l, false));
                    break;
                }
                case I16_TYPE: {
                    field = new I16Field(new JNII16Field(l, false));
                    break;
                }
                case I32_TYPE: {
                    field = new I32Field(new JNII32Field(l, false));
                    break;
                }
                case I64_TYPE: {
                    field = new I64Field(new JNII64Field(l, false));
                    break;
                }
                case U8_TYPE: {
                    field = new U8Field(new JNIU8Field(l, false));
                    break;
                }
                case U16_TYPE: {
                    field = new U16Field(new JNIU16Field(l, false));
                    break;
                }
                case U32_TYPE: {
                    field = new U32Field(new JNIU32Field(l, false));
                    break;
                }
                case U64_TYPE: {
                    field = new U64Field(new JNIU64Field(l, false));
                    break;
                }
                case STRING_TYPE: {
                    field = new StringField(new JNIStringField(l, false));
                }
            }
        }
        return field;
    }
}

