/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.jni;

import gov.nasa.gsfc.gmsec.api.U64;
import gov.nasa.gsfc.gmsec.api.field.Field;
import gov.nasa.gsfc.gmsec.api.jni.gmsecJNI;

public class JNIField {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected JNIField(long l, boolean bl) {
        this.swigCPtr = l;
        this.swigCMemOwn = bl;
    }

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            gmsecJNI.delete_Field(this.swigCPtr, this);
            this.swigCMemOwn = false;
        }
        this.swigCPtr = 0L;
    }

    public static long getCPtr(JNIField jNIField) {
        return jNIField == null ? 0L : jNIField.swigCPtr;
    }

    public String getName() {
        return gmsecJNI.Field_GetName(this.swigCPtr, this);
    }

    public Field.FieldType getType() {
        int n = gmsecJNI.Field_GetType(this.swigCPtr, this);
        return Field.FieldType.values()[n];
    }

    public String toXML() {
        return gmsecJNI.Field_ToXML(this.swigCPtr, this);
    }

    public String toJSON() {
        return gmsecJNI.Field_ToJSON(this.swigCPtr, this);
    }

    public long getIntegerValue() {
        return gmsecJNI.Field_GetIntegerValue(this.swigCPtr, this);
    }

    public U64 getUnsignedIntegerValue() {
        return gmsecJNI.Field_GetUnsignedIntegerValue(this.swigCPtr, this);
    }

    public double getDoubleValue() {
        return gmsecJNI.Field_GetDoubleValue(this.swigCPtr, this);
    }

    public String getStringValue() {
        return gmsecJNI.Field_GetStringValue(this.swigCPtr, this);
    }

    public void isHeader(boolean bl) {
        gmsecJNI.Field_IsHeader(this.swigCPtr, this, bl);
    }

    public boolean isHeader() {
        return gmsecJNI.Field_IsHeader(this.swigCPtr, this);
    }
}

