/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.jni;

import gov.nasa.gsfc.gmsec.api.Config;
import gov.nasa.gsfc.gmsec.api.ConfigFileIterator;
import gov.nasa.gsfc.gmsec.api.Message;
import gov.nasa.gsfc.gmsec.api.jni.JNIConfig;
import gov.nasa.gsfc.gmsec.api.jni.JNIConfigFileIterator;
import gov.nasa.gsfc.gmsec.api.jni.JNIMessage;
import gov.nasa.gsfc.gmsec.api.jni.gmsecJNI;

public class JNIConfigFile {
    private long swigCPtr;
    private boolean swigCMemOwn;

    protected JNIConfigFile(long l, boolean bl) {
        this.swigCPtr = l;
        this.swigCMemOwn = bl;
    }

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            gmsecJNI.delete_ConfigFile(this.swigCPtr, this);
            this.swigCMemOwn = false;
        }
        this.swigCPtr = 0L;
    }

    protected static long getCPtr(JNIConfigFile jNIConfigFile) {
        return jNIConfigFile == null ? 0L : jNIConfigFile.swigCPtr;
    }

    public JNIConfigFile() {
        this(gmsecJNI.new_ConfigFile(), true);
    }

    public void load(String string) {
        gmsecJNI.ConfigFile_Load(this.swigCPtr, this, string);
    }

    public void save(String string, boolean bl) {
        gmsecJNI.ConfigFile_Save(this.swigCPtr, this, string, bl);
    }

    public void fromXML(String string) {
        gmsecJNI.ConfigFile_FromXML(this.swigCPtr, this, string);
    }

    public String toXML() {
        return gmsecJNI.ConfigFile_ToXML(this.swigCPtr, this);
    }

    public boolean isLoaded() {
        return gmsecJNI.ConfigFile_IsLoaded(this.swigCPtr, this);
    }

    public Config lookupConfig(String string) {
        long l = gmsecJNI.ConfigFile_LookupConfig(this.swigCPtr, this, string);
        if (l != 0L) {
            return new Config(new JNIConfig(l, true));
        }
        return null;
    }

    public Message lookupMessage(String string) {
        long l = gmsecJNI.ConfigFile_LookupMessage(this.swigCPtr, this, string);
        if (l != 0L) {
            return new Message(new JNIMessage(l, true));
        }
        return null;
    }

    public String lookupSubscription(String string) {
        return gmsecJNI.ConfigFile_LookupSubscription(this.swigCPtr, this, string);
    }

    public void addSubscription(String string, String string2) {
        gmsecJNI.ConfigFile_AddSubscription(this.swigCPtr, this, string, string2);
    }

    public void addConfig(String string, Config config) {
        JNIConfig jNIConfig = Config.getInternal(config);
        gmsecJNI.ConfigFile_AddConfig(this.swigCPtr, this, string, JNIConfig.getCPtr(jNIConfig), jNIConfig);
    }

    public void addMessage(String string, Message message) {
        JNIMessage jNIMessage = Message.getInternal(message);
        gmsecJNI.ConfigFile_AddMessage(this.swigCPtr, this, string, JNIMessage.getCPtr(jNIMessage), jNIMessage);
    }

    public void addCustomXML(String string) {
        gmsecJNI.ConfigFile_AddCustomXML(this.swigCPtr, this, string);
    }

    public boolean removeSubscription(String string) {
        return gmsecJNI.ConfigFile_RemoveSubscription(this.swigCPtr, this, string);
    }

    public boolean removeConfig(String string) {
        return gmsecJNI.ConfigFile_RemoveConfig(this.swigCPtr, this, string);
    }

    public boolean removeMessage(String string) {
        return gmsecJNI.ConfigFile_RemoveMessage(this.swigCPtr, this, string);
    }

    public boolean removeCustomXML(String string) {
        return gmsecJNI.ConfigFile_RemoveCustomXML(this.swigCPtr, this, string);
    }

    public ConfigFileIterator getIterator() {
        long l = gmsecJNI.ConfigFile_GetIterator(this.swigCPtr, this);
        return new ConfigFileIterator(new JNIConfigFileIterator(l, false));
    }
}

