/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api;

import java.math.BigInteger;

public class U64 {
    private BigInteger value;
    public static final BigInteger MIN_VALUE = BigInteger.ZERO;
    public static final BigInteger MAX_VALUE = new BigInteger("18446744073709551615");

    private BigInteger checkRange(BigInteger bigInteger) throws IllegalArgumentException {
        if (bigInteger == null) {
            throw new IllegalArgumentException("BigInteger value is null");
        }
        if (bigInteger.compareTo(MIN_VALUE) == -1) {
            throw new IllegalArgumentException("Value is less than U64.MIN_VALUE");
        }
        if (bigInteger.compareTo(MAX_VALUE) == 1) {
            throw new IllegalArgumentException("Value is greater than U64.MAX_VALUE");
        }
        return bigInteger;
    }

    public U64() {
        this.value = MIN_VALUE;
    }

    public U64(BigInteger bigInteger) throws IllegalArgumentException {
        this.value = this.checkRange(bigInteger);
    }

    public U64(String string) throws IllegalArgumentException {
        this.value = this.checkRange(new BigInteger(string));
    }

    public U64(U64 u64) throws IllegalArgumentException {
        if (u64 == null) {
            throw new IllegalArgumentException("U64 object is null");
        }
        this.value = u64.get();
    }

    public void set(BigInteger bigInteger) throws IllegalArgumentException {
        this.value = this.checkRange(bigInteger);
    }

    public BigInteger get() {
        return this.value;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.value.toString());
        return stringBuffer.toString();
    }
}

