/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api;

import gov.nasa.gsfc.gmsec.api.StatusClassification;
import gov.nasa.gsfc.gmsec.api.StatusCode;

public class GMSEC_Exception
extends Exception {
    private StatusClassification m_errorClass;
    private StatusCode m_errorCode;
    private int m_customCode;
    private String m_errorMsg;

    public GMSEC_Exception(String string) {
        String[] stringArray = string.split(":");
        if (stringArray.length >= 2) {
            int n;
            int n2 = stringArray[0].indexOf(91);
            String string2 = stringArray[0].substring(n2 + 1, n = stringArray[0].indexOf(93));
            String[] stringArray2 = string2.split(",");
            if (stringArray2.length == 3) {
                this.m_errorClass = StatusClassification.getUsingValue(Integer.parseInt(stringArray2[0]));
                this.m_errorCode = StatusCode.getUsingValue(Integer.parseInt(stringArray2[1]));
                this.m_customCode = Integer.parseInt(stringArray2[2]);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder.append(stringArray[i].trim());
                if (i >= stringArray.length - 1) continue;
                stringBuilder.append(": ");
            }
            this.m_errorMsg = stringBuilder.toString();
        }
    }

    public GMSEC_Exception(StatusClassification statusClassification, StatusCode statusCode, String string) {
        this.m_errorClass = statusClassification;
        this.m_errorCode = statusCode;
        this.m_customCode = 0;
        this.m_errorMsg = string;
    }

    public GMSEC_Exception(StatusClassification statusClassification, StatusCode statusCode, int n, String string) {
        this.m_errorClass = statusClassification;
        this.m_errorCode = statusCode;
        this.m_customCode = n;
        this.m_errorMsg = string;
    }

    public StatusClassification getErrorClassification() {
        return this.m_errorClass;
    }

    public StatusCode getErrorCode() {
        return this.m_errorCode;
    }

    public int getCustomCode() {
        return this.m_customCode;
    }

    public String getErrorMessage() {
        return this.m_errorMsg;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(this.m_errorClass.getValue()).append(",").append(this.m_errorCode.getValue()).append(",").append(this.m_customCode).append("] : ").append(this.m_errorMsg);
        return stringBuilder.toString();
    }
}

