/*
 * Decompiled with CFR 0.152.
 */
package bolt;

import bolt.Client;
import bolt.Distributor;
import bolt.Log;
import bolt.Message;
import bolt.MessageType;
import bolt.Meta;
import bolt.Processor;
import bolt.Property;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;

class RealProcessor
extends Thread
implements Processor {
    private static final Logger source = Log.createSource("Processor");
    private LinkedBlockingQueue<Message> queue = new LinkedBlockingQueue(16);
    private Distributor distributor;
    private Map<MessageType, Handler> handlers = new HashMap<MessageType, Handler>();

    RealProcessor() {
        this.handlers.put(MessageType.ECHO, new Handler(){

            @Override
            public boolean handle(Message message) {
                Message message2 = new Message(message.getHeader(), message.getMeta(), null);
                message.getClient().output(message2);
                return true;
            }
        });
        this.handlers.put(MessageType.NEGOTIATE, new Handler(){

            @Override
            public boolean handle(Message message) {
                return RealProcessor.this.negotiate(message);
            }
        });
        this.handlers.put(MessageType.SUBSCRIBE, new Handler(){

            @Override
            public boolean handle(Message message) {
                return message.getClient().subscribe(message);
            }
        });
        this.handlers.put(MessageType.UNSUBSCRIBE, new Handler(){

            @Override
            public boolean handle(Message message) {
                message.getClient().unsubscribe(message.getMeta().getTopic());
                return true;
            }
        });
        Handler handler = new Handler(){

            @Override
            public boolean handle(Message message) {
                return RealProcessor.this.distribute(message);
            }
        };
        this.handlers.put(MessageType.PUBLISH, handler);
        this.handlers.put(MessageType.REQUEST, handler);
        this.handlers.put(MessageType.REPLY, handler);
    }

    void setDistributor(Distributor distributor) {
        this.distributor = distributor;
    }

    @Override
    public void enqueue(Message message) {
        try {
            this.queue.put(message);
        }
        catch (InterruptedException interruptedException) {
            Log.exception(source, interruptedException);
        }
    }

    @Override
    public void run() {
        double d = 0.0;
        int n = 0;
        while (true) {
            try {
                while (true) {
                    Message message;
                    if ((message = this.queue.take()).getHeader().getType() == MessageType.PUBLISH) {
                        message.procTime = System.nanoTime();
                        d += (double)(message.procTime - message.rxTime);
                        if (++n % 1000 == 0) {
                            System.out.format("procTime: after %d, mean procTime=%.2f [ms]\n", n, d / (double)n / 1000000.0);
                        }
                    }
                    this.dispatch(message);
                }
            }
            catch (Exception exception) {
                Log.exception(source, exception);
                continue;
            }
            break;
        }
    }

    private void dispatch(Message message) {
        MessageType messageType = message.getHeader().getType();
        Handler handler = this.handlers.get((Object)messageType);
        if (handler == null) {
            Log.warning(source, "no handler for type " + (Object)((Object)messageType));
        } else {
            handler.handle(message);
        }
    }

    boolean negotiate(Message message) {
        Meta meta = message.getMeta();
        if (meta == null) {
            message.getClient().output(message.makeAck());
            return true;
        }
        Client.Options options = message.getClient().getOptions();
        for (Property property : meta.getProperties()) {
            String string = property.getName();
            if (string.equalsIgnoreCase("maxMessageSize")) {
                options.maxMessageSize = property.asInteger();
                continue;
            }
            if (string.equalsIgnoreCase("inputBufferSize")) {
                options.inputBufferSize = property.asInteger();
                continue;
            }
            if (string.equalsIgnoreCase("outputBufferSize")) {
                options.outputBufferSize = property.asInteger();
                continue;
            }
            Log.warning(source, "unhandled option " + property);
        }
        message.getClient().output(message.makeAck());
        return true;
    }

    boolean distribute(Message message) {
        Meta meta = message.getMeta();
        if (meta == null) {
            Log.warning(source, "distribute: null meta");
            return false;
        }
        String string = meta.getTopic();
        if (string == null) {
            Log.warning(source, "distribute: null topic");
            return false;
        }
        this.distributor.enqueue(message);
        return true;
    }

    static interface Handler {
        public boolean handle(Message var1);
    }
}

