/*
 * Decompiled with CFR 0.152.
 */
package bolt;

import bolt.Client;
import bolt.Distributor;
import bolt.Log;
import bolt.Message;
import bolt.MessageType;
import bolt.Topic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;

class RealDistributor
implements Distributor {
    static final String STAR = "*";
    static final String ANGLE = ">";
    static final String PLUS = "+";
    private static Logger source = Log.createSource("Distributor");
    private LinkedBlockingQueue<Message> queue = new LinkedBlockingQueue(16);
    private Group distribution = new Group();
    private int count = 0;
    private double totalDt = 0.0;

    RealDistributor() {
    }

    @Override
    public synchronized String subscribe(Client client, String string) {
        String[] stringArray = Topic.getElements(string);
        if (!Topic.areValidElements(stringArray, true)) {
            return "invalid topic: " + string;
        }
        Group group = this.getGroup(stringArray, true);
        boolean bl = false;
        if (group.clients != null) {
            if (group.clients.contains(client)) {
                bl = true;
            } else {
                group.clients.add(client);
            }
        } else if (group.client == null) {
            group.client = client;
        } else if (group.client.equals(client)) {
            bl = true;
        } else {
            group.clients = new ArrayList<Client>(4);
            group.clients.add(group.client);
            group.clients.add(client);
            group.client = null;
        }
        if (bl) {
            return "duplicate subscription " + string;
        }
        return null;
    }

    @Override
    public synchronized void unsubscribe(Client client, String string) {
        String[] stringArray = Topic.getElements(string);
        Group group = this.getGroup(stringArray, false);
        boolean bl = false;
        if (group == null) {
            bl = true;
        } else if (group.clients != null) {
            if (!group.clients.remove(client)) {
                bl = true;
            }
        } else if (group.client.equals(client)) {
            group.client = null;
        } else {
            bl = true;
        }
        if (bl) {
            Log.warning(source, "unsubscribe: client not subscribed to " + string);
        } else {
            Log.detail(source, "unsubscribe: client unsubscribed from " + string);
        }
    }

    private Group getGroup(String[] stringArray, boolean bl) {
        Group group = this.distribution;
        for (int i = 0; i < stringArray.length; ++i) {
            Group group2;
            String string = stringArray[i];
            if (group.subgroups == null) {
                if (bl) {
                    group.subgroups = new HashMap<String, Group>(4);
                } else {
                    return null;
                }
            }
            if ((group2 = group.subgroups.get(string)) == null) {
                if (bl) {
                    group2 = new Group();
                    group.subgroups.put(string, group2);
                } else {
                    return null;
                }
            }
            group = group2;
        }
        return group;
    }

    @Override
    public synchronized void enqueue(Message message) {
        if (message.getHeader().getType() == MessageType.PUBLISH) {
            message.distTime = System.nanoTime();
            ++this.count;
            this.totalDt += (double)(message.distTime - message.procTime);
            if (this.count % 1000 == 0) {
                System.out.format("distTime: after %d, mean distTime=%.2f [ms]\n", this.count, this.totalDt / (double)this.count / 1000000.0);
            }
        }
        this.distribute(message);
    }

    private void addClients(Set<Client> set, Group group) {
        if (group.clients != null) {
            for (Client client : group.clients) {
                set.add(client);
            }
        } else if (group.client != null) {
            set.add(group.client);
        }
    }

    private void addClientsAux(Set<Client> set, String[] stringArray, Group group, int n) {
        if (n == stringArray.length - 1) {
            Group group2;
            this.addClients(set, group);
            if (group.subgroups != null && (group2 = group.subgroups.get(PLUS)) != null) {
                this.addClients(set, group2);
            }
        } else if (group.subgroups != null) {
            this.getClients(set, stringArray, group, n + 1);
        }
    }

    private void getClients(Set<Client> set, String[] stringArray, Group group, int n) {
        Group group2;
        Group group3;
        Group group4;
        String string = stringArray[n];
        Map<String, Group> map = group.subgroups;
        if (map == null) {
            return;
        }
        Group group5 = map.get(PLUS);
        if (group5 != null) {
            this.addClients(set, group5);
        }
        if ((group4 = map.get(ANGLE)) != null) {
            this.addClients(set, group4);
        }
        if ((group3 = map.get(STAR)) != null) {
            this.addClientsAux(set, stringArray, group3, n);
        }
        if ((group2 = map.get(string)) != null) {
            this.addClientsAux(set, stringArray, group2, n);
        }
    }

    private void distribute(Message message) {
        String string = message.getMeta().getTopic();
        String[] stringArray = Topic.getElements(string);
        if (!Topic.areValidElements(stringArray, false)) {
            Log.detail(source, "distribute: invalid topic " + string);
            return;
        }
        HashSet<Client> hashSet = new HashSet<Client>();
        this.getClients(hashSet, stringArray, this.distribution, 0);
        if (hashSet.size() == 0) {
            Log.detail(source, "distribute: no clients for " + string);
        }
        for (Client client : hashSet) {
            client.output(message);
        }
    }

    @Override
    public synchronized void prune(Client client) {
        Log.detail(source, "purge: not implemented");
    }

    private static class Group {
        Client client;
        List<Client> clients;
        Map<String, Group> subgroups;

        private Group() {
        }
    }
}

