/*
 * Decompiled with CFR 0.152.
 */
package bolt;

import bolt.IntegerProperty;
import bolt.PropertyType;
import bolt.StringProperty;

public abstract class Property {
    private String name;
    private PropertyType type;

    Property(String string) {
        this.name = string;
    }

    String getName() {
        return this.name;
    }

    PropertyType getType() {
        return this.type;
    }

    void setType(PropertyType propertyType) {
        this.type = propertyType;
    }

    public abstract int asInteger();

    public abstract String asString();

    public abstract double asDouble();

    abstract int dataSize();

    public static StringProperty createID(String string) {
        StringProperty stringProperty = new StringProperty("ID", string);
        stringProperty.setType(PropertyType.ID);
        return stringProperty;
    }

    public static StringProperty createTopic(String string) {
        StringProperty stringProperty = new StringProperty("TOPIC", string);
        stringProperty.setType(PropertyType.TOPIC);
        return stringProperty;
    }

    public static StringProperty createCorrID(String string) {
        StringProperty stringProperty = new StringProperty("CORR_ID", string);
        stringProperty.setType(PropertyType.CORR_ID);
        return stringProperty;
    }

    public static StringProperty createReplyTo(String string) {
        StringProperty stringProperty = new StringProperty("REPLY_TO", string);
        stringProperty.setType(PropertyType.REPLY_TO);
        return stringProperty;
    }

    public static StringProperty createSelector(String string) {
        StringProperty stringProperty = new StringProperty("SELECTOR", string);
        stringProperty.setType(PropertyType.SELECTOR);
        return stringProperty;
    }

    public static IntegerProperty createCompress(boolean bl) {
        IntegerProperty integerProperty = new IntegerProperty("COMPRESS", bl ? 1 : 0);
        integerProperty.setType(PropertyType.COMPRESS);
        return integerProperty;
    }

    public static StringProperty createError(String string) {
        StringProperty stringProperty = new StringProperty("ERROR", string);
        return stringProperty;
    }

    void getEncoding(Encoding encoding) {
        encoding.prefix = 1;
        encoding.count = this.dataSize();
        ++encoding.count;
        if (this.type.isNamed()) {
            encoding.count += this.name.length();
        }
        if (encoding.count < 256) {
            encoding.mode = Mode.SMALL;
            ++encoding.prefix;
        } else if (encoding.count < 65536) {
            encoding.mode = Mode.MEDIUM;
            encoding.prefix += 2;
        } else if (encoding.count < 0x1000000) {
            encoding.mode = Mode.LARGE;
            encoding.prefix += 3;
        } else {
            throw new IllegalStateException("excessive length: " + encoding.count);
        }
    }

    public static class Encoding {
        Mode mode;
        int prefix;
        int count;
    }

    static enum Mode {
        SMALL(0),
        MEDIUM(1),
        LARGE(2);

        private int mode;

        private Mode(int n2) {
            this.mode = n2;
        }

        int value() {
            return this.mode;
        }
    }
}

