/*
 * Decompiled with CFR 0.152.
 */
package bolt;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.regex.Pattern;

public class Log {
    static final Level MONITOR = Log.makeLevel("MONITOR", Level.WARNING, Level.INFO);
    static final Level ERROR = Log.makeLevel("ERROR", Level.SEVERE, Level.WARNING);
    static long last_ms;

    public static Logger createSource(String string) {
        return Logger.getLogger("bolt." + string);
    }

    public static void exception(Logger logger, Exception exception) {
        Log.exception(logger, exception, true);
    }

    public static void exception(Logger logger, Exception exception, boolean bl) {
        String string;
        if (bl) {
            StringBuilder stringBuilder = new StringBuilder(1024);
            stringBuilder.append(exception).append("\n");
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                stringBuilder.append(stackTraceElement).append("\n");
            }
            string = stringBuilder.toString();
        } else {
            string = exception.toString();
        }
        Log.log(Level.SEVERE, logger, string);
    }

    public static void error(Logger logger, String string) {
        Log.log(Level.SEVERE, logger, string);
    }

    public static void warning(Logger logger, String string) {
        Log.log(Level.WARNING, logger, string);
    }

    public static void monitor(Logger logger, String string) {
        Log.log(MONITOR, logger, string);
    }

    public static void setup(Logger logger, String string) {
        Log.log(Level.CONFIG, logger, string);
    }

    public static void info(Logger logger, String string) {
        Log.log(Level.INFO, logger, string);
    }

    public static void detail(Logger logger, String string) {
        Log.log(Level.FINER, logger, string);
    }

    public static void debug(Logger logger, String string) {
        Log.log(Level.FINEST, logger, string);
    }

    public static void log(Level level, Logger logger, String string) {
        logger.log(level, string);
    }

    private static Level makeLevel(String string, Level level, Level level2) {
        return new Sublevel(string, (level.intValue() + level2.intValue()) / 2);
    }

    static {
        Logger logger = Logger.getLogger("");
        for (Handler handler : logger.getHandlers()) {
            Formatter formatter = handler.getFormatter();
            if (!(handler instanceof ConsoleHandler) && !(formatter instanceof SimpleFormatter)) continue;
            handler.setFormatter(new LogFormatter());
        }
        last_ms = System.currentTimeMillis();
    }

    private static class Sublevel
    extends Level {
        Sublevel(String string, int n) {
            super(string, n);
        }
    }

    static class LogFormatter
    extends Formatter {
        private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/DDD/HH:mm:ss.SSS");
        private Pattern pattern = Pattern.compile("[\\n\\r]+");
        private static final String PREFIX = "\n\t";

        LogFormatter() {
        }

        @Override
        public String format(LogRecord logRecord) {
            Date date = new Date(logRecord.getMillis());
            String string = logRecord.getMessage();
            String string2 = this.dateFormat.format(date) + ' ' + logRecord.getLevel() + ' ' + logRecord.getLoggerName();
            String[] stringArray = this.pattern.split(string);
            StringBuilder stringBuilder = new StringBuilder(string.length() + stringArray.length + 2);
            for (String string3 : stringArray) {
                stringBuilder.append(PREFIX).append(string3);
            }
            stringBuilder.append("\n\n");
            return string2 + stringBuilder.toString();
        }
    }
}

