/*
 * Decompiled with CFR 0.152.
 */
package bolt;

import bolt.Client;
import bolt.Header;
import bolt.Log;
import bolt.Message;
import bolt.MessageType;
import bolt.Meta;
import bolt.Options;
import bolt.StringProperty;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class IOManager
extends Thread {
    static final Logger source = Log.createSource("IOManager");
    private List<Client> clients = new ArrayList<Client>(16);
    private List<Client> deaders = new ArrayList<Client>(16);
    private Selector selector;
    private Options options;
    private Selector tickleable;
    private static final boolean DEBUG = false;
    private long check_ms = System.currentTimeMillis();

    void setOptions(Options options) {
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assign(Client client) {
        this.welcome(client);
        List<Client> list = this.clients;
        synchronized (list) {
            this.clients.add(client);
            this.clients.notifyAll();
            this.tickle();
        }
    }

    private void welcome(Client client) {
        Header header = new Header(MessageType.WELCOME);
        Meta meta = new Meta();
        meta.addProperty(new StringProperty("VERSION", "1.0"));
        client.output(new Message(header, meta, null));
        Log.info(source, "welcome: added WELCOME to " + client);
    }

    boolean isAvailable() {
        return this.clients.size() < this.options.clientsPerManager;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.clients.size() > 0) {
                        this.processIO();
                        continue;
                    }
                    this.waitForClient();
                }
            }
            catch (Exception exception) {
                Log.exception(source, exception);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIO() {
        ArrayList<Client> arrayList;
        List<Client> list = this.clients;
        synchronized (list) {
            arrayList = new ArrayList<Client>(this.clients);
        }
        this.checkActivity(arrayList);
        try {
            if (this.openSelector()) {
                this.registerClients(arrayList);
                this.performSelection();
            }
        }
        finally {
            this.closeSelector();
        }
        this.buryDeaders();
    }

    private boolean openSelector() {
        assert (this.selector == null);
        try {
            this.selector = Selector.open();
        }
        catch (IOException iOException) {
            Log.exception(source, iOException);
        }
        return this.selector != null;
    }

    private void registerClients(List<Client> list) {
        this.tickleable = this.selector;
        for (Client client : list) {
            if (client.getChannel() == null) continue;
            int n = 0;
            if (client.getBufferedInput() < this.options.inputBufferLimit) {
                n |= 1;
            }
            if (client.hasOutput()) {
                n |= 4;
            }
            try {
                SelectionKey selectionKey = client.getChannel().register(this.selector, n);
                selectionKey.attach(client);
            }
            catch (ClosedChannelException closedChannelException) {
                this.addDeader(client);
                Log.exception(source, closedChannelException);
            }
        }
    }

    private void performSelection() {
        try {
            this.selector.select(this.options.selectionTimeout_ms);
        }
        catch (IOException iOException) {
            Log.exception(source, iOException);
        }
        finally {
            this.tickleable = null;
        }
        Set<SelectionKey> set = this.selector.selectedKeys();
        long l = System.currentTimeMillis();
        for (SelectionKey selectionKey : set) {
            this.processKey(selectionKey, l);
        }
    }

    private void closeSelector() {
        if (this.selector != null) {
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                Log.exception(source, iOException);
            }
            finally {
                this.selector = null;
            }
        }
    }

    private void processKey(SelectionKey selectionKey, long l) {
        Client client = null;
        if (Client.class.isInstance(selectionKey.attachment())) {
            client = (Client)selectionKey.attachment();
        }
        if (!selectionKey.isValid()) {
            Log.warning(source, "processKey: " + client + " not valid");
            if (client != null) {
                this.addDeader(client);
            }
        } else if (client != null) {
            if (selectionKey.isReadable()) {
                client.readPending(l);
            }
            if (selectionKey.isValid() && selectionKey.isWritable()) {
                client.writePending();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForClient() {
        try {
            List<Client> list = this.clients;
            synchronized (list) {
                this.clients.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            Log.warning(source, "waitForClient interrupted");
        }
        this.tickle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buryDeaders() {
        List<Client> list = this.deaders;
        synchronized (list) {
            for (Client client : this.deaders) {
                client.cleanup();
                Log.monitor(source, "buryDeader " + client);
                List<Client> list2 = this.clients;
                synchronized (list2) {
                    this.clients.remove(client);
                }
            }
            this.deaders.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDeader(Client client) {
        List<Client> list = this.deaders;
        synchronized (list) {
            this.deaders.add(client);
        }
    }

    void tickle() {
        Selector selector = this.tickleable;
        if (selector != null) {
            selector.wakeup();
        }
    }

    private void checkActivity(List<Client> list) {
        long l = System.currentTimeMillis();
        if (l - this.check_ms > (long)this.options.inactivityInterval_ms) {
            this.check_ms = l;
            for (Client client : list) {
                if (client.getChannel() == null) continue;
                client.checkActivity(l);
            }
        }
    }
}

