/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsecapi.jni;

import gov.nasa.gsfc.gmsecapi.Config;
import gov.nasa.gsfc.gmsecapi.Field;
import gov.nasa.gsfc.gmsecapi.GMSEC_Long;
import gov.nasa.gsfc.gmsecapi.GMSEC_String;
import gov.nasa.gsfc.gmsecapi.GMSEC_ULong;
import gov.nasa.gsfc.gmsecapi.GMSEC_UShort;
import gov.nasa.gsfc.gmsecapi.Message;
import gov.nasa.gsfc.gmsecapi.Status;
import gov.nasa.gsfc.gmsecapi.jni.JNIConfig;
import gov.nasa.gsfc.gmsecapi.jni.JNIField;
import gov.nasa.gsfc.gmsecapi.jni.JNIStatus;
import gov.nasa.gsfc.gmsecapi.jni.gmsecJNI;

public class JNIMessage
extends Message {
    public long swigCPtr;
    public boolean swigCMemOwn;

    protected JNIMessage(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    public JNIMessage() {
        this(0L, false);
    }

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            gmsecJNI.delete_Message(this.swigCPtr, this);
            this.swigCMemOwn = false;
        }
        this.swigCPtr = 0L;
    }

    protected static long getCPtr(JNIMessage jNIMessage) {
        return jNIMessage == null ? 0L : jNIMessage.swigCPtr;
    }

    @Override
    public boolean isValid() {
        return this.IsValid();
    }

    @Override
    public boolean IsValid() {
        return this.swigCMemOwn && gmsecJNI.Message_IsValid(this.swigCPtr, this);
    }

    @Override
    public Status SetKind(int n) {
        long l = gmsecJNI.Message_SetKind(this.swigCPtr, this, n);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetKind(GMSEC_UShort gMSEC_UShort) {
        long l = gmsecJNI.Message_GetKind(this.swigCPtr, this, gMSEC_UShort);
        return new JNIStatus(l, true);
    }

    @Override
    public Status SetSubject(String string) {
        long l = gmsecJNI.Message_SetSubject(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetSubject(GMSEC_String gMSEC_String) {
        long l = gmsecJNI.Message_GetSubject(this.swigCPtr, this, gMSEC_String);
        return new JNIStatus(l, true);
    }

    @Override
    public Status AddField(Field field) {
        JNIField jNIField = new JNIField(field);
        long l = gmsecJNI.Message_AddField(this.swigCPtr, this, JNIField.getCPtr(jNIField), jNIField);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetField(String string, Field field) {
        JNIField jNIField = new JNIField();
        long l = gmsecJNI.Message_GetField(this.swigCPtr, this, string, JNIField.getCPtr(jNIField), jNIField);
        JNIStatus jNIStatus = new JNIStatus(l, true);
        if (!((Status)jNIStatus).isError()) {
            field.Set(jNIField);
        }
        return jNIStatus;
    }

    @Override
    public Status GetFieldCount(GMSEC_Long gMSEC_Long) {
        long l = gmsecJNI.Message_GetFieldCount(this.swigCPtr, this, gMSEC_Long);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetFirstField(Field field) {
        JNIField jNIField = new JNIField();
        long l = gmsecJNI.Message_GetFirstField(this.swigCPtr, this, JNIField.getCPtr(jNIField), jNIField);
        JNIStatus jNIStatus = new JNIStatus(l, true);
        field.Set(jNIField);
        return jNIStatus;
    }

    @Override
    public Status GetNextField(Field field) {
        JNIField jNIField = new JNIField();
        long l = gmsecJNI.Message_GetNextField(this.swigCPtr, this, JNIField.getCPtr(jNIField), jNIField);
        JNIStatus jNIStatus = new JNIStatus(l, true);
        field.Set(jNIField);
        return jNIStatus;
    }

    @Override
    public Status SetConfig(Config config) {
        JNIConfig jNIConfig = new JNIConfig(config);
        long l = gmsecJNI.Message_SetConfig(this.swigCPtr, this, JNIConfig.getCPtr(jNIConfig), jNIConfig);
        JNIStatus jNIStatus = new JNIStatus(l, true);
        return jNIStatus;
    }

    @Override
    public Status ToXML(GMSEC_String gMSEC_String) {
        long l = gmsecJNI.Message_ToXML(this.swigCPtr, this, gMSEC_String);
        return new JNIStatus(l, true);
    }

    @Override
    public Status FromXML(String string) {
        long l = gmsecJNI.Message_FromXML(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }

    @Override
    public String ToJSON() {
        return gmsecJNI.Message_ToJSON(this.swigCPtr, this);
    }

    @Override
    public Status FromJSON(String string) {
        long l = gmsecJNI.Message_FromJSON(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }

    @Override
    public Status GetMSGSize(GMSEC_ULong gMSEC_ULong) {
        long l = gmsecJNI.Message_GetMSGSize(this.swigCPtr, this, gMSEC_ULong);
        return new JNIStatus(l, true);
    }

    @Override
    public String GetLibraryRootName() {
        return "gmsec_jni";
    }

    @Override
    public Status ClearFields() {
        long l = gmsecJNI.Message_ClearFields(this.swigCPtr, this);
        return new JNIStatus(l, true);
    }

    @Override
    public Status ClearField(String string) {
        long l = gmsecJNI.Message_ClearField(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }

    @Override
    public void SetTracking(short s) {
    }

    @Override
    public void SetTrackingNode(short s) {
    }

    @Override
    public void SetTrackingProcessId(short s) {
    }

    @Override
    public void SetTrackingConnectionId(short s) {
    }

    @Override
    public void SetTrackingUserName(short s) {
    }

    @Override
    public void SetTrackingPublishTime(short s) {
    }

    @Override
    public void SetTrackingUniqueId(short s) {
    }

    @Override
    public void SetTrackingMwInfo(short s) {
    }

    @Override
    public short GetTracking() {
        return -1;
    }

    @Override
    public short GetTrackingNode() {
        return -1;
    }

    @Override
    public short GetTrackingProcessId() {
        return -1;
    }

    @Override
    public short GetTrackingConnectionId() {
        return -1;
    }

    @Override
    public short GetTrackingUserName() {
        return -1;
    }

    @Override
    public short GetTrackingPublishTime() {
        return -1;
    }

    @Override
    public short GetTrackingUniqueId() {
        return -1;
    }

    @Override
    public short GetTrackingMwInfo() {
        return -1;
    }
}

