/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsecapi.jni;

import gov.nasa.gsfc.gmsecapi.jni.gmsecJNI;
import gov.nasa.gsfc.gmsecapi.util.LogHandler;

public class JNILog {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected JNILog(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            gmsecJNI.delete_Log(this.swigCPtr, this);
            this.swigCMemOwn = false;
        }
        this.swigCPtr = 0L;
    }

    protected static long getCPtr(JNILog jNILog) {
        return jNILog == null ? 0L : jNILog.swigCPtr;
    }

    public JNILog() {
        this(gmsecJNI.new_Log(), true);
    }

    public static void SetReportingLevel(int n) {
        gmsecJNI.Log_SetReportingLevel(n);
    }

    public static int GetReportingLevel() {
        return gmsecJNI.Log_GetReportingLevel();
    }

    public static void RegisterHandler(LogHandler logHandler) {
        gmsecJNI.Log_RegisterHandler(logHandler);
    }

    public static void RegisterHandler(int n, LogHandler logHandler) {
        gmsecJNI.Log_RegisterHandler(n, logHandler);
    }

    public static String LogLevelToString(int n) {
        return gmsecJNI.Log_LogLevelToString(n);
    }

    public static int LogLevelFromString(String string) {
        return gmsecJNI.Log_LogLevelFromString(string);
    }

    public static void LogError(String string) {
        gmsecJNI.Log_LogError(string);
    }

    public static void LogWarning(String string) {
        gmsecJNI.Log_LogWarning(string);
    }

    public static void LogInfo(String string) {
        gmsecJNI.Log_LogInfo(string);
    }

    public static void LogVerbose(String string) {
        gmsecJNI.Log_LogVerbose(string);
    }

    public static void LogDebug(String string) {
        gmsecJNI.Log_LogDebug(string);
    }
}

