/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsecapi.jni;

import gov.nasa.gsfc.gmsecapi.Callback;
import gov.nasa.gsfc.gmsecapi.Config;
import gov.nasa.gsfc.gmsecapi.Connection;
import gov.nasa.gsfc.gmsecapi.ErrorCallback;
import gov.nasa.gsfc.gmsecapi.Message;
import gov.nasa.gsfc.gmsecapi.ReplyCallback;
import gov.nasa.gsfc.gmsecapi.Status;
import gov.nasa.gsfc.gmsecapi.internal.MessageImpl;
import gov.nasa.gsfc.gmsecapi.jni.JNIConfig;
import gov.nasa.gsfc.gmsecapi.jni.JNIMessage;
import gov.nasa.gsfc.gmsecapi.jni.JNIStatus;
import gov.nasa.gsfc.gmsecapi.jni.gmsecJNI;

public class JNIConnection {
    private Connection extconn;
    public long swigCPtr;
    public boolean swigCMemOwn;
    private static final String MESSAGE_CLASS_NAME = "gov.nasa.gsfc.gmsecapi.jni.JNIMessage";

    protected JNIConnection(long l, boolean bl) {
        this.swigCPtr = l;
        this.swigCMemOwn = bl;
    }

    public JNIConnection() {
        this(0L, false);
    }

    protected void finalize() throws Throwable {
        try {
            this.delete();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            gmsecJNI.delete_Connection(this.swigCPtr, this);
            this.swigCMemOwn = false;
        }
        this.swigCPtr = 0L;
    }

    protected static long getCPtr(JNIConnection jNIConnection) {
        return jNIConnection == null ? 0L : jNIConnection.swigCPtr;
    }

    public Status Connect() {
        long l = gmsecJNI.Connection_Connect(this.swigCPtr, this);
        return new JNIStatus(l, true);
    }

    public Status Disconnect() {
        long l = gmsecJNI.Connection_Disconnect(this.swigCPtr, this);
        return new JNIStatus(l, true);
    }

    public synchronized Status Subscribe(String string) {
        if (string == null) {
            return new Status(2, 18L, "Null Subject");
        }
        long l = gmsecJNI.Connection_Subscribe(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }

    public synchronized Status Subscribe(String string, Callback callback) {
        if (string == null) {
            return new Status(2, 18L, "Null Subject");
        }
        if (callback == null) {
            return new Status(2, 12L, "Null Callback");
        }
        long l = gmsecJNI.Connection_Subscribe_Via_Callback(this.swigCPtr, this, string, callback);
        return new JNIStatus(l, true);
    }

    public synchronized Status UnSubscribe(String string) {
        if (string == null) {
            return new Status(2, 18L, "Null Subject");
        }
        long l = gmsecJNI.Connection_UnSubscribe(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }

    public synchronized Status UnSubscribe(String string, Callback callback) {
        if (string == null) {
            return new Status(2, 18L, "Null Subject");
        }
        long l = gmsecJNI.Connection_UnSubscribe_Via_Callback(this.swigCPtr, this, string, callback);
        return new JNIStatus(l, true);
    }

    public synchronized Status RegisterErrorCallback(String string, ErrorCallback errorCallback) {
        if (string == null) {
            return new Status(2, 20L, "Null Event");
        }
        long l = gmsecJNI.Connection_RegisterErrorCallback(this.swigCPtr, this, string, errorCallback);
        return new JNIStatus(l, true);
    }

    public synchronized Status RemoveErrorCallback(String string, ErrorCallback errorCallback) {
        return new Status();
    }

    public Status GetNextMsg(Message message, int n) {
        if (message == null) {
            return new Status(2, 35L, "Null Message");
        }
        JNIMessage jNIMessage = new JNIMessage();
        long l = gmsecJNI.Connection_GetNextMsg(this.swigCPtr, this, jNIMessage, n);
        JNIStatus jNIStatus = new JNIStatus(l, true);
        message.SetImpl(jNIMessage);
        return jNIStatus;
    }

    public Status CreateMessage(Message message) {
        if (message == null) {
            return new Status(2, 35L, "Null Message");
        }
        JNIMessage jNIMessage = new JNIMessage();
        long l = gmsecJNI.Connection_CreateMessage(this.swigCPtr, this, jNIMessage);
        JNIStatus jNIStatus = new JNIStatus(l, true);
        message.SetImpl(jNIMessage);
        return jNIStatus;
    }

    public Status CreateMessage(String string, int n, Message message) {
        if (string == null) {
            return new Status(2, 18L, "Null Subject");
        }
        if (message == null) {
            return new Status(2, 35L, "Null Message");
        }
        JNIMessage jNIMessage = new JNIMessage();
        long l = gmsecJNI.Connection_CreateMessage(this.swigCPtr, this, string, n, jNIMessage);
        JNIStatus jNIStatus = new JNIStatus(l, true);
        message.SetImpl(jNIMessage);
        return jNIStatus;
    }

    public Status CreateMessage(String string, int n, Message message, Config config) {
        if (string == null) {
            return new Status(2, 18L, "Null Subject");
        }
        if (message == null) {
            return new Status(2, 35L, "Null Message");
        }
        if (config == null) {
            return new Status(2, 25L, "Null Config");
        }
        JNIMessage jNIMessage = new JNIMessage();
        JNIConfig jNIConfig = new JNIConfig(config);
        long l = gmsecJNI.Connection_CreateMessageCFG(this.swigCPtr, this, string, n, jNIMessage, JNIConfig.getCPtr(jNIConfig), jNIConfig);
        JNIStatus jNIStatus = new JNIStatus(l, true);
        message.SetImpl(jNIMessage);
        return jNIStatus;
    }

    public Status DestroyMessage(Message message) {
        if (message == null) {
            return new Status(2, 35L, "Null Message");
        }
        MessageImpl messageImpl = message.GetImpl();
        if (messageImpl instanceof JNIMessage) {
            JNIMessage jNIMessage = (JNIMessage)messageImpl;
            if (jNIMessage.swigCMemOwn) {
                long l = gmsecJNI.Connection_DestroyMessage(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage);
                JNIStatus jNIStatus = new JNIStatus(l, true);
                jNIMessage.swigCPtr = 0L;
                jNIMessage.swigCMemOwn = false;
                message.SetImpl(null);
                return jNIStatus;
            }
            return new Status(2, 7L, "Message not owned");
        }
        return new Status(5, 7L, "Message is of invalid type.");
    }

    public Status Publish(Message message) {
        if (message == null) {
            return new Status(2, 35L, "Null Message");
        }
        MessageImpl messageImpl = message.GetImpl();
        if (messageImpl instanceof JNIMessage) {
            JNIMessage jNIMessage = (JNIMessage)messageImpl;
            long l = gmsecJNI.Connection_Publish(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage);
            return new JNIStatus(l, true);
        }
        return new Status(5, 7L, "Message is of invalid type.");
    }

    public Status Request(Message message, int n, Message message2) {
        if (message == null || message2 == null) {
            return new Status(2, 35L, "Null Message");
        }
        MessageImpl messageImpl = message.GetImpl();
        if (messageImpl instanceof JNIMessage) {
            JNIMessage jNIMessage = (JNIMessage)messageImpl;
            JNIMessage jNIMessage2 = new JNIMessage();
            long l = gmsecJNI.Connection_Request(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage, n, jNIMessage2);
            JNIStatus jNIStatus = new JNIStatus(l, true);
            message2.SetImpl(jNIMessage2);
            return jNIStatus;
        }
        return new Status(5, 7L, "Message is of invalid type.");
    }

    public Status Request(Message message, int n, Callback callback) {
        if (message == null) {
            return new Status(2, 35L, "Null Message");
        }
        MessageImpl messageImpl = message.GetImpl();
        if (messageImpl instanceof JNIMessage) {
            JNIMessage jNIMessage = (JNIMessage)messageImpl;
            long l = gmsecJNI.Connection_Request_Via_Callback(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage, n, callback, false);
            return new JNIStatus(l, true);
        }
        return new Status(5, 7L, "Message is of invalid type.");
    }

    public Status Request(Message message, int n, ReplyCallback replyCallback) {
        if (message == null) {
            return new Status(2, 35L, "Null Message");
        }
        MessageImpl messageImpl = message.GetImpl();
        if (messageImpl instanceof JNIMessage) {
            JNIMessage jNIMessage = (JNIMessage)messageImpl;
            long l = gmsecJNI.Connection_Request_Via_Callback(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage, n, replyCallback, true);
            return new JNIStatus(l, true);
        }
        return new Status(5, 7L, "Message is of invalid type.");
    }

    public Status Reply(Message message, Message message2) {
        if (message == null || message2 == null) {
            return new Status(2, 35L, "Null Message");
        }
        MessageImpl messageImpl = message.GetImpl();
        MessageImpl messageImpl2 = message2.GetImpl();
        if (messageImpl instanceof JNIMessage && messageImpl2 instanceof JNIMessage) {
            JNIMessage jNIMessage = (JNIMessage)messageImpl;
            JNIMessage jNIMessage2 = (JNIMessage)messageImpl2;
            long l = gmsecJNI.Connection_Reply(this.swigCPtr, this, JNIMessage.getCPtr(jNIMessage), jNIMessage, JNIMessage.getCPtr(jNIMessage2), jNIMessage2);
            return new JNIStatus(l, true);
        }
        return new Status(5, 7L, "Message is of invalid type.");
    }

    public Status StartAutoDispatch() {
        long l = gmsecJNI.Connection_StartAutoDispatch(this.swigCPtr, this);
        return new JNIStatus(l, true);
    }

    public Status StopAutoDispatch() {
        long l = gmsecJNI.Connection_StopAutoDispatch(this.swigCPtr, this);
        return new JNIStatus(l, true);
    }

    public Status DispatchMsg(Message message) {
        if (message == null) {
            return new Status(2, 35L, "Null Message");
        }
        MessageImpl messageImpl = message.GetImpl();
        if (messageImpl instanceof JNIMessage) {
            JNIMessage jNIMessage = (JNIMessage)messageImpl;
            long l = gmsecJNI.Connection_DispatchMsg(this.swigCPtr, this, jNIMessage.swigCPtr, jNIMessage);
            return new JNIStatus(l, true);
        }
        return new Status(5, 7L, "Message is of invalid type.");
    }

    public Status GetLastDispatcherStatus() {
        long l = gmsecJNI.Connection_GetLastDispatcherStatus(this.swigCPtr, this);
        return new JNIStatus(l, true);
    }

    public Status ExcludeSubject(String string) {
        long l = gmsecJNI.Connection_ExcludeSubject(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }

    public Status RemoveExcludedSubject(String string) {
        long l = gmsecJNI.Connection_RemoveExcludedSubject(this.swigCPtr, this, string);
        return new JNIStatus(l, true);
    }

    public Status CloneMessage(Message message, Message message2) {
        if (message == null || message2 == null) {
            return new Status(2, 35L, "Null Message");
        }
        MessageImpl messageImpl = message.GetImpl();
        if (messageImpl instanceof JNIMessage) {
            JNIMessage jNIMessage = (JNIMessage)messageImpl;
            JNIMessage jNIMessage2 = new JNIMessage();
            message2.SetImpl(jNIMessage2);
            long l = gmsecJNI.Connection_CloneMessage(this.swigCPtr, this, jNIMessage.swigCPtr, jNIMessage, jNIMessage2);
            return new JNIStatus(l, true);
        }
        return new Status(5, 7L, "Message is of invalid type.");
    }

    public String GetLibraryRootName() {
        return gmsecJNI.Connection_GetLibraryRootName(this.swigCPtr, this);
    }

    public String GetLibraryVersion() {
        return gmsecJNI.Connection_GetLibraryVersion(this.swigCPtr, this);
    }

    public long GetPublishQueueMessageCount() {
        return gmsecJNI.Connection_GetPublishQueueMessageCount(this.swigCPtr, this);
    }

    public boolean IsConnected() {
        return gmsecJNI.Connection_IsConnected(this.swigCPtr, this) != 0;
    }

    void setExternal(Connection connection) {
        this.extconn = connection;
    }
}

