/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsecapi.internal;

import gov.nasa.gsfc.gmsecapi.Callback;
import gov.nasa.gsfc.gmsecapi.Connection;
import gov.nasa.gsfc.gmsecapi.GMSEC_String;
import gov.nasa.gsfc.gmsecapi.Message;
import gov.nasa.gsfc.gmsecapi.Status;
import java.util.ArrayList;
import java.util.HashMap;

public class CallbackLookup {
    private ArrayList m_callbacks = new ArrayList();
    private HashMap m_callbackLookups = new HashMap();
    private static final String PREFIX_SYMBOL = ".";

    public Status addCallback(String string, Callback callback) {
        Status status = new Status();
        if (callback == null || string == null) {
            status.Set(8, 12L, "Error in Java class CallbackLookup > Either the callback or the subject is null");
            return status;
        }
        if (string.equals("")) {
            if (!this.m_callbacks.contains(callback)) {
                this.m_callbacks.add(callback);
            }
        } else {
            CallbackLookup callbackLookup;
            String string2 = new String(string);
            String string3 = "";
            int n = string.indexOf(PREFIX_SYMBOL);
            if (n > 0) {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            }
            if ((callbackLookup = (CallbackLookup)this.m_callbackLookups.get(string2)) == null) {
                callbackLookup = new CallbackLookup();
                this.m_callbackLookups.put(string2, callbackLookup);
            }
            if (!string2.equals("")) {
                callbackLookup.addCallback(string3, callback);
            }
        }
        return status;
    }

    public Status DispatchMsg(GMSEC_String gMSEC_String, Connection connection, Message message) {
        String string = gMSEC_String.toString();
        if (string.equals("")) {
            for (Callback callback : this.m_callbacks) {
                callback.OnMessage(connection, message);
            }
        } else {
            CallbackLookup callbackLookup;
            String string2 = new String(string.toString());
            String string3 = "";
            int n = string.indexOf(PREFIX_SYMBOL);
            if (n > 0) {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            }
            if (null != (callbackLookup = (CallbackLookup)this.m_callbackLookups.get("*"))) {
                callbackLookup.DispatchMsg(new GMSEC_String(string3), connection, message);
            }
            if (null != (callbackLookup = (CallbackLookup)this.m_callbackLookups.get(">"))) {
                callbackLookup.DispatchMsg(new GMSEC_String(""), connection, message);
            }
            if (null != (callbackLookup = (CallbackLookup)this.m_callbackLookups.get(string2))) {
                callbackLookup.DispatchMsg(new GMSEC_String(string3), connection, message);
            }
        }
        return new Status();
    }

    public boolean IsSubscribed(String string) {
        if (string.equals("")) {
            if (this.m_callbacks.size() > 0) {
                return true;
            }
        } else {
            CallbackLookup callbackLookup;
            String string2 = new String(string);
            String string3 = "";
            int n = string.indexOf(PREFIX_SYMBOL);
            if (n > 0) {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            }
            if (null != (callbackLookup = (CallbackLookup)this.m_callbackLookups.get(string2))) {
                return callbackLookup.IsSubscribed(string3);
            }
        }
        return false;
    }

    public Status RemoveCallback(String string, Callback callback) {
        Status status = new Status();
        if (string.equals("")) {
            this.m_callbacks.remove(callback);
        } else {
            CallbackLookup callbackLookup;
            String string2 = new String(string);
            String string3 = "";
            int n = string.indexOf(PREFIX_SYMBOL);
            if (n > 0) {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            }
            if (null != (callbackLookup = (CallbackLookup)this.m_callbackLookups.get(string2))) {
                return callbackLookup.RemoveCallback(string3, callback);
            }
            status.Set(2, 12L, "No callback registered.");
        }
        return status;
    }

    public Status RemoveCallbacks(String string) {
        Status status = new Status();
        if (string.equals("")) {
            this.m_callbacks.clear();
        } else {
            CallbackLookup callbackLookup;
            String string2 = new String(string);
            String string3 = "";
            int n = string.indexOf(PREFIX_SYMBOL);
            if (n > 0) {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            }
            if (null != (callbackLookup = (CallbackLookup)this.m_callbackLookups.get(string2))) {
                callbackLookup.RemoveCallbacks(string3);
            }
        }
        return status;
    }
}

