/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsecapi;

import gov.nasa.gsfc.gmsecapi.Config;
import gov.nasa.gsfc.gmsecapi.GMSEC_String;
import gov.nasa.gsfc.gmsecapi.Message;
import gov.nasa.gsfc.gmsecapi.Status;
import gov.nasa.gsfc.gmsecapi.jni.JNIConfigFile;

public class ConfigFile {
    private JNIConfigFile fConfigFile;

    public ConfigFile() {
        this.fConfigFile = new JNIConfigFile();
    }

    public ConfigFile(String string) {
        if (string == null) {
            string = "";
        }
        this.fConfigFile = new JNIConfigFile(string);
    }

    public Status Load() {
        return this.fConfigFile.Load();
    }

    public Status Load(String string) {
        return this.fConfigFile.Load(string);
    }

    public Status Save() {
        return this.Save(null, false);
    }

    public Status Save(String string) {
        return this.Save(string, false);
    }

    public Status Save(String string, boolean bl) {
        return this.fConfigFile.Save(string, bl);
    }

    public Status FromXML(String string) {
        return this.fConfigFile.FromXML(string);
    }

    public Status ToXML(GMSEC_String gMSEC_String) {
        return this.fConfigFile.ToXML(gMSEC_String);
    }

    public boolean IsLoaded() {
        return this.fConfigFile.IsLoaded();
    }

    public Status LookupConfig(String string, Config config) {
        if (string == null) {
            return new Status(3, 17L, "Name is null");
        }
        if (config == null) {
            return new Status(3, 25L, "Config is null");
        }
        return this.fConfigFile.LookupConfig(string, Config.getInternal(config));
    }

    public Status LookupMessage(String string, Message message) {
        if (string == null) {
            return new Status(3, 35L, "Name is null");
        }
        if (message == null || message.GetImpl() == null) {
            return new Status(2, 35L, "Message is null");
        }
        return this.fConfigFile.LookupMessage(string, message);
    }

    public Status LookupSubscription(String string, GMSEC_String gMSEC_String) {
        if (string == null) {
            return new Status(3, 35L, "Name is null");
        }
        if (gMSEC_String == null) {
            return new Status(3, 35L, "Pattern is null");
        }
        return this.fConfigFile.LookupSubscription(string, gMSEC_String);
    }

    public Status AddSubscription(String string, String string2) {
        return this.fConfigFile.AddSubscription(string, string2);
    }

    public Status AddConfig(String string, Config config) {
        return this.fConfigFile.AddConfig(string, config);
    }

    public Status AddMessage(String string, Message message) {
        return this.fConfigFile.AddMessage(string, message);
    }

    public Status AddCustomXML(String string) {
        return this.fConfigFile.AddCustomXML(string);
    }

    public Status RemoveSubscription(String string) {
        return this.fConfigFile.RemoveSubscription(string);
    }

    public Status RemoveConfig(String string) {
        return this.fConfigFile.RemoveConfig(string);
    }

    public Status RemoveMessage(String string) {
        return this.fConfigFile.RemoveMessage(string);
    }

    public Status RemoveCustomXML(String string) {
        return this.fConfigFile.RemoveCustomXML(string);
    }
}

