/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.gmsec.api.mist.message;

import gov.nasa.gsfc.gmsec.api.Config;
import gov.nasa.gsfc.gmsec.api.GMSEC_Exception;
import gov.nasa.gsfc.gmsec.api.Message;
import gov.nasa.gsfc.gmsec.api.jni.mist.message.JNIMistMessage;
import gov.nasa.gsfc.gmsec.api.jni.mist.message.JNIProductFileMessage;
import gov.nasa.gsfc.gmsec.api.mist.ProductFile;
import gov.nasa.gsfc.gmsec.api.mist.ProductFileIterator;
import gov.nasa.gsfc.gmsec.api.mist.Specification;
import gov.nasa.gsfc.gmsec.api.mist.gmsecMIST;
import gov.nasa.gsfc.gmsec.api.mist.message.MistMessage;

public class ProductFileMessage
extends MistMessage {
    public ProductFileMessage(JNIProductFileMessage jNIProductFileMessage) {
        super(jNIProductFileMessage);
    }

    public ProductFileMessage(String string, gmsecMIST.ResponseStatus responseStatus, Message.MessageKind messageKind, String string2, String string3, Specification specification) throws IllegalArgumentException {
        super((JNIMistMessage)null);
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject cannot be null, nor contain an empty string");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("Product Type cannot be null, nor contain an empty string");
        }
        if (string3 == null || string3.isEmpty()) {
            throw new IllegalArgumentException("Product Subtype cannot be null, nor contain an empty string");
        }
        if (specification == null) {
            throw new IllegalArgumentException("Specification cannot be null");
        }
        this.registerChild(new JNIProductFileMessage(string, responseStatus, messageKind, string2, string3, specification));
    }

    public ProductFileMessage(String string, gmsecMIST.ResponseStatus responseStatus, Message.MessageKind messageKind, String string2, String string3, Config config, Specification specification) throws IllegalArgumentException {
        super((JNIMistMessage)null);
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject cannot be null, nor contain an empty string");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("Product Type cannot be null, nor contain an empty string");
        }
        if (string3 == null || string3.isEmpty()) {
            throw new IllegalArgumentException("Product Subtype cannot be null, nor contain an empty string");
        }
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        if (specification == null) {
            throw new IllegalArgumentException("Specification cannot be null");
        }
        this.registerChild(new JNIProductFileMessage(string, responseStatus, messageKind, string2, string3, config, specification));
    }

    public ProductFileMessage(String string, gmsecMIST.ResponseStatus responseStatus, String string2, Specification specification) {
        super((JNIMistMessage)null);
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject cannot be null, nor contain an empty string");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("Schema ID cannot be null, nor contain an empty string");
        }
        if (specification == null) {
            throw new IllegalArgumentException("Specification cannot be null");
        }
        this.registerChild(new JNIProductFileMessage(string, responseStatus, string2, specification));
    }

    public ProductFileMessage(String string, gmsecMIST.ResponseStatus responseStatus, String string2, Config config, Specification specification) {
        super((JNIMistMessage)null);
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Subject cannot be null, nor contain an empty string");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("Schema ID cannot be null, nor contain an empty string");
        }
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        if (specification == null) {
            throw new IllegalArgumentException("Specification cannot be null");
        }
        this.registerChild(new JNIProductFileMessage(string, responseStatus, string2, config, specification));
    }

    public ProductFileMessage(String string) throws IllegalArgumentException, GMSEC_Exception {
        super((JNIMistMessage)null);
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Data cannot be null, nor contain an empty string");
        }
        this.registerChild(new JNIProductFileMessage(string));
    }

    public ProductFileMessage(ProductFileMessage productFileMessage) throws IllegalArgumentException {
        super((JNIMistMessage)null);
        if (productFileMessage == null) {
            throw new IllegalArgumentException("ProductFileMessage cannot be null");
        }
        this.registerChild(new JNIProductFileMessage((JNIProductFileMessage)MistMessage.getInternal(productFileMessage)));
    }

    public void addProductFile(ProductFile productFile) throws IllegalArgumentException {
        if (productFile == null) {
            throw new IllegalArgumentException("ProductFile is null");
        }
        ((JNIProductFileMessage)MistMessage.getInternal(this)).addProductFile(ProductFile.getInternal(productFile));
    }

    public int getNumProductFiles() {
        return ((JNIProductFileMessage)MistMessage.getInternal(this)).getNumProductFiles();
    }

    public ProductFile getProductFile(int n) throws GMSEC_Exception {
        return ((JNIProductFileMessage)MistMessage.getInternal(this)).getProductFile(n);
    }

    public gmsecMIST.ResponseStatus getResponseStatus() {
        return ((JNIProductFileMessage)MistMessage.getInternal(this)).getResponseStatus();
    }

    public String getProductType() {
        return ((JNIProductFileMessage)MistMessage.getInternal(this)).getProductType();
    }

    public String getProductSubtype() {
        return ((JNIProductFileMessage)MistMessage.getInternal(this)).getProductSubtype();
    }

    public ProductFileIterator getProductFileIterator() {
        return ((JNIProductFileMessage)MistMessage.getInternal(this)).getProductFileIterator();
    }

    public static ProductFileMessage convertMessage(Message message) throws IllegalArgumentException {
        if (message == null) {
            throw new IllegalArgumentException("Message is null");
        }
        return JNIProductFileMessage.convertMessage(Message.getInternal(message));
    }
}

